/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.test.utils.JvmVendor;
import org.apache.qpid.test.utils.PortHelper;
import org.apache.qpid.test.utils.QpidUnitTestExtension;
import org.apache.qpid.test.utils.SystemPropertySetter;
import org.apache.qpid.test.utils.VirtualHostNodeStoreType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={QpidUnitTestExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class UnitTestBase {
    public static final String TMP_FOLDER = System.getProperty("java.io.tmpdir");
    private static final String PROFILE_VIRTUALHOSTNODE_TYPE = "virtualhostnode.type";
    private static final PortHelper PORT_HELPER = new PortHelper();
    public final SystemPropertySetter _systemPropertySetter = new SystemPropertySetter();
    private final Set<Runnable> _afterAllTearDownRegistry = new LinkedHashSet<Runnable>();
    private String _testClassName;
    private String _testName;

    @BeforeAll
    public void beforeAll(TestInfo testInfo) {
        this._testClassName = ((Class)testInfo.getTestClass().orElseThrow(() -> new RuntimeException("Failed to resolve test method"))).getSimpleName();
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) {
        this._testName = ((Method)testInfo.getTestMethod().orElseThrow(() -> new RuntimeException("Failed to resolve test method"))).getName();
    }

    @AfterEach
    public void cleanupAfterEach() {
        this._systemPropertySetter.afterEach();
    }

    @AfterAll
    public void cleanupAfterAll() {
        this._afterAllTearDownRegistry.forEach(Runnable::run);
        this._afterAllTearDownRegistry.clear();
    }

    public String getTestClassName() {
        return this._testClassName;
    }

    public String getTestName() {
        return this._testName;
    }

    public void setTestSystemProperty(String property, String value) {
        this._systemPropertySetter.setSystemProperty(property, value);
    }

    public int findFreePort() {
        return PORT_HELPER.getNextAvailable();
    }

    public int getNextAvailable(int fromPort) {
        return PORT_HELPER.getNextAvailable(fromPort);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }

    public void registerAfterAllTearDown(Runnable runnable) {
        this._afterAllTearDownRegistry.add(runnable);
    }

    public static JvmVendor getJvmVendor() {
        return JvmVendor.getJvmVendor();
    }

    public VirtualHostNodeStoreType getVirtualHostNodeStoreType() {
        String type = System.getProperty(PROFILE_VIRTUALHOSTNODE_TYPE, VirtualHostNodeStoreType.MEMORY.name()).toUpperCase();
        return VirtualHostNodeStoreType.valueOf(type);
    }
}

