/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import ch.qos.logback.classic.LoggerContext;
import java.lang.reflect.Method;
import org.apache.qpid.test.utils.TestUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidUnitTestExtension
implements AfterAllCallback,
AfterEachCallback,
BeforeAllCallback,
BeforeEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidUnitTestExtension.class);
    private static final LoggerContext LOGGER_CONTEXT = ((ch.qos.logback.classic.Logger)LOGGER).getLoggerContext();
    private Class<?> _testClass;
    private Method _testMethod;

    public void beforeAll(ExtensionContext extensionContext) {
        this._testClass = TestUtils.getTestClass(extensionContext);
        this.setClassQualifiedTestName(this._testClass.getName());
    }

    public void afterAll(ExtensionContext extensionContext) {
        this._testClass = null;
        this.setClassQualifiedTestName(null);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this._testMethod = TestUtils.getTestMethod(extensionContext);
        LOGGER.info("========================= executing test : {}", (Object)(this._testClass.getSimpleName() + "#" + this._testMethod.getName()));
        this.setClassQualifiedTestName(this._testClass.getName() + "." + this._testMethod.getName());
        LOGGER.info("========================= start executing test : {}", (Object)(this._testClass.getSimpleName() + "#" + this._testMethod.getName()));
    }

    public void afterEach(ExtensionContext extensionContext) {
        LOGGER.info("========================= stop executing test : {} ", (Object)(this._testClass.getSimpleName() + "#" + this._testMethod.getName()));
        this.setClassQualifiedTestName(this._testClass.getName());
        LOGGER.info("========================= cleaning up test environment for test : {}", (Object)(this._testClass.getSimpleName() + "#" + this._testMethod.getName()));
        this._testMethod = null;
    }

    private void setClassQualifiedTestName(String name) {
        LOGGER_CONTEXT.putProperty("classQualifiedTestName", name);
    }
}

