/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.test.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.server.KdcConfigKey;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedKdcExtension
implements BeforeAllCallback,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedKdcExtension.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final AtomicInteger PORT = new AtomicInteger();
    private static final boolean CLEAN_UP = Boolean.parseBoolean(System.getProperty("qpid.test.cleanUpKdcArtifacts", "true"));
    private final SimpleKdcServer _simpleKdcServer;
    private final String _realm;
    private final List<File> _createdFiles = new ArrayList<File>();
    private final Path _kdcDirectory;
    private final int _port;
    private boolean _started = false;

    public EmbeddedKdcExtension(String host, int port, String serviceName, String realm) {
        int p;
        this._port = port;
        this._realm = realm;
        this._kdcDirectory = Paths.get("target", "simple-kdc-" + COUNTER.incrementAndGet());
        try {
            this.createWorkDirectory(this._kdcDirectory);
            this._simpleKdcServer = new SimpleKdcServer();
        }
        catch (IOException | KrbException e) {
            throw new AssertionError(String.format("Unable to create SimpleKdcServer': %s", e.getMessage()), e);
        }
        this._simpleKdcServer.setKdcHost(host);
        int n = p = port == 0 ? PORT.get() : port;
        if (p > 0) {
            this._simpleKdcServer.setKdcTcpPort(p);
        }
        this._simpleKdcServer.setAllowUdp(false);
        this._simpleKdcServer.setKdcRealm(realm);
        this._simpleKdcServer.getKdcConfig().setString((ConfigKey)KdcConfigKey.KDC_SERVICE_NAME, serviceName);
        this._simpleKdcServer.setWorkDir(this._kdcDirectory.toFile());
    }

    public void beforeAll(ExtensionContext ctx) throws Exception {
        if (this._started) {
            return;
        }
        this._started = true;
        this._simpleKdcServer.init();
        if (this._port == 0) {
            PORT.compareAndSet(0, this._simpleKdcServer.getKdcSetting().checkGetKdcTcpPort());
        }
        this._simpleKdcServer.start();
        LOGGER.debug("SimpleKdcServer started on port {}, realm '{}' with work dir '{}'", new Object[]{this.getPort(), this.getRealm(), this._kdcDirectory});
        String config = String.join((CharSequence)"", Files.readAllLines(Paths.get(System.getProperty("java.security.krb5.conf"), new String[0])));
        LOGGER.debug("java.security.krb5.conf='{}'", (Object)System.getProperty("java.security.krb5.conf"));
        Path krb5Conf = Paths.get(this._kdcDirectory.toString(), "krb5.conf");
        LOGGER.debug("JAAS config:" + config);
        if (!CLEAN_UP) {
            Files.copy(krb5Conf, Paths.get(this._kdcDirectory.toString(), "krb5.conf.copy"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public void close() {
        try {
            this._simpleKdcServer.stop();
        }
        catch (KrbException e) {
            LOGGER.warn("Failure to stop KDC server", (Throwable)e);
        }
        finally {
            if (CLEAN_UP) {
                this.cleanUp();
            }
        }
    }

    private void delete(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                if (!file.delete()) {
                    LOGGER.warn("Could not delete file at {}", (Object)file.getAbsolutePath());
                }
            });
        }
    }

    public File createPrincipal(String keyTabFileName, String ... principals) throws Exception {
        Path keyTabPath = Paths.get("target", keyTabFileName).toAbsolutePath().normalize();
        File keyTabFile = keyTabPath.toFile();
        this._createdFiles.add(keyTabFile);
        this.createPrincipal(keyTabFile, principals);
        return keyTabFile;
    }

    private void createPrincipal(File keyTabFile, String ... principals) throws Exception {
        this._simpleKdcServer.createPrincipals(principals);
        if (keyTabFile.exists() && !keyTabFile.delete()) {
            LOGGER.error("Failed to delete keytab file: " + String.valueOf(keyTabFile));
        }
        for (String principal : principals) {
            this._simpleKdcServer.getKadmin().exportKeytab(keyTabFile, principal);
        }
    }

    private void createWorkDirectory(Path kdcDir) throws IOException {
        try {
            Files.createDirectory(kdcDir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            this.delete(kdcDir);
            Files.createDirectory(kdcDir, new FileAttribute[0]);
        }
    }

    private void cleanUp() {
        try {
            this.delete(this._kdcDirectory);
        }
        catch (IOException e) {
            LOGGER.warn("Failure to delete KDC directory", (Throwable)e);
        }
        for (File file : this._createdFiles) {
            if (file.delete()) continue;
            LOGGER.warn("Failure to delete file {}", (Object)file.getAbsolutePath());
        }
    }

    public int getPort() {
        return this._simpleKdcServer.getKdcSetting().getKdcTcpPort();
    }

    public String getRealm() {
        return this._realm;
    }
}

