/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageConverter;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.jms.MessageProducer;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.util.UUIDGen;
import org.apache.qpid.util.UUIDs;
import org.slf4j.Logger;

public abstract class BasicMessageProducer
extends Closeable
implements MessageProducer {
    private final Logger _logger;
    private AMQConnection _connection;
    private boolean _disableTimestamps;
    private int _messagePriority = 4;
    private long _timeToLive;
    private int _deliveryMode = 2;
    private AMQDestination _destination;
    private boolean _transacted;
    private int _channelId;
    private long _producerId;
    private AMQSession _session;
    private final boolean _immediate;
    private final Boolean _mandatory;
    private boolean _disableMessageId;
    private UUIDGen _messageIdGenerator = UUIDs.newGenerator();
    private String _userID;
    private final boolean _defaultImmediateValue = Boolean.parseBoolean(System.getProperty("qpid.default_immediate", "false"));
    private final boolean _defaultMandatoryValue = Boolean.parseBoolean(System.getProperty("qpid.default_mandatory", "true"));
    private final boolean _defaultMandatoryTopicValue = Boolean.parseBoolean(System.getProperty("qpid.default_mandatory_topic", System.getProperties().containsKey("qpid.default_mandatory") ? System.getProperty("qpid.default_mandatory") : "false"));
    private PublishMode _publishMode = PublishMode.ASYNC_PUBLISH_ALL;

    protected BasicMessageProducer(Logger logger, AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, long producerId, Boolean immediate, Boolean mandatory) throws QpidException {
        this._logger = logger;
        this._connection = connection;
        this._destination = destination;
        this._transacted = transacted;
        this._channelId = channelId;
        this._session = session;
        this._producerId = producerId;
        if (destination != null && !destination.neverDeclare()) {
            this.declareDestination(destination);
        }
        boolean bl = this._immediate = immediate == null ? this._defaultImmediateValue : immediate;
        this._mandatory = mandatory == null ? (destination == null ? null : Boolean.valueOf(destination instanceof Topic ? this._defaultMandatoryTopicValue : this._defaultMandatoryValue)) : mandatory;
        this._userID = connection.isPopulateUserId() ? connection.getUsername() : null;
        this.setPublishMode();
    }

    protected AMQConnection getConnection() {
        return this._connection;
    }

    void setPublishMode() {
        String syncPub = this._connection.getSyncPublish();
        if (syncPub.equals("persistent") || this._connection.getSyncPersistence()) {
            this._publishMode = PublishMode.SYNC_PUBLISH_PERSISTENT;
        } else if (syncPub.equals("all")) {
            this._publishMode = PublishMode.SYNC_PUBLISH_ALL;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("MessageProducer " + this.toString() + " using publish mode : " + (Object)((Object)this._publishMode));
        }
    }

    void resubscribe() throws QpidException {
        if (this._destination != null && !this._destination.neverDeclare()) {
            this.declareDestination(this._destination);
        }
    }

    abstract void declareDestination(AMQDestination var1) throws QpidException;

    public void setDisableMessageID(boolean b) throws JMSException {
        this.checkPreConditions();
        this.checkNotClosed();
        this._disableMessageId = b;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkNotClosed();
        return this._disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.checkPreConditions();
        this._disableTimestamps = b;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkNotClosed();
        return this._disableTimestamps;
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.checkPreConditions();
        if (i != 1 && i != 2) {
            throw new JMSException("DeliveryMode must be either NON_PERSISTENT or PERSISTENT. Value of " + i + " is illegal");
        }
        this._deliveryMode = i;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkNotClosed();
        return this._deliveryMode;
    }

    public void setPriority(int i) throws JMSException {
        this.checkPreConditions();
        if (i < 0 || i > 9) {
            throw new IllegalArgumentException("Priority of " + i + " is illegal. Value must be in range 0 to 9");
        }
        this._messagePriority = i;
    }

    public int getPriority() throws JMSException {
        this.checkNotClosed();
        return this._messagePriority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkPreConditions();
        if (l < 0L) {
            throw new IllegalArgumentException("Time to live must be non-negative - supplied value was " + l);
        }
        this._timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkNotClosed();
        return this._timeToLive;
    }

    protected AMQDestination getAMQDestination() {
        return this._destination;
    }

    public Destination getDestination() throws JMSException {
        this.checkNotClosed();
        return this._destination;
    }

    @Override
    public void close() throws JMSException {
        this.setClosed();
        this._session.deregisterProducer(this._producerId);
        AMQDestination dest = this.getAMQDestination();
        AMQSession ssn = this.getSession();
        if (!ssn.isClosed() && dest != null && dest.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            try {
                if (dest.getDelete() == AMQDestination.AddressOption.ALWAYS || dest.getDelete() == AMQDestination.AddressOption.SENDER) {
                    ssn.handleNodeDelete(dest);
                }
                ssn.handleLinkDelete(dest);
            }
            catch (TransportException e) {
                throw this.getSession().toJMSException("Exception while closing producer:" + e.getMessage(), e);
            }
            catch (QpidException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Exception while closing producer:" + e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, boolean immediate) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkInitialDestination();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, message, deliveryMode, priority, timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory == null ? (destination instanceof Topic ? this._defaultMandatoryTopicValue : this._defaultMandatoryValue) : this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, this._mandatory == null ? (destination instanceof Topic ? this._defaultMandatoryTopicValue : this._defaultMandatoryValue) : this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.checkPreConditions();
        this.checkDestination(destination);
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, message, deliveryMode, priority, timeToLive, mandatory, immediate);
        }
    }

    private AbstractJMSMessage convertToNativeMessage(Message message) throws JMSException {
        if (message instanceof AbstractJMSMessage) {
            return (AbstractJMSMessage)message;
        }
        AbstractJMSMessage newMessage = message instanceof BytesMessage ? new MessageConverter(this._session, (BytesMessage)message).getConvertedMessage() : (message instanceof MapMessage ? new MessageConverter(this._session, (MapMessage)message).getConvertedMessage() : (message instanceof ObjectMessage ? new MessageConverter(this._session, (ObjectMessage)message).getConvertedMessage() : (message instanceof TextMessage ? new MessageConverter(this._session, (TextMessage)message).getConvertedMessage() : (message instanceof StreamMessage ? new MessageConverter(this._session, (StreamMessage)message).getConvertedMessage() : new MessageConverter(this._session, message).getConvertedMessage()))));
        if (newMessage != null) {
            return newMessage;
        }
        throw new JMSException("Unable to send message, due to class conversion error: " + message.getClass().getName());
    }

    private void validateDestination(Destination destination) throws JMSException {
        if (!(destination instanceof AMQDestination)) {
            throw new InvalidDestinationException("Unsupported destination class: " + (destination != null ? destination.getClass() : null));
        }
        AMQDestination amqDestination = (AMQDestination)destination;
        if (!amqDestination.isExchangeExistsChecked()) {
            try {
                this.declareDestination(amqDestination);
            }
            catch (Exception e) {
                throw JMSExceptionHelper.chainJMSException((JMSException)new InvalidDestinationException("Error validating destination"), e);
            }
            amqDestination.setExchangeExistsChecked(true);
        }
    }

    protected void sendImpl(AMQDestination destination, Message origMessage, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.checkTemporaryDestination(destination);
        origMessage.setJMSDestination((Destination)destination);
        AbstractJMSMessage message = this.convertToNativeMessage(origMessage);
        UUID messageId = null;
        if (this._disableMessageId) {
            message.setJMSMessageID((UUID)null);
        } else {
            messageId = this._messageIdGenerator.generate();
            message.setJMSMessageID(messageId);
        }
        try {
            this.sendMessage(destination, origMessage, message, messageId, deliveryMode, priority, timeToLive, mandatory, immediate);
        }
        catch (TransportException e) {
            throw this.getSession().toJMSException("Exception whilst sending:" + e.getMessage(), e);
        }
        if (message != origMessage) {
            this._logger.debug("Updating original message");
            origMessage.setJMSPriority(message.getJMSPriority());
            origMessage.setJMSTimestamp(message.getJMSTimestamp());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Setting JMSExpiration:" + message.getJMSExpiration());
            }
            origMessage.setJMSExpiration(message.getJMSExpiration());
            origMessage.setJMSMessageID(message.getJMSMessageID());
        }
        if (this._transacted) {
            this._session.markDirty();
        }
    }

    abstract void sendMessage(AMQDestination var1, Message var2, AbstractJMSMessage var3, UUID var4, int var5, int var6, long var7, boolean var9, boolean var10) throws JMSException;

    private void checkTemporaryDestination(AMQDestination destination) throws InvalidDestinationException {
        if (destination instanceof TemporaryDestination) {
            this._logger.debug("destination is temporary destination");
            TemporaryDestination tempDest = (TemporaryDestination)((Object)destination);
            if (tempDest.getSession().isClosed()) {
                this._logger.debug("session is closed");
                throw new InvalidDestinationException("Session for temporary destination has been closed");
            }
            if (tempDest.isDeleted()) {
                this._logger.debug("destination is deleted");
                throw new InvalidDestinationException("Cannot send to a deleted temporary destination");
            }
        }
    }

    private void checkPreConditions() throws JMSException {
        this.checkNotClosed();
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException("Invalid Session");
        }
        if (this._session.getAMQConnection().isClosed()) {
            throw new IllegalStateException("Connection closed");
        }
    }

    private void checkInitialDestination() throws JMSException {
        if (this._destination == null) {
            throw new UnsupportedOperationException("Destination is null");
        }
        this.checkValidQueue();
    }

    private void checkDestination(Destination suppliedDestination) throws JMSException {
        if (this._destination != null && suppliedDestination != null) {
            throw new UnsupportedOperationException("This message producer was created with a Destination, therefore you cannot use an unidentified Destination");
        }
        if (suppliedDestination instanceof AMQQueue) {
            AMQQueue destination = (AMQQueue)suppliedDestination;
            this.checkValidQueue(destination);
        }
        if (suppliedDestination == null) {
            throw new InvalidDestinationException("Supplied Destination was invalid");
        }
    }

    private void checkValidQueue() throws JMSException {
        if (this._destination instanceof AMQQueue) {
            this.checkValidQueue((AMQQueue)this._destination);
        }
    }

    private void checkValidQueue(AMQQueue destination) throws JMSException {
        if (!destination.isCheckedForQueueBinding() && this.validateQueueOnSend()) {
            if (this.getSession().isStrictAMQP()) {
                this.getLogger().warn("AMQP does not support destination validation before publish");
                destination.setCheckedForQueueBinding(true);
            } else if (this.isBound(destination)) {
                destination.setCheckedForQueueBinding(true);
            } else {
                throw new InvalidDestinationException("Queue: " + destination.getQueueName() + " is not a valid destination (no binding on server)");
            }
        }
    }

    private boolean validateQueueOnSend() {
        return this._connection.validateQueueOnSend();
    }

    public AMQSession getSession() {
        return this._session;
    }

    public boolean isBound(AMQDestination destination) throws JMSException {
        try {
            return this._session.isQueueBound(destination.getExchangeName(), null, destination.getRoutingKey());
        }
        catch (TransportException e) {
            throw this.getSession().toJMSException("Exception whilst checking destination binding:" + e.getMessage(), e);
        }
    }

    protected boolean isDisableTimestamps() {
        return this._disableTimestamps;
    }

    protected void setDisableTimestamps(boolean disableTimestamps) {
        this._disableTimestamps = disableTimestamps;
    }

    protected void setDestination(AMQDestination destination) {
        this._destination = destination;
    }

    protected int getChannelId() {
        return this._channelId;
    }

    protected void setChannelId(int channelId) {
        this._channelId = channelId;
    }

    protected void setSession(AMQSession session) {
        this._session = session;
    }

    protected String getUserID() {
        return this._userID;
    }

    protected void setUserID(String userID) {
        this._userID = userID;
    }

    protected PublishMode getPublishMode() {
        return this._publishMode;
    }

    protected void setPublishMode(PublishMode publishMode) {
        this._publishMode = publishMode;
    }

    Logger getLogger() {
        return this._logger;
    }

    static enum PublishMode {
        ASYNC_PUBLISH_ALL,
        SYNC_PUBLISH_PERSISTENT,
        SYNC_PUBLISH_ALL;

    }
}

