/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.ResponseType;
import org.apache.qpid.server.management.plugin.controller.ControllerManagementResponse;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;

public class GenericLegacyConfiguredObject
implements LegacyConfiguredObject {
    private final LegacyManagementController _managementController;
    private final LegacyConfiguredObject _nextVersionLegacyConfiguredObject;
    private final String _category;

    public GenericLegacyConfiguredObject(LegacyManagementController managementController, LegacyConfiguredObject nextVersionLegacyConfiguredObject, String category) {
        this._nextVersionLegacyConfiguredObject = nextVersionLegacyConfiguredObject;
        this._managementController = managementController;
        this._category = category;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return this._nextVersionLegacyConfiguredObject.getAttributeNames();
    }

    @Override
    public Object getAttribute(String name) {
        return this.convertLegacyConfiguredObjectIfRequired(this._nextVersionLegacyConfiguredObject.getAttribute(name));
    }

    @Override
    public Object getActualAttribute(String name) {
        return this._nextVersionLegacyConfiguredObject.getActualAttribute(name);
    }

    @Override
    public Collection<LegacyConfiguredObject> getChildren(String category) {
        Collection<LegacyConfiguredObject> children = this._nextVersionLegacyConfiguredObject.getChildren(category);
        if (children != null) {
            return children.stream().map(this._managementController::convertFromNextVersion).collect(Collectors.toSet());
        }
        return Set.of();
    }

    @Override
    public String getCategory() {
        return this._category;
    }

    @Override
    public ManagementResponse invoke(String operation, Map<String, Object> parameters, boolean isSecure) {
        ManagementResponse result = this._nextVersionLegacyConfiguredObject.invoke(operation, parameters, isSecure);
        return this.convertLegacyConfiguredObjectIfRequired(result);
    }

    @Override
    public LegacyConfiguredObject getNextVersionConfiguredObject() {
        return this._nextVersionLegacyConfiguredObject;
    }

    @Override
    public LegacyConfiguredObject getParent(String category) {
        LegacyConfiguredObject parent = this._nextVersionLegacyConfiguredObject.getParent(category);
        return this._managementController.convertFromNextVersion(parent);
    }

    @Override
    public boolean isSecureAttribute(String name) {
        return this._nextVersionLegacyConfiguredObject.isSecureAttribute(name);
    }

    @Override
    public boolean isOversizedAttribute(String name) {
        return this._nextVersionLegacyConfiguredObject.isOversizedAttribute(name);
    }

    @Override
    public String getContextValue(String contextKey) {
        return this._nextVersionLegacyConfiguredObject.getContextValue(contextKey);
    }

    @Override
    public Map<String, Object> getStatistics() {
        return this._nextVersionLegacyConfiguredObject.getStatistics();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericLegacyConfiguredObject that = (GenericLegacyConfiguredObject)o;
        return Objects.equals(this._nextVersionLegacyConfiguredObject, that._nextVersionLegacyConfiguredObject);
    }

    public int hashCode() {
        return Objects.hash(this._nextVersionLegacyConfiguredObject);
    }

    public LegacyManagementController getManagementController() {
        return this._managementController;
    }

    protected LegacyConfiguredObject getNextVersionLegacyConfiguredObject() {
        return this._nextVersionLegacyConfiguredObject;
    }

    private Object convertLegacyConfiguredObjectIfRequired(Object value) {
        Collection collection;
        if (value instanceof LegacyConfiguredObject) {
            return this._managementController.convertFromNextVersion((LegacyConfiguredObject)value);
        }
        if (value instanceof Collection && (collection = (Collection)value).size() > 0 && collection.iterator().next() instanceof LegacyConfiguredObject) {
            return collection.stream().filter(o -> o instanceof LegacyConfiguredObject).map(LegacyConfiguredObject.class::cast).map(this._managementController::convertFromNextVersion).collect(Collectors.toSet());
        }
        return value;
    }

    private ManagementResponse convertLegacyConfiguredObjectIfRequired(ManagementResponse response) {
        if (response.getType() == ResponseType.MODEL_OBJECT) {
            Object body = this.convertLegacyConfiguredObjectIfRequired(response.getBody());
            return new ControllerManagementResponse(response.getType(), body, response.getResponseCode(), response.getHeaders());
        }
        return response;
    }
}

