/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.qpid.server.License;
import org.apache.qpid.server.protocol.v1_0.CompositeType;

public class CompositeTypeConstructorGenerator
extends AbstractProcessor {
    private static final List<String> RESTRICTED_TYPES = Arrays.asList("org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError", "org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError", "org.apache.qpid.server.protocol.v1_0.type.transport.SessionError", "org.apache.qpid.server.protocol.v1_0.type.transport.LinkError", "org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionErrors", "org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode", "org.apache.qpid.server.protocol.v1_0.type.transport.SenderSettleMode", "org.apache.qpid.server.protocol.v1_0.type.transport.Role", "org.apache.qpid.server.protocol.v1_0.type.security.SaslCode", "org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionDetectionPolicy", "org.apache.qpid.server.protocol.v1_0.type.extensions.soleconn.SoleConnectionEnforcementPolicy", "org.apache.qpid.server.protocol.v1_0.type.messaging.StdDistMode", "org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability", "org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy", "org.apache.qpid.server.protocol.v1_0.type.transaction.TxnCapability");

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(CompositeType.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            return true;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            for (Element element : roundEnvironment.getElementsAnnotatedWith(CompositeType.class)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                this.generateCompositeTypeConstructor(filer, (TypeElement)element);
            }
        }
        catch (Exception e) {
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter pw = new PrintWriter(stringWriter);){
                e.printStackTrace(pw);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unexpected Error: " + stringWriter.toString());
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + iOException.getLocalizedMessage());
            }
        }
        return true;
    }

    private void generateCompositeTypeConstructor(Filer filer, TypeElement typeElement) {
        String objectQualifiedClassName = typeElement.getQualifiedName().toString();
        String objectSimpleName = typeElement.getSimpleName().toString();
        String compositeTypeConstructorNameSimpleName = objectSimpleName + "Constructor";
        PackageElement packageElement = (PackageElement)typeElement.getEnclosingElement();
        String compositeTypeConstructorPackage = String.valueOf(packageElement.getQualifiedName()) + ".codec";
        String compositeTypeConstructorName = compositeTypeConstructorPackage + "." + compositeTypeConstructorNameSimpleName;
        CompositeType annotation = typeElement.getAnnotation(CompositeType.class);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating composite constructor file for " + objectQualifiedClassName);
        try {
            JavaFileObject factoryFile = filer.createSourceFile(compositeTypeConstructorName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            for (String headerLine : License.LICENSE) {
                pw.println(" *" + headerLine);
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(compositeTypeConstructorPackage);
            pw.println(";");
            pw.println();
            pw.println("import java.util.List;");
            pw.println();
            pw.println("import org.apache.qpid.server.protocol.v1_0.codec.AbstractCompositeTypeConstructor;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.type.Symbol;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;");
            pw.println("import org.apache.qpid.server.protocol.v1_0.type.transport.Error;");
            pw.println("import " + objectQualifiedClassName + ";");
            pw.println();
            pw.println("public final class " + compositeTypeConstructorNameSimpleName + " extends AbstractCompositeTypeConstructor<" + objectSimpleName + ">");
            pw.println("{");
            pw.println("    private static final " + compositeTypeConstructorNameSimpleName + " INSTANCE = new " + compositeTypeConstructorNameSimpleName + "();");
            pw.println();
            pw.println("    public static void register(DescribedTypeConstructorRegistry registry)");
            pw.println("    {");
            pw.println("        registry.register(Symbol.valueOf(\"" + annotation.symbolicDescriptor() + "\"), INSTANCE);");
            pw.println(String.format("        registry.register(UnsignedLong.valueOf(%#016x), INSTANCE);", annotation.numericDescriptor()));
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    protected String getTypeName()");
            pw.println("    {");
            pw.println("        return " + objectSimpleName + ".class.getSimpleName();");
            pw.println("    }");
            pw.println();
            pw.println("    @Override");
            pw.println("    protected " + objectSimpleName + " construct(final FieldValueReader fieldValueReader) throws AmqpErrorException");
            pw.println("    {");
            pw.println("        " + objectSimpleName + " obj = new " + objectSimpleName + "();");
            pw.println();
            this.generateAssigners(pw, typeElement);
            pw.println("        return obj;");
            pw.println("    }");
            pw.println("}");
            pw.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write composite constructor file: " + compositeTypeConstructorName + " - " + e.getLocalizedMessage());
        }
    }

    private void generateAssigners(PrintWriter pw, TypeElement typeElement) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        ArrayList<AnnotatedField> annotatedFields = new ArrayList<AnnotatedField>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!(element instanceof VariableElement) || element.getKind() != ElementKind.FIELD) continue;
            boolean annotationFound = false;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals("org.apache.qpid.server.protocol.v1_0.CompositeTypeField")) continue;
                if (annotationFound) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("More than one CompositeTypeField annotations on field '%s.%s'", typeElement.getSimpleName(), element.getSimpleName()));
                }
                annotationFound = true;
                annotatedFields.add(new AnnotatedField((VariableElement)element, annotationMirror));
            }
        }
        annotatedFields.sort(Comparator.comparingInt(AnnotatedField::getIndex));
        for (int index = 0; index < annotatedFields.size(); ++index) {
            AnnotatedField annotatedField = (AnnotatedField)annotatedFields.get(index);
            VariableElement variableElement = annotatedField.getVariableElement();
            String fieldName = this.stripUnderscore(variableElement.getSimpleName().toString());
            if (annotatedField.getIndex() != index) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unexpected CompositeTypeField index '%d' is specified on field '%s' of '%s'. Expected %d.", annotatedField.getIndex(), fieldName, typeElement.getSimpleName(), index));
            }
            String string = "        ";
            if (variableElement.asType().getKind() == TypeKind.ARRAY) {
                TypeMirror componentType = ((ArrayType)variableElement.asType()).getComponentType();
                String functionString = annotatedField.getFactory() != null ? "x -> " + annotatedField.getFactory() + "(x)" : (RESTRICTED_TYPES.contains(componentType) ? variableElement.asType().toString() + "::valueOf" : "x -> (" + String.valueOf(componentType) + ") x");
                pw.println(String.format("        %s %s = fieldValueReader.readArrayValue(%d, \"%s\", %s, %s.class, %s);", annotatedField.getVariableElement().asType(), fieldName, index, fieldName, annotatedField.isMandatory(), componentType, functionString));
                this.optionallyWrapInNullCheck(!annotatedField.isMandatory(), pw, "        ", fieldName, indent -> pw.println(indent + "obj." + this.getSetterName(variableElement) + "(" + fieldName + ");"));
            } else if (annotatedField.getFactory() != null || RESTRICTED_TYPES.contains(variableElement.asType().toString())) {
                String functionName = annotatedField.getFactory() != null ? annotatedField.getFactory() : variableElement.asType().toString() + ".valueOf";
                pw.println(String.format("        Object %s = fieldValueReader.readValue(%d, \"%s\", %s, Object.class);", fieldName, index, fieldName, annotatedField.isMandatory()));
                this.optionallyWrapInNullCheck(!annotatedField.isMandatory(), pw, "        ", fieldName, indent -> {
                    pw.println(indent + "try");
                    pw.println(indent + "{");
                    pw.println(indent + "    obj." + this.getSetterName(variableElement) + "(" + functionName + "(" + fieldName + "));");
                    pw.println(indent + "}");
                    pw.println(indent + "catch (RuntimeException e)");
                    pw.println(indent + "{");
                    pw.println(indent + "    Error error = new Error(AmqpError.DECODE_ERROR, \"Could not decode value field '" + fieldName + "' of '" + String.valueOf(typeElement.getSimpleName()) + "'\");");
                    pw.println(indent + "    throw new AmqpErrorException(error, e);");
                    pw.println(indent + "}");
                });
            } else if (typeUtils.isSameType(typeUtils.erasure(variableElement.asType()), CompositeTypeConstructorGenerator.getErasure(this.processingEnv, "java.util.Map"))) {
                List<? extends TypeMirror> args = ((DeclaredType)variableElement.asType()).getTypeArguments();
                if (args.size() != 2) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Map types must have exactly two type arguments");
                }
                pw.println(String.format("        %s %s = fieldValueReader.readMapValue(%d, \"%s\", %s, %s.class, %s.class);", annotatedField.getVariableElement().asType(), fieldName, index, fieldName, annotatedField.isMandatory(), args.get(0), args.get(1)));
                this.optionallyWrapInNullCheck(!annotatedField.isMandatory(), pw, "        ", fieldName, indent -> pw.println(indent + "obj." + this.getSetterName(variableElement) + "(" + fieldName + ");"));
            } else {
                pw.println(String.format("        %s %s = fieldValueReader.readValue(%d, \"%s\", %s, %s.class);", annotatedField.getVariableElement().asType(), fieldName, index, fieldName, annotatedField.isMandatory(), annotatedField.getVariableElement().asType()));
                this.optionallyWrapInNullCheck(!annotatedField.isMandatory(), pw, "        ", fieldName, indent -> pw.println(indent + "obj." + this.getSetterName(variableElement) + "(" + fieldName + ");"));
            }
            pw.println();
        }
    }

    private void optionallyWrapInNullCheck(boolean wrap, PrintWriter pw, String indent, String fieldName, Consumer<String> f) {
        if (wrap) {
            pw.println((String)indent + "if (" + fieldName + " != null)");
            pw.println((String)indent + "{");
            indent = "    " + (String)indent;
        }
        f.accept((String)indent);
        if (wrap) {
            indent = ((String)indent).substring(4);
            pw.println((String)indent + "}");
        }
    }

    private String getSetterName(VariableElement variableElement) {
        String fieldName = this.stripUnderscore(variableElement.getSimpleName().toString());
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private String stripUnderscore(String fieldName) {
        if (fieldName.startsWith("_")) {
            return fieldName.substring(1);
        }
        return fieldName;
    }

    private static TypeMirror getErasure(ProcessingEnvironment processingEnv, String className) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }

    private static class AnnotatedField {
        private final VariableElement _variableElement;
        private final AnnotationMirror _annotationMirror;
        private final int _index;
        private final String _factory;
        private final boolean _mandatory;

        public AnnotatedField(VariableElement variableElement, AnnotationMirror annotationMirror) {
            this._variableElement = variableElement;
            this._annotationMirror = annotationMirror;
            String factory = null;
            boolean mandatory = false;
            int index = -1;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if ("index".contentEquals(entry.getKey().getSimpleName())) {
                    index = (Integer)entry.getValue().getValue();
                    continue;
                }
                if ("deserializationConverter".contentEquals(entry.getKey().getSimpleName())) {
                    factory = (String)entry.getValue().getValue();
                    continue;
                }
                if (!"mandatory".contentEquals(entry.getKey().getSimpleName())) continue;
                mandatory = (Boolean)entry.getValue().getValue();
            }
            this._index = index;
            this._mandatory = mandatory;
            this._factory = factory;
        }

        public VariableElement getVariableElement() {
            return this._variableElement;
        }

        public AnnotationMirror getAnnotationMirror() {
            return this._annotationMirror;
        }

        public int getIndex() {
            return this._index;
        }

        public String getFactory() {
            return this._factory;
        }

        public boolean isMandatory() {
            return this._mandatory;
        }
    }
}

