/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.FrameTransport;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.framing.TransportFrame;

class FrameParser
implements TransportInput {
    public static final byte[] HEADER = new byte[8];
    private EndpointError _localError;
    private Logger _traceLogger = Logger.getLogger("proton.trace");
    private Logger _rawLogger = Logger.getLogger("proton.raw");
    private FrameTransport _frameTransport;
    private TransportFrame _heldFrame;
    private State _state = State.HEADER0;
    private int _size;
    private ByteBuffer _buffer;
    private DecoderImpl _decoder = new DecoderImpl();
    private EncoderImpl _encoder = new EncoderImpl(this._decoder);

    FrameParser(FrameTransport frameTransport) {
        AMQPDefinedTypes.registerAllTypes(this._decoder, this._encoder);
        this._frameTransport = frameTransport;
    }

    @Override
    public int input(byte[] bytes, int offset, int length) {
        if (this._heldFrame != null) {
            if (this._frameTransport.input(this._heldFrame)) {
                this._heldFrame = null;
            } else {
                return 0;
            }
        }
        int unconsumed = length;
        EndpointError frameParsingError = null;
        int size = this._size;
        State state = this._state;
        ByteBuffer oldIn = null;
        ByteBuffer in = ByteBuffer.wrap(bytes, offset, unconsumed);
        boolean transportAccepting = true;
        while (in.hasRemaining() && state != State.ERROR && transportAccepting) {
            switch (state) {
                case HEADER0: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[0]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[0]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER1;
                }
                case HEADER1: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[1]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[1]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER2;
                }
                case HEADER2: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[2]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[2]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER3;
                }
                case HEADER3: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[3]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[3]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER4;
                }
                case HEADER4: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[4]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[4]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER5;
                }
                case HEADER5: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[5]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[5]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER6;
                }
                case HEADER6: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[6]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[6]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER7;
                }
                case HEADER7: {
                    if (!in.hasRemaining()) break;
                    byte c = in.get();
                    if (c != HEADER[7]) {
                        frameParsingError = this.createFramingError("AMQP header mismatch value %x, expecting %x", c, HEADER[7]);
                        state = State.ERROR;
                        break;
                    }
                    state = State.SIZE_0;
                }
                case SIZE_0: {
                    if (!in.hasRemaining()) break;
                    if (in.remaining() >= 4) {
                        size = in.getInt();
                        state = State.PRE_PARSE;
                        break;
                    }
                    size = in.get() << 24 & 0xFF000000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    size |= in.get() << 16 & 0xFF0000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    size |= in.get() << 8 & 0xFF00;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    size |= in.get() & 0xFF;
                    state = State.PRE_PARSE;
                }
                case PRE_PARSE: {
                    if (size < 8) {
                        frameParsingError = this.createFramingError("specified frame size %d smaller than minimum frame header size %d", this._size, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (in.remaining() < size - 4) {
                        this._buffer = ByteBuffer.allocate(size - 4);
                        this._buffer.put(in);
                        state = State.BUFFERING;
                        break;
                    }
                }
                case BUFFERING: {
                    if (this._buffer != null) {
                        if (in.remaining() < this._buffer.remaining()) {
                            this._buffer.put(in);
                            break;
                        }
                        ByteBuffer dup = in.duplicate();
                        dup.limit(dup.position() + this._buffer.remaining());
                        int i = this._buffer.remaining();
                        int d = dup.remaining();
                        in.position(in.position() + this._buffer.remaining());
                        this._buffer.put(dup);
                        oldIn = in;
                        this._buffer.flip();
                        in = this._buffer;
                        state = State.PARSING;
                    }
                }
                case PARSING: {
                    int dataOffset = in.get() << 2 & 0x3FF;
                    if (dataOffset < 8) {
                        frameParsingError = this.createFramingError("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset > size) {
                        frameParsingError = this.createFramingError("specified frame data offset %d larger than the frame size %d", dataOffset, this._size);
                        state = State.ERROR;
                        break;
                    }
                    int type = in.get() & 0xFF;
                    int channel = in.getShort() & 0xFF;
                    if (type != 0) {
                        frameParsingError = this.createFramingError("unknown frame type: %d", type);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset != 8) {
                        in.position(in.position() + dataOffset - 8);
                    }
                    if (oldIn == null) {
                        oldIn = in;
                        in = in.duplicate();
                        int endPos = in.position() + size - dataOffset;
                        in.limit(endPos);
                        oldIn.position(endPos);
                    }
                    try {
                        Binary payload;
                        this._decoder.setByteBuffer(in);
                        Object val = this._decoder.readObject();
                        if (in.hasRemaining()) {
                            byte[] payloadBytes = new byte[in.remaining()];
                            in.get(payloadBytes);
                            payload = new Binary(payloadBytes);
                        } else {
                            payload = null;
                        }
                        if (val instanceof FrameBody) {
                            TransportFrame frame;
                            FrameBody frameBody = (FrameBody)val;
                            if (this._traceLogger.isLoggable(Level.FINE)) {
                                this._traceLogger.log(Level.FINE, "IN: CH[" + channel + "] : " + frameBody + (payload == null ? "" : "[" + payload + "]"));
                            }
                            if (!this._frameTransport.input(frame = new TransportFrame(channel, frameBody, payload))) {
                                transportAccepting = false;
                                this._heldFrame = frame;
                            }
                        }
                        this.reset();
                        in = oldIn;
                        oldIn = null;
                        this._buffer = null;
                        state = State.SIZE_0;
                        break;
                    }
                    catch (DecodeException ex) {
                        state = State.ERROR;
                        frameParsingError = this.createFramingError(ex.getMessage(), new Object[0]);
                    }
                }
            }
        }
        this._state = state;
        this._size = size;
        this._localError = frameParsingError;
        if (this._state == State.ERROR) {
            throw new TransportException(frameParsingError.getDescription());
        }
        return this._state == State.ERROR ? -1 : length - in.remaining();
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    private EndpointError createFramingError(String description, Object ... args) {
        Formatter formatter = new Formatter();
        formatter.format(description, args);
        return new EndpointError("ERROR", formatter.toString());
    }

    static {
        FrameParser.HEADER[0] = 65;
        FrameParser.HEADER[1] = 77;
        FrameParser.HEADER[2] = 81;
        FrameParser.HEADER[3] = 80;
        FrameParser.HEADER[4] = 0;
        FrameParser.HEADER[5] = 1;
        FrameParser.HEADER[6] = 0;
        FrameParser.HEADER[7] = 0;
    }

    static enum State {
        HEADER0,
        HEADER1,
        HEADER2,
        HEADER3,
        HEADER4,
        HEADER5,
        HEADER6,
        HEADER7,
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

