/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud;

import java.io.IOException;
import java.util.Map;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.LedgerOffloaderFactory;
import org.apache.bookkeeper.mledger.LedgerOffloaderStats;
import org.apache.bookkeeper.mledger.LedgerOffloaderStatsDisable;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.BlobStoreManagedLedgerOffloader;
import org.apache.bookkeeper.mledger.offload.jcloud.impl.OffsetsCache;
import org.apache.bookkeeper.mledger.offload.jcloud.provider.JCloudBlobStoreProvider;
import org.apache.bookkeeper.mledger.offload.jcloud.provider.TieredStorageConfiguration;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;

public class JCloudLedgerOffloaderFactory
implements LedgerOffloaderFactory<BlobStoreManagedLedgerOffloader> {
    private final OffsetsCache entryOffsetsCache = new OffsetsCache();

    public boolean isDriverSupported(String driverName) {
        return JCloudBlobStoreProvider.driverSupported(driverName);
    }

    public BlobStoreManagedLedgerOffloader create(OffloadPoliciesImpl offloadPolicies, Map<String, String> userMetadata, OrderedScheduler scheduler) throws IOException {
        return this.create(offloadPolicies, (Map)userMetadata, scheduler, LedgerOffloaderStatsDisable.INSTANCE);
    }

    public BlobStoreManagedLedgerOffloader create(OffloadPoliciesImpl offloadPolicies, Map<String, String> userMetadata, OrderedScheduler scheduler, LedgerOffloaderStats offloaderStats) throws IOException {
        TieredStorageConfiguration config = TieredStorageConfiguration.create(offloadPolicies.toProperties());
        return BlobStoreManagedLedgerOffloader.create(config, userMetadata, scheduler, offloaderStats, this.entryOffsetsCache);
    }

    public void close() throws Exception {
        this.entryOffsetsCache.close();
    }
}

