/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockZooKeeper
extends ZooKeeper {
    private static final long NOT_EPHEMERAL = 0L;
    private static final String ROOT_PATH = "/";
    private TreeMap<String, MockZNode> tree;
    private SetMultimap<String, NodeWatcher> watchers;
    private AtomicBoolean stopped;
    private AtomicReference<KeeperException.Code> alwaysFail;
    private CopyOnWriteArrayList<Failure> failures;
    private ExecutorService executor;
    private volatile Watcher sessionWatcher;
    private long sessionId = 1L;
    private int readOpDelayMs;
    private AtomicLong sequentialIdGenerator;
    private ThreadLocal<Long> overriddenSessionIdThreadLocal;
    private ThreadLocal<Boolean> inExecutorThreadLocal;
    private int referenceCount;
    private List<AutoCloseable> closeables;
    private static final Objenesis objenesis = new ObjenesisStd();
    private List<PersistentWatcher> persistentWatchers;
    private static final Logger log = LoggerFactory.getLogger(MockZooKeeper.class);

    public static MockZooKeeper newInstance() {
        return MockZooKeeper.newInstance(-1);
    }

    public static MockZooKeeper newInstance(int readOpDelayMs) {
        try {
            return MockZooKeeper.createMockZooKeeperInstance(readOpDelayMs);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    private static MockZooKeeper createMockZooKeeperInstance(int readOpDelayMs) {
        ObjectInstantiator mockZooKeeperInstantiator = objenesis.getInstantiatorOf(MockZooKeeper.class);
        MockZooKeeper zk = (MockZooKeeper)((Object)mockZooKeeperInstantiator.newInstance());
        zk.overriddenSessionIdThreadLocal = new ThreadLocal();
        zk.inExecutorThreadLocal = ThreadLocal.withInitial(() -> false);
        zk.init();
        zk.readOpDelayMs = readOpDelayMs;
        zk.sequentialIdGenerator = new AtomicLong();
        zk.closeables = new ArrayList<AutoCloseable>();
        return zk;
    }

    private void init() {
        this.tree = Maps.newTreeMap();
        this.tree.put(ROOT_PATH, MockZNode.of(new byte[0], 0, 0L));
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("mock-zookeeper"));
        this.watchers = HashMultimap.create();
        this.stopped = new AtomicBoolean(false);
        this.alwaysFail = new AtomicReference<KeeperException.Code>(KeeperException.Code.OK);
        this.failures = new CopyOnWriteArrayList();
        this.persistentWatchers = new ArrayList<PersistentWatcher>();
    }

    public int getSessionTimeout() {
        return 30000;
    }

    private MockZooKeeper(String quorum) throws Exception {
        super(quorum, 1, event -> {});
        assert (false);
    }

    public ZooKeeper.States getState() {
        return ZooKeeper.States.CONNECTED;
    }

    public void register(Watcher watcher) {
        this.sessionWatcher = watcher;
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalCreate(path, data, createMode));
    }

    private <T> T runInExecutorReturningValue(Callable<T> task) throws InterruptedException, KeeperException {
        if (this.isStopped()) {
            throw new KeeperException.ConnectionLossException();
        }
        if (this.inExecutorThreadLocal.get().booleanValue()) {
            try {
                return task.call();
            }
            catch (Exception e) {
                if (e instanceof KeeperException) {
                    KeeperException ke = (KeeperException)e;
                    throw ke;
                }
                if (e instanceof InterruptedException) {
                    InterruptedException ie = (InterruptedException)e;
                    throw ie;
                }
                log.error("Unexpected exception", (Throwable)e);
                throw new KeeperException.SystemErrorException();
            }
        }
        try {
            long currentSessionId = this.getSessionId();
            return (T)this.executor.submit(() -> {
                this.inExecutorThreadLocal.set(true);
                this.overrideSessionId(currentSessionId);
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    this.removeSessionIdOverride();
                    this.inExecutorThreadLocal.set(false);
                }
            }).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KeeperException) {
                KeeperException ke = (KeeperException)cause;
                throw ke;
            }
            if (cause instanceof InterruptedException) {
                InterruptedException ie = (InterruptedException)cause;
                throw ie;
            }
            log.error("Unexpected exception", (Throwable)e);
            throw new KeeperException.SystemErrorException();
        }
    }

    private void runInExecutorAsync(Runnable runnable) {
        if (this.isStopped()) {
            throw new RejectedExecutionException("MockZooKeeper is stopped");
        }
        if (this.inExecutorThreadLocal.get().booleanValue()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                log.error("Unexpected exception", t);
            }
            return;
        }
        long currentSessionId = this.getSessionId();
        this.executor.submit(() -> {
            try {
                this.inExecutorThreadLocal.set(true);
                this.overrideSessionId(currentSessionId);
                try {
                    runnable.run();
                }
                finally {
                    this.removeSessionIdOverride();
                    this.inExecutorThreadLocal.set(false);
                }
            }
            catch (Throwable t) {
                log.error("Unexpected exception", t);
            }
        });
    }

    private void runInExecutorSync(Runnable runnable) {
        try {
            this.runInExecutorReturningValue(() -> {
                runnable.run();
                return null;
            });
        }
        catch (Exception e) {
            log.error("Unexpected error", (Throwable)e);
        }
    }

    private String internalCreate(String path, byte[] data, CreateMode createMode) throws KeeperException {
        HashSet toNotifyCreate = Sets.newHashSet();
        HashSet toNotifyParent = Sets.newHashSet();
        String parent = MockZooKeeper.getParentName((String)path);
        this.maybeThrowProgrammedFailure(Op.CREATE, (String)path);
        if (this.isStopped()) {
            throw new KeeperException.ConnectionLossException();
        }
        if (this.tree.containsKey(path)) {
            throw new KeeperException.NodeExistsException((String)path);
        }
        MockZNode parentNode = this.tree.get(parent);
        if (parentNode == null) {
            throw new KeeperException.NoNodeException(parent);
        }
        if (createMode.isSequential()) {
            int parentVersion = parentNode.getVersion();
            path = (String)path + parentVersion;
            parentNode.updateVersion();
        }
        parentNode.getChildren().add(MockZooKeeper.getNodeName((String)path));
        this.tree.put((String)path, this.createMockZNode(data, createMode));
        toNotifyCreate.addAll(this.getWatchers((String)path));
        if (!ROOT_PATH.equals(parent)) {
            toNotifyParent.addAll(this.getWatchers(parent));
        }
        this.watchers.removeAll(path);
        Object finalPath = path;
        this.executor.execute(() -> this.lambda$internalCreate$8((String)finalPath, parent, toNotifyCreate, toNotifyParent));
        return path;
    }

    private static String getParentName(String path) {
        String parentName = path.substring(0, path.lastIndexOf(47));
        return parentName.length() > 0 ? parentName : ROOT_PATH;
    }

    private static String getNodeName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private Collection<Watcher> getWatchers(String path) {
        Set nodeWatchers = this.watchers.get((Object)path);
        if (nodeWatchers != null) {
            return nodeWatchers.stream().map(NodeWatcher::watcher).toList();
        }
        return Collections.emptyList();
    }

    public long getSessionId() {
        Long overriddenSessionId = this.overriddenSessionIdThreadLocal.get();
        if (overriddenSessionId != null) {
            return overriddenSessionId;
        }
        return this.sessionId;
    }

    public void overrideSessionId(long sessionId) {
        this.overriddenSessionIdThreadLocal.set(sessionId);
    }

    public void removeSessionIdOverride() {
        this.overriddenSessionIdThreadLocal.remove();
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                HashSet toNotifyCreate = Sets.newHashSet();
                toNotifyCreate.addAll(this.getWatchers(path));
                HashSet toNotifyParent = Sets.newHashSet();
                String parent = MockZooKeeper.getParentName(path);
                if (!ROOT_PATH.equals(parent)) {
                    toNotifyParent.addAll(this.getWatchers(parent));
                }
                Object name = createMode != null && createMode.isSequential() ? path + this.sequentialIdGenerator.getAndIncrement() : path;
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.CREATE, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                } else if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                } else if (this.tree.containsKey(path)) {
                    cb.processResult(KeeperException.Code.NODEEXISTS.intValue(), path, ctx, null);
                } else if (!this.tree.containsKey(parent)) {
                    this.runNotifications(() -> toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent))));
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                } else {
                    this.tree.get(parent).getChildren().add(MockZooKeeper.getNodeName((String)name));
                    this.tree.put((String)name, this.createMockZNode(data, createMode));
                    this.watchers.removeAll(name);
                    cb.processResult(0, path, ctx, (String)name);
                    this.runNotifications(() -> this.lambda$create$13(path, parent, toNotifyCreate, (String)name, toNotifyParent));
                }
            }
            catch (Throwable ex) {
                log.error("create path : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null);
            }
        });
    }

    public void runNotifications(Runnable runnable) {
        this.executor.execute(() -> {
            if (this.isStopped()) {
                return;
            }
            runnable.run();
        });
    }

    private boolean isStopped() {
        return this.stopped.get();
    }

    private MockZNode createMockZNode(byte[] data, CreateMode createMode) {
        return MockZNode.of(data, 0, createMode != null && createMode.isEphemeral() ? this.getSessionId() : 0L);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalGetData(path, watcher, stat));
    }

    private byte[] internalGetData(String path, Watcher watcher, Stat stat) throws KeeperException {
        this.maybeThrowProgrammedFailure(Op.GET, path);
        MockZNode value = this.tree.get(path);
        if (value == null) {
            throw new KeeperException.NoNodeException(path);
        }
        if (watcher != null) {
            this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
        }
        if (stat != null) {
            value.applyToStat(stat);
        }
        return value.getContent();
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.getData(path, null, cb, ctx);
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            this.checkReadOpDelay();
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null, null);
                    return;
                }
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                    return;
                }
                MockZNode value = this.tree.get(path);
                if (value == null) {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                } else {
                    if (watcher != null) {
                        this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
                    }
                    Stat stat = value.getStat();
                    cb.processResult(0, path, ctx, value.getContent(), stat);
                }
            }
            catch (Throwable ex) {
                log.error("get data : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null, null);
            }
        });
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (!this.tree.containsKey(path)) {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                    return;
                }
                List<String> children = this.findFirstLevelChildren(path);
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
                }
                cb.processResult(0, path, ctx, children);
            }
            catch (Throwable ex) {
                log.error("get children : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null);
            }
        });
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalGetChildren(path, watcher));
    }

    private List<String> internalGetChildren(String path, Watcher watcher) throws KeeperException {
        this.maybeThrowProgrammedFailure(Op.GET_CHILDREN, path);
        if (!this.tree.containsKey(path)) {
            throw new KeeperException.NoNodeException(path);
        }
        if (watcher != null) {
            this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
        }
        return this.findFirstLevelChildren(path);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.getChildren(path, null);
    }

    public void getChildren(String path, boolean watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                MockZNode mockZNode = this.tree.get(path);
                Stat stat = mockZNode != null ? mockZNode.getStat() : null;
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.GET_CHILDREN, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null, null);
                    return;
                }
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null, null);
                    return;
                }
                if (mockZNode == null) {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null, null);
                    return;
                }
                List<String> children = this.findFirstLevelChildren(path);
                cb.processResult(0, path, ctx, children, stat);
            }
            catch (Throwable ex) {
                log.error("get children : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null, null);
            }
        });
    }

    private List<String> findFirstLevelChildren(String path) {
        return new ArrayList<String>(this.tree.get(path).getChildren());
    }

    private boolean hasChildren(String path) {
        return !this.tree.get(path).getChildren().isEmpty();
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalGetStat(path, null));
    }

    private Stat internalGetStat(String path, Watcher watcher) throws KeeperException {
        this.maybeThrowProgrammedFailure(Op.EXISTS, path);
        if (this.isStopped()) {
            throw new KeeperException.ConnectionLossException();
        }
        if (watcher != null) {
            this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
        }
        if (this.tree.containsKey(path)) {
            return this.tree.get(path).getStat();
        }
        return null;
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalGetStat(path, watcher));
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.exists(path, null, cb, ctx);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                MockZNode mockZNode;
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.EXISTS, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (watcher != null) {
                    this.watchers.put((Object)path, (Object)new NodeWatcher(watcher, this.getSessionId()));
                }
                if ((mockZNode = this.tree.get(path)) != null) {
                    Stat stat = mockZNode.getStat();
                    cb.processResult(0, path, ctx, stat);
                } else {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                }
            }
            catch (Throwable ex) {
                log.error("exist : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null);
            }
        });
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
            return;
        }
        this.runInExecutorAsync(() -> {
            Optional<KeeperException.Code> failure = this.programmedFailure(Op.SYNC, path);
            if (failure.isPresent()) {
                cb.processResult(failure.get().intValue(), path, ctx);
                return;
            }
            if (this.isStopped()) {
                cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
                return;
            }
            cb.processResult(0, path, ctx);
        });
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.runInExecutorReturningValue(() -> this.internalSetData(path, data, version));
    }

    private Stat internalSetData(String path, byte[] data, int version) throws KeeperException {
        HashSet toNotify = Sets.newHashSet();
        this.maybeThrowProgrammedFailure(Op.SET, path);
        if (this.isStopped()) {
            throw new KeeperException.ConnectionLossException();
        }
        if (!this.tree.containsKey(path)) {
            throw new KeeperException.NoNodeException(path);
        }
        MockZNode mockZNode = this.tree.get(path);
        int currentVersion = mockZNode.getVersion();
        if (version != -1 && version != currentVersion) {
            throw new KeeperException.BadVersionException(path);
        }
        log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
        mockZNode.updateData(data);
        Stat stat = mockZNode.getStat();
        toNotify.addAll(this.getWatchers(path));
        this.watchers.removeAll((Object)path);
        this.runNotifications(() -> {
            this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
            toNotify.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path)));
        });
        return stat;
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                HashSet toNotify = Sets.newHashSet();
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.SET, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx, null);
                    return;
                }
                if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx, null);
                    return;
                }
                if (!this.tree.containsKey(path)) {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx, null);
                    return;
                }
                MockZNode mockZNode = this.tree.get(path);
                int currentVersion = mockZNode.getVersion();
                if (version != -1 && version != currentVersion) {
                    log.debug("[{}] Current version: {} -- Expected: {}", new Object[]{path, currentVersion, version});
                    Stat currentStat = mockZNode.getStat();
                    cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx, currentStat);
                    return;
                }
                log.debug("[{}] Updating -- current version: {}", (Object)path, (Object)currentVersion);
                mockZNode.updateData(data);
                Stat stat = mockZNode.getStat();
                cb.processResult(0, path, ctx, stat);
                toNotify.addAll(this.getWatchers(path));
                this.watchers.removeAll((Object)path);
                this.runNotifications(() -> {
                    this.triggerPersistentWatches(path, null, Watcher.Event.EventType.NodeDataChanged);
                    for (Watcher watcher : toNotify) {
                        watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
                    }
                });
            }
            catch (Throwable ex) {
                log.error("Update data : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx, null);
            }
        });
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.runInExecutorReturningValue(() -> {
            this.internalDelete(path, version);
            return null;
        });
    }

    private void internalDelete(String path, int version) throws KeeperException {
        int currentVersion;
        this.maybeThrowProgrammedFailure(Op.DELETE, path);
        if (this.isStopped()) {
            throw new KeeperException.ConnectionLossException();
        }
        if (!this.tree.containsKey(path)) {
            throw new KeeperException.NoNodeException(path);
        }
        if (this.hasChildren(path)) {
            throw new KeeperException.NotEmptyException(path);
        }
        if (version != -1 && version != (currentVersion = this.tree.get(path).getVersion())) {
            throw new KeeperException.BadVersionException(path);
        }
        String parent = MockZooKeeper.getParentName(path);
        this.tree.remove(path);
        this.tree.get(parent).getChildren().remove(MockZooKeeper.getNodeName(path));
        HashSet toNotifyDelete = Sets.newHashSet();
        toNotifyDelete.addAll(this.getWatchers(path));
        HashSet toNotifyParent = Sets.newHashSet();
        if (!ROOT_PATH.equals(parent)) {
            toNotifyParent.addAll(this.getWatchers(parent));
        }
        this.watchers.removeAll((Object)path);
        this.runNotifications(() -> {
            for (Watcher watcher1 : toNotifyDelete) {
                watcher1.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
            }
            for (Watcher watcher2 : toNotifyParent) {
                watcher2.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
            }
            this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
        });
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                HashSet toNotifyDelete = Sets.newHashSet();
                toNotifyDelete.addAll(this.getWatchers(path));
                HashSet toNotifyParent = Sets.newHashSet();
                String parent = MockZooKeeper.getParentName(path);
                if (!ROOT_PATH.equals(parent)) {
                    toNotifyParent.addAll(this.getWatchers(parent));
                }
                this.watchers.removeAll((Object)path);
                Optional<KeeperException.Code> failure = this.programmedFailure(Op.DELETE, path);
                if (failure.isPresent()) {
                    cb.processResult(failure.get().intValue(), path, ctx);
                } else if (this.isStopped()) {
                    cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), path, ctx);
                } else if (!this.tree.containsKey(path)) {
                    cb.processResult(KeeperException.Code.NONODE.intValue(), path, ctx);
                } else if (this.hasChildren(path)) {
                    cb.processResult(KeeperException.Code.NOTEMPTY.intValue(), path, ctx);
                } else {
                    int currentVersion;
                    if (version != -1 && version != (currentVersion = this.tree.get(path).getVersion())) {
                        cb.processResult(KeeperException.Code.BADVERSION.intValue(), path, ctx);
                        return;
                    }
                    this.tree.remove(path);
                    this.tree.get(parent).getChildren().remove(MockZooKeeper.getNodeName(path));
                    cb.processResult(0, path, ctx);
                    this.runNotifications(() -> {
                        this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeDeleted);
                        toNotifyDelete.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path)));
                        toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
                    });
                }
            }
            catch (Throwable ex) {
                log.error("delete path : {} error", (Object)path, (Object)ex);
                cb.processResult(KeeperException.Code.SYSTEMERROR.intValue(), path, ctx);
            }
        });
    }

    public void multi(Iterable<org.apache.zookeeper.Op> ops, AsyncCallback.MultiCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), null, ctx, null);
            return;
        }
        this.runInExecutorAsync(() -> {
            try {
                List<OpResult> res = this.multi(ops);
                cb.processResult(KeeperException.Code.OK.intValue(), null, ctx, res);
            }
            catch (Exception e) {
                cb.processResult(KeeperException.Code.APIERROR.intValue(), null, ctx, null);
            }
        });
    }

    public List<OpResult> multi(Iterable<org.apache.zookeeper.Op> ops) throws InterruptedException, KeeperException {
        return this.runInExecutorReturningValue(() -> this.internalMulti(ops));
    }

    private List<OpResult> internalMulti(Iterable<org.apache.zookeeper.Op> ops) {
        ArrayList<OpResult> res = new ArrayList<OpResult>();
        block7: for (org.apache.zookeeper.Op op : ops) {
            switch (op.getType()) {
                case 1: {
                    this.handleOperation("create", op, () -> {
                        Op.Create opc = (Op.Create)op;
                        CreateMode cm = CreateMode.fromFlag((int)opc.flags);
                        String path = this.create(op.getPath(), opc.data, null, cm);
                        res.add((OpResult)new OpResult.CreateResult(path));
                    }, res);
                    continue block7;
                }
                case 2: {
                    this.handleOperation("delete", op, () -> {
                        DeleteRequest deleteRequest = (DeleteRequest)op.toRequestRecord();
                        this.delete(op.getPath(), deleteRequest.getVersion());
                        res.add((OpResult)new OpResult.DeleteResult());
                    }, res);
                    continue block7;
                }
                case 5: {
                    this.handleOperation("setData", op, () -> {
                        SetDataRequest setDataRequest = (SetDataRequest)op.toRequestRecord();
                        Stat stat = this.setData(op.getPath(), setDataRequest.getData(), setDataRequest.getVersion());
                        res.add((OpResult)new OpResult.SetDataResult(stat));
                    }, res);
                    continue block7;
                }
                case 8: {
                    this.handleOperation("getChildren", op, () -> {
                        List<String> children = this.getChildren(op.getPath(), null);
                        res.add((OpResult)new OpResult.GetChildrenResult(children));
                    }, res);
                    continue block7;
                }
                case 4: {
                    Stat stat = new Stat();
                    this.handleOperation("getData", op, () -> {
                        byte[] payload = this.getData(op.getPath(), null, stat);
                        res.add((OpResult)new OpResult.GetDataResult(payload, stat));
                    }, res);
                    continue block7;
                }
            }
            log.error("Unsupported operation for path {} type {} kind {} request {}", new Object[]{op.getPath(), op.getType(), op.getKind(), op.toRequestRecord()});
            res.add((OpResult)new OpResult.ErrorResult(KeeperException.Code.APIERROR.intValue()));
        }
        return res;
    }

    private void handleOperation(String opName, org.apache.zookeeper.Op op, ZkOpHandler handler, List<OpResult> res) {
        try {
            handler.handle();
        }
        catch (Exception e) {
            if (e instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)e;
                res.add((OpResult)new OpResult.ErrorResult(keeperException.code().intValue()));
            }
            log.error("Error handling {} operation for path {} type {} kind {} request {}", new Object[]{opName, op.getPath(), op.getType(), op.getKind(), op.toRequestRecord(), e});
            res.add((OpResult)new OpResult.ErrorResult(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue()));
        }
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode) {
        this.runInExecutorSync(() -> this.persistentWatchers.add(new PersistentWatcher(basePath, watcher, mode, this.getSessionId())));
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode, AsyncCallback.VoidCallback cb, Object ctx) {
        if (this.isStopped()) {
            cb.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), basePath, ctx);
            return;
        }
        this.runInExecutorAsync(() -> {
            this.addWatch(basePath, watcher, mode);
            cb.processResult(KeeperException.Code.OK.intValue(), basePath, ctx);
        });
    }

    public synchronized void increaseRefCount() {
        ++this.referenceCount;
    }

    public synchronized MockZooKeeper registerCloseable(AutoCloseable closeable) {
        this.closeables.add(closeable);
        return this;
    }

    public synchronized void close() throws InterruptedException {
        if (--this.referenceCount <= 0) {
            this.shutdown();
            this.closeables.forEach(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    log.error("Error closing closeable", (Throwable)e);
                }
            });
            this.closeables.clear();
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.stopped.compareAndSet(false, true)) {
            Future<?> shutdownTask = this.executor.submit(() -> {
                this.tree.clear();
                this.watchers.clear();
                this.persistentWatchers.clear();
            });
            try {
                shutdownTask.get();
            }
            catch (ExecutionException e) {
                log.error("Error shutting down", (Throwable)e);
            }
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    Optional<KeeperException.Code> programmedFailure(Op op, String path) {
        KeeperException.Code error = this.alwaysFail.get();
        if (error != KeeperException.Code.OK) {
            return Optional.of(error);
        }
        Optional<Failure> failure = this.failures.stream().filter(f -> f.predicate.test(op, path)).findFirst();
        if (failure.isPresent()) {
            this.failures.remove(failure.get());
            return Optional.ofNullable(failure.get().failReturnCode);
        }
        return Optional.empty();
    }

    void maybeThrowProgrammedFailure(Op op, String path) throws KeeperException {
        Optional<KeeperException.Code> failure = this.programmedFailure(op, path);
        if (failure.isPresent()) {
            throw KeeperException.create((KeeperException.Code)failure.get());
        }
    }

    public void failConditional(KeeperException.Code rc, BiPredicate<Op, String> predicate) {
        this.failures.add(new Failure(rc, predicate));
    }

    public void delay(long millis, BiPredicate<Op, String> predicate) {
        this.failures.add(new Failure(null, (op, s) -> {
            if (predicate.test((Op)((Object)op), (String)s)) {
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }));
    }

    public void setAlwaysFail(KeeperException.Code rc) {
        this.alwaysFail.set(rc);
    }

    public void unsetAlwaysFail() {
        this.alwaysFail.set(KeeperException.Code.OK);
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public String toString() {
        return "MockZookeeper";
    }

    private void checkReadOpDelay() {
        if (this.readOpDelayMs > 0) {
            try {
                Thread.sleep(this.readOpDelayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void triggerPersistentWatches(String path, String parent, Watcher.Event.EventType eventType) {
        this.persistentWatchers.forEach(w -> {
            if (w.mode == AddWatchMode.PERSISTENT_RECURSIVE) {
                if (path.startsWith(w.path())) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
            } else if (w.mode == AddWatchMode.PERSISTENT) {
                if (w.path().equals(path)) {
                    w.watcher.process(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
                }
                if (eventType == Watcher.Event.EventType.NodeCreated || eventType == Watcher.Event.EventType.NodeDeleted) {
                    w.watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent));
                }
            }
        });
    }

    public void deleteEphemeralNodes(long sessionId) {
        if (sessionId != 0L) {
            this.runInExecutorSync(() -> this.tree.values().removeIf(zNode -> zNode.getEphemeralOwner() == sessionId));
        }
    }

    public void deleteWatchers(long sessionId) {
        this.runInExecutorSync(() -> {
            this.persistentWatchers.removeIf(w -> w.sessionId == sessionId);
            List<Map.Entry> watchersForSession = this.watchers.entries().stream().filter(e -> ((NodeWatcher)e.getValue()).sessionId == sessionId).toList();
            watchersForSession.forEach(e -> this.watchers.remove(e.getKey(), e.getValue()));
        });
    }

    private /* synthetic */ void lambda$create$13(String path, String parent, Set toNotifyCreate, String name, Set toNotifyParent) {
        this.triggerPersistentWatches(path, parent, Watcher.Event.EventType.NodeCreated);
        toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, name)));
        toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
    }

    private /* synthetic */ void lambda$internalCreate$8(String finalPath, String parent, Set toNotifyCreate, Set toNotifyParent) {
        if (this.isStopped()) {
            return;
        }
        this.triggerPersistentWatches(finalPath, parent, Watcher.Event.EventType.NodeCreated);
        toNotifyCreate.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, finalPath)));
        toNotifyParent.forEach(watcher -> watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, parent)));
    }

    private static class MockZNode {
        byte[] content;
        int version;
        long ephemeralOwner;
        long creationTimestamp;
        long modificationTimestamp;
        List<String> children;

        static MockZNode of(byte[] content, int version, long ephemeralOwner) {
            return new MockZNode(content, version, ephemeralOwner, System.currentTimeMillis(), System.currentTimeMillis(), new ArrayList<String>());
        }

        public void updateVersion() {
            ++this.version;
            this.modificationTimestamp = System.currentTimeMillis();
        }

        public void updateData(byte[] data) {
            this.content = data;
            this.updateVersion();
        }

        public Stat getStat() {
            return this.applyToStat(new Stat());
        }

        public Stat applyToStat(Stat stat) {
            stat.setCtime(this.creationTimestamp);
            stat.setMtime(this.modificationTimestamp);
            stat.setVersion(this.version);
            stat.setEphemeralOwner(this.ephemeralOwner);
            return stat;
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getContent() {
            return this.content;
        }

        public long getEphemeralOwner() {
            return this.ephemeralOwner;
        }

        public List<String> getChildren() {
            return this.children;
        }

        @Generated
        public MockZNode(byte[] content, int version, long ephemeralOwner, long creationTimestamp, long modificationTimestamp, List<String> children) {
            this.content = content;
            this.version = version;
            this.ephemeralOwner = ephemeralOwner;
            this.creationTimestamp = creationTimestamp;
            this.modificationTimestamp = modificationTimestamp;
            this.children = children;
        }
    }

    public static enum Op {
        CREATE,
        GET,
        SET,
        GET_CHILDREN,
        DELETE,
        EXISTS,
        SYNC;

    }

    private record NodeWatcher(Watcher watcher, long sessionId) {
    }

    static interface ZkOpHandler {
        public void handle() throws KeeperException, InterruptedException;
    }

    private static class Failure {
        final KeeperException.Code failReturnCode;
        final BiPredicate<Op, String> predicate;

        Failure(KeeperException.Code failReturnCode, BiPredicate<Op, String> predicate) {
            this.failReturnCode = failReturnCode;
            this.predicate = predicate;
        }
    }

    private record PersistentWatcher(String path, Watcher watcher, AddWatchMode mode, long sessionId) {
    }
}

