/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import io.prometheus.client.Gauge;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class ZooKeeperServerAspect {
    private static boolean metricsRegistered = false;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ZooKeeperServerAspect ajc$perSingletonInstance;

    static {
        try {
            ZooKeeperServerAspect.ajc$perSingletonInstance = new ZooKeeperServerAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(org.apache.zookeeper.server.ZooKeeperServer.new(..))")
    public /* synthetic */ void zkServerConstructorPointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After(value="zkServerConstructorPointCut()")
    public void zkServerConstructor(JoinPoint joinPoint) throws Throwable {
        final ZooKeeperServer zkServer = (ZooKeeperServer)joinPoint.getThis();
        Class<ZooKeeperServerAspect> clazz = ZooKeeperServerAspect.class;
        synchronized (ZooKeeperServerAspect.class) {
            if (metricsRegistered) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            metricsRegistered = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("zookeeper_server_znode_count")).help("Number of z-nodes stored")).create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return zkServer.getZKDatabase().getNodeCount();
                }
            }, new String[0]).register();
            ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("zookeeper_server_data_size_bytes")).help("Size of all of z-nodes stored (bytes)")).create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return zkServer.getZKDatabase().getDataTree().approximateDataSize();
                }
            }, new String[0]).register();
            ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("zookeeper_server_connections")).help("Number of currently opened connections")).create().setChild((Object)new Gauge.Child(){

                public double get() {
                    ServerCnxnFactory cnxFactory = zkServer.getServerCnxnFactory();
                    if (cnxFactory != null) {
                        return cnxFactory.getNumAliveConnections();
                    }
                    return -1.0;
                }
            }, new String[0]).register();
            ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("zookeeper_server_watches_count")).help("Number of watches")).create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return zkServer.getZKDatabase().getDataTree().getWatchCount();
                }
            }, new String[0]).register();
            ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("zookeeper_server_ephemerals_count")).help("Number of ephemerals z-nodes")).create().setChild((Object)new Gauge.Child(){

                public double get() {
                    return zkServer.getZKDatabase().getDataTree().getEphemeralsCount();
                }
            }, new String[0]).register();
            return;
        }
    }

    public static ZooKeeperServerAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.pulsar.zookeeper.ZooKeeperServerAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

