/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.testclient.PerformanceBaseArguments;
import org.slf4j.Logger;

public final class PerfClientUtils {
    private static volatile Consumer<Integer> exitProcedure = System::exit;

    public static void setExitProcedure(Consumer<Integer> exitProcedure) {
        PerfClientUtils.exitProcedure = Objects.requireNonNull(exitProcedure);
    }

    public static void exit(int code) {
        exitProcedure.accept(code);
    }

    public static void printJVMInformation(Logger log) {
        log.info("JVM args {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        log.info("Netty max memory (PlatformDependent.maxDirectMemory()) {}", (Object)FileUtils.byteCountToDisplaySize((long)DirectMemoryUtils.jvmMaxDirectMemory()));
        log.info("JVM max heap memory (Runtime.getRuntime().maxMemory()) {}", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
    }

    public static ClientBuilder createClientBuilderFromArguments(PerformanceBaseArguments arguments) throws PulsarClientException.UnsupportedAuthenticationException {
        ClientBuilder clientBuilder = PulsarClient.builder().memoryLimit(arguments.memoryLimit, SizeUnit.BYTES).serviceUrl(arguments.serviceURL).connectionsPerBroker(arguments.maxConnections).ioThreads(arguments.ioThreads).statsInterval(arguments.statsIntervalSeconds, TimeUnit.SECONDS).enableBusyWait(arguments.enableBusyWait).listenerThreads(arguments.listenerThreads).tlsTrustCertsFilePath(arguments.tlsTrustCertsFilePath).maxLookupRequests(arguments.maxLookupRequest).proxyServiceUrl(arguments.proxyServiceURL, arguments.proxyProtocol).openTelemetry((OpenTelemetry)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> Map.of("otel.sdk.disabled", "true")).build().getOpenTelemetrySdk());
        if (StringUtils.isNotBlank((CharSequence)arguments.authPluginClassName)) {
            clientBuilder.authentication(arguments.authPluginClassName, arguments.authParams);
        }
        if (arguments.tlsAllowInsecureConnection != null) {
            clientBuilder.allowTlsInsecureConnection(arguments.tlsAllowInsecureConnection.booleanValue());
        }
        if (arguments.tlsHostnameVerificationEnable != null) {
            clientBuilder.enableTlsHostnameVerification(arguments.tlsHostnameVerificationEnable.booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)arguments.listenerName)) {
            clientBuilder.listenerName(arguments.listenerName);
        }
        return clientBuilder;
    }

    public static PulsarAdminBuilder createAdminBuilderFromArguments(PerformanceBaseArguments arguments, String adminUrl) throws PulsarClientException.UnsupportedAuthenticationException {
        PulsarAdminBuilder pulsarAdminBuilder = PulsarAdmin.builder().serviceHttpUrl(adminUrl).tlsTrustCertsFilePath(arguments.tlsTrustCertsFilePath);
        if (StringUtils.isNotBlank((CharSequence)arguments.authPluginClassName)) {
            pulsarAdminBuilder.authentication(arguments.authPluginClassName, arguments.authParams);
        }
        if (arguments.tlsAllowInsecureConnection != null) {
            pulsarAdminBuilder.allowTlsInsecureConnection(arguments.tlsAllowInsecureConnection.booleanValue());
        }
        if (arguments.tlsHostnameVerificationEnable != null) {
            pulsarAdminBuilder.enableTlsHostnameVerification(arguments.tlsHostnameVerificationEnable.booleanValue());
        }
        return pulsarAdminBuilder;
    }

    @Generated
    private PerfClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

