/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.proxy.server.BrokerDiscoveryProvider;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.RedirectProtocolHandler;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdminProxyHandler
extends ProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AdminProxyHandler.class);
    private static final String ORIGINAL_PRINCIPAL_HEADER = "X-Original-Principal";
    public static final String INIT_PARAM_REQUEST_BUFFER_SIZE = "requestBufferSize";
    private static final Set<String> functionRoutes = new HashSet<String>(Arrays.asList("/admin/v3/function", "/admin/v2/function", "/admin/function", "/admin/v3/source", "/admin/v2/source", "/admin/source", "/admin/v3/sink", "/admin/v2/sink", "/admin/sink", "/admin/v2/worker", "/admin/v2/worker-stats", "/admin/worker", "/admin/worker-stats"));
    private final ProxyConfiguration config;
    private final BrokerDiscoveryProvider discoveryProvider;
    private final Authentication proxyClientAuthentication;
    private final String brokerWebServiceUrl;
    private final String functionWorkerWebServiceUrl;

    AdminProxyHandler(ProxyConfiguration config, BrokerDiscoveryProvider discoveryProvider, Authentication proxyClientAuthentication) {
        this.config = config;
        this.discoveryProvider = discoveryProvider;
        this.proxyClientAuthentication = proxyClientAuthentication;
        this.brokerWebServiceUrl = config.isTlsEnabledWithBroker() ? config.getBrokerWebServiceURLTLS() : config.getBrokerWebServiceURL();
        this.functionWorkerWebServiceUrl = config.isTlsEnabledWithBroker() ? config.getFunctionWorkerWebServiceURLTLS() : config.getFunctionWorkerWebServiceURL();
        super.setTimeout((long)config.getHttpProxyTimeout());
    }

    protected HttpClient createHttpClient() throws ServletException {
        Executor executor;
        ServletConfig config = this.getServletConfig();
        HttpClient client = this.newHttpClient();
        client.setFollowRedirects(true);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        String value = config.getInitParameter("maxThreads");
        if (value == null || "-".equals(value)) {
            executor = (Executor)this.getServletContext().getAttribute("org.eclipse.jetty.server.Executor");
            if (executor == null) {
                throw new IllegalStateException("No server executor for proxy");
            }
        } else {
            QueuedThreadPool qtp = new QueuedThreadPool(Integer.parseInt(value));
            String servletName = config.getServletName();
            int dot = servletName.lastIndexOf(46);
            if (dot >= 0) {
                servletName = servletName.substring(dot + 1);
            }
            qtp.setName(servletName);
            executor = qtp;
        }
        client.setExecutor(executor);
        value = config.getInitParameter("maxConnections");
        if (value == null) {
            value = "256";
        }
        client.setMaxConnectionsPerDestination(Integer.parseInt(value));
        value = config.getInitParameter("idleTimeout");
        if (value == null) {
            value = "30000";
        }
        client.setIdleTimeout(Long.parseLong(value));
        value = config.getInitParameter(INIT_PARAM_REQUEST_BUFFER_SIZE);
        if (value != null) {
            client.setRequestBufferSize(Integer.parseInt(value));
        }
        if ((value = config.getInitParameter("responseBufferSize")) != null) {
            client.setResponseBufferSize(Integer.parseInt(value));
        }
        try {
            client.start();
            client.getContentDecoderFactories().clear();
            ProtocolHandlers protocolHandlers = client.getProtocolHandlers();
            protocolHandlers.clear();
            protocolHandlers.put((ProtocolHandler)new RedirectProtocolHandler(client));
            return client;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected ContentProvider proxyRequestContent(HttpServletRequest request, HttpServletResponse response, Request proxyRequest) throws IOException {
        return new ReplayableProxyContentProvider(request, response, proxyRequest, (InputStream)request.getInputStream(), this.config.getHttpInputMaxReplayBufferSize());
    }

    protected HttpClient newHttpClient() {
        try {
            if (this.config.isTlsEnabledWithBroker()) {
                try {
                    SSLContext sslCtx;
                    Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile((String)this.config.getBrokerClientTrustCertsFilePath());
                    AuthenticationDataProvider authData = this.proxyClientAuthentication.getAuthData(URI.create(this.getWebServiceUrl()).getHost());
                    if (this.config.isBrokerClientTlsEnabledWithKeyStore()) {
                        KeyStoreParams params = authData.hasDataForTls() ? authData.getTlsKeyStoreParams() : null;
                        sslCtx = KeyStoreSSLContext.createClientSslContext((String)this.config.getBrokerClientSslProvider(), (String)(params != null ? params.getKeyStoreType() : null), (String)(params != null ? params.getKeyStorePath() : null), (String)(params != null ? params.getKeyStorePassword() : null), (boolean)this.config.isTlsAllowInsecureConnection(), (String)this.config.getBrokerClientTlsTrustStoreType(), (String)this.config.getBrokerClientTlsTrustStore(), (String)this.config.getBrokerClientTlsTrustStorePassword(), this.config.getBrokerClientTlsCiphers(), this.config.getBrokerClientTlsProtocols());
                    } else {
                        sslCtx = authData.hasDataForTls() ? SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates, (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey(), (String)this.config.getBrokerClientSslProvider()) : SecurityUtility.createSslContext((boolean)this.config.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates, (String)this.config.getBrokerClientSslProvider());
                    }
                    SslContextFactory.Client contextFactory = new SslContextFactory.Client();
                    contextFactory.setSslContext(sslCtx);
                    if (!this.config.isTlsHostnameVerificationEnabled()) {
                        contextFactory.setEndpointIdentificationAlgorithm(null);
                    }
                    return new JettyHttpClient((SslContextFactory)contextFactory);
                }
                catch (Exception e) {
                    LOG.error("new jetty http client exception ", (Throwable)e);
                    throw new PulsarClientException.InvalidConfigurationException(e.getMessage());
                }
            }
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
        return new JettyHttpClient();
    }

    private String getWebServiceUrl() throws PulsarServerException {
        if (StringUtils.isBlank((CharSequence)this.brokerWebServiceUrl)) {
            LoadManagerReport availableBroker = this.discoveryProvider.nextBroker();
            if (this.config.isTlsEnabledWithBroker()) {
                return availableBroker.getWebServiceUrlTls();
            }
            return availableBroker.getWebServiceUrl();
        }
        return this.brokerWebServiceUrl;
    }

    protected String rewriteTarget(HttpServletRequest request) {
        URI rewrittenUrl;
        StringBuilder url = new StringBuilder();
        boolean isFunctionsRestRequest = false;
        String requestUri = request.getRequestURI();
        for (String routePrefix : functionRoutes) {
            if (!requestUri.startsWith(routePrefix)) continue;
            isFunctionsRestRequest = true;
            break;
        }
        if (isFunctionsRestRequest && !StringUtils.isBlank((CharSequence)this.functionWorkerWebServiceUrl)) {
            url.append(this.functionWorkerWebServiceUrl);
        } else {
            try {
                url.append(this.getWebServiceUrl());
                if (LOG.isDebugEnabled() && StringUtils.isBlank((CharSequence)this.brokerWebServiceUrl)) {
                    LOG.debug("[{}:{}] Selected active broker is {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), url});
                }
            }
            catch (Exception e) {
                LOG.warn("[{}:{}] Failed to get next active broker {}", new Object[]{request.getRemoteAddr(), request.getRemotePort(), e.getMessage(), e});
                return null;
            }
        }
        if (url.lastIndexOf("/") == url.length() - 1) {
            url.deleteCharAt(url.lastIndexOf("/"));
        }
        url.append(requestUri);
        String query = request.getQueryString();
        if (query != null) {
            url.append("?").append(query);
        }
        if (!this.validateDestination((rewrittenUrl = URI.create(url.toString()).normalize()).getHost(), rewrittenUrl.getPort())) {
            return null;
        }
        return rewrittenUrl.toString();
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        String user = (String)clientRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName);
        if (user != null) {
            proxyRequest.header(ORIGINAL_PRINCIPAL_HEADER, user);
        }
    }

    protected class ReplayableProxyContentProvider
    extends ProxyServlet.ProxyInputStreamContentProvider {
        static final int MIN_REPLAY_BODY_BUFFER_SIZE = 64;
        private boolean bodyBufferAvailable;
        private boolean bodyBufferMaxSizeReached;
        private final ByteArrayOutputStream bodyBuffer;
        private final long httpInputMaxReplayBufferSize;

        protected ReplayableProxyContentProvider(HttpServletRequest request, HttpServletResponse response, Request proxyRequest, InputStream input, int httpInputMaxReplayBufferSize) {
            super((ProxyServlet)AdminProxyHandler.this, request, response, proxyRequest, input);
            this.bodyBufferAvailable = false;
            this.bodyBufferMaxSizeReached = false;
            this.bodyBuffer = new ByteArrayOutputStream(Math.min(Math.max(request.getContentLength(), 64), httpInputMaxReplayBufferSize));
            this.httpInputMaxReplayBufferSize = httpInputMaxReplayBufferSize;
        }

        public Iterator<ByteBuffer> iterator() {
            if (this.bodyBufferAvailable) {
                return Collections.singleton(ByteBuffer.wrap(this.bodyBuffer.toByteArray())).iterator();
            }
            this.bodyBufferAvailable = true;
            return super.iterator();
        }

        protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
            if (!this.bodyBufferMaxSizeReached) {
                if ((long)(this.bodyBuffer.size() + length) < this.httpInputMaxReplayBufferSize) {
                    this.bodyBuffer.write(buffer, offset, length);
                } else {
                    this.bodyBufferMaxSizeReached = true;
                    this.bodyBufferAvailable = false;
                    this.bodyBuffer.reset();
                }
            }
            return super.onRead(buffer, offset, length);
        }
    }

    private static class JettyHttpClient
    extends HttpClient {
        private static final int NUMBER_OF_SELECTOR_THREADS = 1;

        public JettyHttpClient() {
            super((HttpClientTransport)new HttpClientTransportOverHTTP(1), null);
        }

        public JettyHttpClient(SslContextFactory sslContextFactory) {
            super((HttpClientTransport)new HttpClientTransportOverHTTP(1), sslContextFactory);
        }

        protected Request copyRequest(HttpRequest oldRequest, URI newURI) {
            String authorization = oldRequest.getHeaders().get(HttpHeader.AUTHORIZATION);
            Request newRequest = super.copyRequest(oldRequest, newURI);
            if (authorization != null) {
                newRequest.header(HttpHeader.AUTHORIZATION, authorization);
            }
            return newRequest;
        }
    }
}

