/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.stats;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BatchMetadataStoreStats
implements AutoCloseable {
    private static final double[] BUCKETS = new double[]{1.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
    private static final String NAME = "name";
    private static final Gauge EXECUTOR_QUEUE_SIZE = (Gauge)((Gauge.Builder)Gauge.build((String)"pulsar_batch_metadata_store_executor_queue_size", (String)"-").labelNames(new String[]{"name"})).register();
    private static final Histogram OPS_WAITING = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build((String)"pulsar_batch_metadata_store_queue_wait_time", (String)"-").unit("ms")).labelNames(new String[]{"name"})).buckets(BUCKETS).register();
    private static final Histogram BATCH_EXECUTE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build((String)"pulsar_batch_metadata_store_batch_execute_time", (String)"-").unit("ms")).labelNames(new String[]{"name"})).buckets(BUCKETS).register();
    private static final Histogram OPS_PER_BATCH = (Histogram)((Histogram.Builder)Histogram.build((String)"pulsar_batch_metadata_store_batch_size", (String)"-").labelNames(new String[]{"name"})).buckets(BUCKETS).register();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ThreadPoolExecutor executor;
    private final String metadataStoreName;
    private final Histogram.Child batchOpsWaitingChild;
    private final Histogram.Child batchExecuteTimeChild;
    private final Histogram.Child opsPerBatchChild;

    public BatchMetadataStoreStats(String metadataStoreName, ExecutorService executor) {
        ThreadPoolExecutor tx;
        this.executor = executor instanceof ThreadPoolExecutor ? (tx = (ThreadPoolExecutor)executor) : null;
        this.metadataStoreName = metadataStoreName;
        EXECUTOR_QUEUE_SIZE.setChild((Object)new Gauge.Child(){

            public double get() {
                return BatchMetadataStoreStats.this.executor == null ? 0.0 : (double)BatchMetadataStoreStats.this.executor.getQueue().size();
            }
        }, new String[]{metadataStoreName});
        this.batchOpsWaitingChild = (Histogram.Child)OPS_WAITING.labels(new String[]{metadataStoreName});
        this.batchExecuteTimeChild = (Histogram.Child)BATCH_EXECUTE_TIME.labels(new String[]{metadataStoreName});
        this.opsPerBatchChild = (Histogram.Child)OPS_PER_BATCH.labels(new String[]{metadataStoreName});
    }

    public void recordOpWaiting(long millis) {
        this.batchOpsWaitingChild.observe((double)millis);
    }

    public void recordBatchExecuteTime(long millis) {
        this.batchExecuteTimeChild.observe((double)millis);
    }

    public void recordOpsInBatch(int ops) {
        this.opsPerBatchChild.observe((double)ops);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            EXECUTOR_QUEUE_SIZE.remove(new String[]{this.metadataStoreName});
            OPS_WAITING.remove(new String[]{this.metadataStoreName});
            BATCH_EXECUTE_TIME.remove(new String[]{this.metadataStoreName});
            OPS_PER_BATCH.remove(new String[]{this.metadataStoreName});
        }
    }
}

