/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.solr;

import java.util.List;
import lombok.Generated;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.solr.SolrAbstractSink;
import org.apache.pulsar.io.solr.SolrSinkConfig;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="solr", type=IOType.SINK, help="The SolrGenericRecordSink is used for moving messages from Pulsar to Solr.", configClass=SolrSinkConfig.class)
public class SolrGenericRecordSink
extends SolrAbstractSink<GenericRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolrGenericRecordSink.class);

    @Override
    public SolrInputDocument convert(Record<GenericRecord> message) {
        SolrInputDocument doc = new SolrInputDocument();
        GenericRecord record = (GenericRecord)message.getValue();
        List fields = record.getFields();
        for (Field field : fields) {
            Object fieldValue = record.getField(field);
            doc.setField(field.getName(), fieldValue);
        }
        return doc;
    }
}

