/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.aws.AwsCredentialProviderPlugin;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.kinesis.BaseKinesisConfig;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.KinesisClientUtil;

public class KinesisSourceConfig
extends BaseKinesisConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="LATEST", help="Used to specify the position in the stream where the connector should start from.\n  #\n  # The available options are: \n  #\n  # - AT_TIMESTAMP \n  #\n  #   Start from the record at or after the specified timestamp. \n  #\n  # - LATEST \n  #\n  #   Start after the most recent data record (fetch new data). \n  #\n  # - TRIM_HORIZON \n  #\n  #   Start from the oldest available data record. \n")
    private InitialPositionInStream initialPositionInStream = InitialPositionInStream.LATEST;
    @FieldDoc(required=false, defaultValue="", help="If the initalPositionInStream is set to 'AT_TIMESTAMP', then this  property specifies the point in time to start consumption.")
    private Date startAtTime;
    @FieldDoc(required=false, defaultValue="pulsar-kinesis", help="Name of the Amazon Kinesis application. By default the application name is included in the user agent string used to make AWS requests. This can assist with troubleshooting (e.g. distinguish requests made by separate connectors instances).")
    private String applicationName = "pulsar-kinesis";
    @FieldDoc(required=false, defaultValue="60000", help="The frequency of the Kinesis stream checkpointing (in milliseconds)")
    private long checkpointInterval = 60000L;
    @FieldDoc(required=false, defaultValue="3000", help="The amount of time to delay between requests when the connector encounters a Throttlingexception from AWS Kinesis (in milliseconds)")
    private long backoffTime = 3000L;
    @FieldDoc(required=false, defaultValue="3", help="The number of re-attempts to make when the connector encounters an exception while trying to set a checkpoint")
    private int numRetries = 3;
    @FieldDoc(required=false, defaultValue="1000", help="The maximum number of AWS Records that can be buffered inside the connector. Once this is reached, the connector will not consume any more messages from Kinesis until some of the messages in the queue have been successfully consumed.")
    private int receiveQueueSize = 1000;
    @FieldDoc(required=false, defaultValue="", help="Dynamo end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String dynamoEndpoint = "";
    @FieldDoc(required=false, defaultValue="true", help="When true, uses Kinesis enhanced fan-out, when false, uses polling")
    private boolean useEnhancedFanOut = true;

    public static KinesisSourceConfig load(Map<String, Object> config, SourceContext sourceContext) {
        KinesisSourceConfig kinesisSourceConfig = (KinesisSourceConfig)IOConfigUtils.loadWithSecrets(config, KinesisSourceConfig.class, (SourceContext)sourceContext);
        boolean isNotBlankEndpoint = StringUtils.isNotBlank((CharSequence)kinesisSourceConfig.getAwsEndpoint()) && StringUtils.isNotBlank((CharSequence)kinesisSourceConfig.getCloudwatchEndpoint()) && StringUtils.isNotBlank((CharSequence)kinesisSourceConfig.getDynamoEndpoint());
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)kinesisSourceConfig.getAwsRegion()) || isNotBlankEndpoint ? 1 : 0) != 0, (Object)"Either \"awsRegion\" must be set OR all of [ \"awsEndpoint\", \"cloudwatchEndpoint\", and \"dynamoEndpoint\" ] must be set.");
        if (kinesisSourceConfig.getInitialPositionInStream() == InitialPositionInStream.AT_TIMESTAMP) {
            Preconditions.checkArgument((kinesisSourceConfig.getStartAtTime() != null ? 1 : 0) != 0, (Object)"When initialPositionInStream is AT_TIMESTAMP, startAtTime must be specified");
        }
        return kinesisSourceConfig;
    }

    public KinesisAsyncClient buildKinesisAsyncClient(AwsCredentialProviderPlugin credPlugin) {
        KinesisAsyncClientBuilder builder = KinesisAsyncClient.builder();
        if (!this.getAwsEndpoint().isEmpty()) {
            builder.endpointOverride(URI.create(this.getAwsEndpoint()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.region(this.regionAsV2Region());
        }
        builder.credentialsProvider(credPlugin.getV2CredentialsProvider());
        return KinesisClientUtil.createKinesisAsyncClient((KinesisAsyncClientBuilder)builder);
    }

    public DynamoDbAsyncClient buildDynamoAsyncClient(AwsCredentialProviderPlugin credPlugin) {
        DynamoDbAsyncClientBuilder builder = DynamoDbAsyncClient.builder();
        if (!this.getDynamoEndpoint().isEmpty()) {
            builder.endpointOverride(URI.create(this.getDynamoEndpoint()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.region(this.regionAsV2Region());
        }
        builder.credentialsProvider(credPlugin.getV2CredentialsProvider());
        return (DynamoDbAsyncClient)builder.build();
    }

    public CloudWatchAsyncClient buildCloudwatchAsyncClient(AwsCredentialProviderPlugin credPlugin) {
        CloudWatchAsyncClientBuilder builder = CloudWatchAsyncClient.builder();
        if (!this.getCloudwatchEndpoint().isEmpty()) {
            builder.endpointOverride(URI.create(this.getCloudwatchEndpoint()));
        }
        if (!this.getAwsRegion().isEmpty()) {
            builder.region(this.regionAsV2Region());
        }
        builder.credentialsProvider(credPlugin.getV2CredentialsProvider());
        return (CloudWatchAsyncClient)builder.build();
    }

    public InitialPositionInStreamExtended getStreamStartPosition() {
        if (this.initialPositionInStream == InitialPositionInStream.AT_TIMESTAMP) {
            return InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)this.getStartAtTime());
        }
        return InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)this.getInitialPositionInStream());
    }

    @Generated
    public KinesisSourceConfig() {
    }

    @Generated
    public InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    @Generated
    public Date getStartAtTime() {
        return this.startAtTime;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    @Generated
    public long getBackoffTime() {
        return this.backoffTime;
    }

    @Generated
    public int getNumRetries() {
        return this.numRetries;
    }

    @Generated
    public int getReceiveQueueSize() {
        return this.receiveQueueSize;
    }

    @Generated
    public String getDynamoEndpoint() {
        return this.dynamoEndpoint;
    }

    @Generated
    public boolean isUseEnhancedFanOut() {
        return this.useEnhancedFanOut;
    }

    @Generated
    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
    }

    @Generated
    public void setStartAtTime(Date startAtTime) {
        this.startAtTime = startAtTime;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    @Generated
    public void setBackoffTime(long backoffTime) {
        this.backoffTime = backoffTime;
    }

    @Generated
    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    @Generated
    public void setReceiveQueueSize(int receiveQueueSize) {
        this.receiveQueueSize = receiveQueueSize;
    }

    @Generated
    public void setDynamoEndpoint(String dynamoEndpoint) {
        this.dynamoEndpoint = dynamoEndpoint;
    }

    @Generated
    public void setUseEnhancedFanOut(boolean useEnhancedFanOut) {
        this.useEnhancedFanOut = useEnhancedFanOut;
    }

    @Override
    @Generated
    public String toString() {
        return "KinesisSourceConfig(initialPositionInStream=" + String.valueOf(this.getInitialPositionInStream()) + ", startAtTime=" + String.valueOf(this.getStartAtTime()) + ", applicationName=" + this.getApplicationName() + ", checkpointInterval=" + this.getCheckpointInterval() + ", backoffTime=" + this.getBackoffTime() + ", numRetries=" + this.getNumRetries() + ", receiveQueueSize=" + this.getReceiveQueueSize() + ", dynamoEndpoint=" + this.getDynamoEndpoint() + ", useEnhancedFanOut=" + this.isUseEnhancedFanOut() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisSourceConfig)) {
            return false;
        }
        KinesisSourceConfig other = (KinesisSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCheckpointInterval() != other.getCheckpointInterval()) {
            return false;
        }
        if (this.getBackoffTime() != other.getBackoffTime()) {
            return false;
        }
        if (this.getNumRetries() != other.getNumRetries()) {
            return false;
        }
        if (this.getReceiveQueueSize() != other.getReceiveQueueSize()) {
            return false;
        }
        if (this.isUseEnhancedFanOut() != other.isUseEnhancedFanOut()) {
            return false;
        }
        InitialPositionInStream this$initialPositionInStream = this.getInitialPositionInStream();
        InitialPositionInStream other$initialPositionInStream = other.getInitialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        Date this$startAtTime = this.getStartAtTime();
        Date other$startAtTime = other.getStartAtTime();
        if (this$startAtTime == null ? other$startAtTime != null : !((Object)this$startAtTime).equals(other$startAtTime)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$dynamoEndpoint = this.getDynamoEndpoint();
        String other$dynamoEndpoint = other.getDynamoEndpoint();
        return !(this$dynamoEndpoint == null ? other$dynamoEndpoint != null : !this$dynamoEndpoint.equals(other$dynamoEndpoint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KinesisSourceConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $checkpointInterval = this.getCheckpointInterval();
        result = result * 59 + (int)($checkpointInterval >>> 32 ^ $checkpointInterval);
        long $backoffTime = this.getBackoffTime();
        result = result * 59 + (int)($backoffTime >>> 32 ^ $backoffTime);
        result = result * 59 + this.getNumRetries();
        result = result * 59 + this.getReceiveQueueSize();
        result = result * 59 + (this.isUseEnhancedFanOut() ? 79 : 97);
        InitialPositionInStream $initialPositionInStream = this.getInitialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        Date $startAtTime = this.getStartAtTime();
        result = result * 59 + ($startAtTime == null ? 43 : ((Object)$startAtTime).hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $dynamoEndpoint = this.getDynamoEndpoint();
        result = result * 59 + ($dynamoEndpoint == null ? 43 : $dynamoEndpoint.hashCode());
        return result;
    }
}

