/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.kinesis.BaseKinesisConfig;

public class KinesisSinkConfig
extends BaseKinesisConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", help="Kinesis end-point port. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private Integer awsEndpointPort;
    @FieldDoc(required=false, defaultValue="false", help="Tell to Kinesis Client to skip certificate validation. This is useful while performing local tests, it's recommended to always validate certificates in production environments.")
    private Boolean skipCertificateValidation = false;
    @FieldDoc(required=false, defaultValue="ONLY_RAW_PAYLOAD", help="Message format in which kinesis sink converts pulsar messages and publishes to kinesis streams.\n  #\n  # The available messages formats are: \n  #\n  # - ONLY_RAW_PAYLOAD \n  #\n  #   Kinesis sink directly publishes pulsar message payload as a message into the configured kinesis stream. \n  #\n  # - FULL_MESSAGE_IN_JSON \n  #\n  #   Kinesis sink creates a json payload with pulsar message payload, properties and encryptionCtx, \n  #   and publishes json payload into the configured kinesis stream.\n  #\n  # - FULL_MESSAGE_IN_FB \n  #\n  #   Kinesis sink creates a flatbuffer serialized paylaod with pulsar message payload, \n  #   properties and encryptionCtx, and publishes flatbuffer payload into the configured kinesis stream.  #\n  # - FULL_MESSAGE_IN_JSON_EXPAND_VALUE \n  #\n  #   Kinesis sink sends a JSON structure containing the record topic name, key, payload, properties and event time.\n  #   The record schema is used to convert the value to JSON.")
    private MessageFormat messageFormat = MessageFormat.ONLY_RAW_PAYLOAD;
    @FieldDoc(defaultValue="true", help="Value that indicates that only properties with non-null values are to be included when using MessageFormat.FULL_MESSAGE_IN_JSON_EXPAND_VALUE.")
    private boolean jsonIncludeNonNulls = true;
    @FieldDoc(defaultValue="false", help="When set to true and the message format is FULL_MESSAGE_IN_JSON_EXPAND_VALUE the output JSON will be flattened.")
    private boolean jsonFlatten = false;
    @FieldDoc(defaultValue="false", help="A flag to tell Pulsar IO to retain ordering when moving messages from Pulsar to Kinesis")
    private boolean retainOrdering = false;
    @FieldDoc(defaultValue="100", help="The initial delay(in milliseconds) between retries.")
    private long retryInitialDelayInMillis = 100L;
    @FieldDoc(defaultValue="60000", help="The maximum delay(in milliseconds) between retries.")
    private long retryMaxDelayInMillis = 60000L;
    @FieldDoc(required=false, defaultValue="", help="Path to the native Amazon Kinesis Producer Library (KPL) binary.\nOnly use this setting if you want to use a custom build of the native code.\nThis setting can also be set with the environment variable `PULSAR_IO_KINESIS_KPL_PATH`.\nIf not set, the Kinesis sink will use the built-in native executable.")
    private String nativeExecutable = System.getenv("PULSAR_IO_KINESIS_KPL_PATH");
    @FieldDoc(required=false, defaultValue="", help="Custom AWS STS endpoint")
    private String awsStsEndpoint = "";
    @FieldDoc(required=false, defaultValue="", help="Custom AWS STS port to connect to")
    private Integer awsStsPort;
    @FieldDoc(defaultValue="true", help="Enable aggregation. With aggregation, multiple user records could be packed into a single\n KinesisRecord. If disabled, each user record is sent in its own KinesisRecord.")
    private boolean aggregationEnabled = true;

    public static KinesisSinkConfig load(Map<String, Object> config, SinkContext sinkContext) {
        KinesisSinkConfig kinesisSinkConfig = (KinesisSinkConfig)IOConfigUtils.loadWithSecrets(config, KinesisSinkConfig.class, (SinkContext)sinkContext);
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getAwsRegion()) || StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getAwsEndpoint()) && StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getCloudwatchEndpoint()) ? 1 : 0) != 0, (Object)"Either \"awsRegion\" must be set OR all of [\"awsEndpoint\", \"cloudwatchEndpoint\"] must be set.");
        return kinesisSinkConfig;
    }

    @Generated
    public KinesisSinkConfig() {
    }

    @Generated
    public Integer getAwsEndpointPort() {
        return this.awsEndpointPort;
    }

    @Generated
    public Boolean getSkipCertificateValidation() {
        return this.skipCertificateValidation;
    }

    @Generated
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Generated
    public boolean isJsonIncludeNonNulls() {
        return this.jsonIncludeNonNulls;
    }

    @Generated
    public boolean isJsonFlatten() {
        return this.jsonFlatten;
    }

    @Generated
    public boolean isRetainOrdering() {
        return this.retainOrdering;
    }

    @Generated
    public long getRetryInitialDelayInMillis() {
        return this.retryInitialDelayInMillis;
    }

    @Generated
    public long getRetryMaxDelayInMillis() {
        return this.retryMaxDelayInMillis;
    }

    @Generated
    public String getNativeExecutable() {
        return this.nativeExecutable;
    }

    @Generated
    public String getAwsStsEndpoint() {
        return this.awsStsEndpoint;
    }

    @Generated
    public Integer getAwsStsPort() {
        return this.awsStsPort;
    }

    @Generated
    public boolean isAggregationEnabled() {
        return this.aggregationEnabled;
    }

    @Generated
    public void setAwsEndpointPort(Integer awsEndpointPort) {
        this.awsEndpointPort = awsEndpointPort;
    }

    @Generated
    public void setSkipCertificateValidation(Boolean skipCertificateValidation) {
        this.skipCertificateValidation = skipCertificateValidation;
    }

    @Generated
    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    @Generated
    public void setJsonIncludeNonNulls(boolean jsonIncludeNonNulls) {
        this.jsonIncludeNonNulls = jsonIncludeNonNulls;
    }

    @Generated
    public void setJsonFlatten(boolean jsonFlatten) {
        this.jsonFlatten = jsonFlatten;
    }

    @Generated
    public void setRetainOrdering(boolean retainOrdering) {
        this.retainOrdering = retainOrdering;
    }

    @Generated
    public void setRetryInitialDelayInMillis(long retryInitialDelayInMillis) {
        this.retryInitialDelayInMillis = retryInitialDelayInMillis;
    }

    @Generated
    public void setRetryMaxDelayInMillis(long retryMaxDelayInMillis) {
        this.retryMaxDelayInMillis = retryMaxDelayInMillis;
    }

    @Generated
    public void setNativeExecutable(String nativeExecutable) {
        this.nativeExecutable = nativeExecutable;
    }

    @Generated
    public void setAwsStsEndpoint(String awsStsEndpoint) {
        this.awsStsEndpoint = awsStsEndpoint;
    }

    @Generated
    public void setAwsStsPort(Integer awsStsPort) {
        this.awsStsPort = awsStsPort;
    }

    @Generated
    public void setAggregationEnabled(boolean aggregationEnabled) {
        this.aggregationEnabled = aggregationEnabled;
    }

    @Override
    @Generated
    public String toString() {
        return "KinesisSinkConfig(awsEndpointPort=" + this.getAwsEndpointPort() + ", skipCertificateValidation=" + this.getSkipCertificateValidation() + ", messageFormat=" + String.valueOf((Object)this.getMessageFormat()) + ", jsonIncludeNonNulls=" + this.isJsonIncludeNonNulls() + ", jsonFlatten=" + this.isJsonFlatten() + ", retainOrdering=" + this.isRetainOrdering() + ", retryInitialDelayInMillis=" + this.getRetryInitialDelayInMillis() + ", retryMaxDelayInMillis=" + this.getRetryMaxDelayInMillis() + ", nativeExecutable=" + this.getNativeExecutable() + ", awsStsEndpoint=" + this.getAwsStsEndpoint() + ", awsStsPort=" + this.getAwsStsPort() + ", aggregationEnabled=" + this.isAggregationEnabled() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisSinkConfig)) {
            return false;
        }
        KinesisSinkConfig other = (KinesisSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isJsonIncludeNonNulls() != other.isJsonIncludeNonNulls()) {
            return false;
        }
        if (this.isJsonFlatten() != other.isJsonFlatten()) {
            return false;
        }
        if (this.isRetainOrdering() != other.isRetainOrdering()) {
            return false;
        }
        if (this.getRetryInitialDelayInMillis() != other.getRetryInitialDelayInMillis()) {
            return false;
        }
        if (this.getRetryMaxDelayInMillis() != other.getRetryMaxDelayInMillis()) {
            return false;
        }
        if (this.isAggregationEnabled() != other.isAggregationEnabled()) {
            return false;
        }
        Integer this$awsEndpointPort = this.getAwsEndpointPort();
        Integer other$awsEndpointPort = other.getAwsEndpointPort();
        if (this$awsEndpointPort == null ? other$awsEndpointPort != null : !((Object)this$awsEndpointPort).equals(other$awsEndpointPort)) {
            return false;
        }
        Boolean this$skipCertificateValidation = this.getSkipCertificateValidation();
        Boolean other$skipCertificateValidation = other.getSkipCertificateValidation();
        if (this$skipCertificateValidation == null ? other$skipCertificateValidation != null : !((Object)this$skipCertificateValidation).equals(other$skipCertificateValidation)) {
            return false;
        }
        Integer this$awsStsPort = this.getAwsStsPort();
        Integer other$awsStsPort = other.getAwsStsPort();
        if (this$awsStsPort == null ? other$awsStsPort != null : !((Object)this$awsStsPort).equals(other$awsStsPort)) {
            return false;
        }
        MessageFormat this$messageFormat = this.getMessageFormat();
        MessageFormat other$messageFormat = other.getMessageFormat();
        if (this$messageFormat == null ? other$messageFormat != null : !((Object)((Object)this$messageFormat)).equals((Object)other$messageFormat)) {
            return false;
        }
        String this$nativeExecutable = this.getNativeExecutable();
        String other$nativeExecutable = other.getNativeExecutable();
        if (this$nativeExecutable == null ? other$nativeExecutable != null : !this$nativeExecutable.equals(other$nativeExecutable)) {
            return false;
        }
        String this$awsStsEndpoint = this.getAwsStsEndpoint();
        String other$awsStsEndpoint = other.getAwsStsEndpoint();
        return !(this$awsStsEndpoint == null ? other$awsStsEndpoint != null : !this$awsStsEndpoint.equals(other$awsStsEndpoint));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KinesisSinkConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isJsonIncludeNonNulls() ? 79 : 97);
        result = result * 59 + (this.isJsonFlatten() ? 79 : 97);
        result = result * 59 + (this.isRetainOrdering() ? 79 : 97);
        long $retryInitialDelayInMillis = this.getRetryInitialDelayInMillis();
        result = result * 59 + (int)($retryInitialDelayInMillis >>> 32 ^ $retryInitialDelayInMillis);
        long $retryMaxDelayInMillis = this.getRetryMaxDelayInMillis();
        result = result * 59 + (int)($retryMaxDelayInMillis >>> 32 ^ $retryMaxDelayInMillis);
        result = result * 59 + (this.isAggregationEnabled() ? 79 : 97);
        Integer $awsEndpointPort = this.getAwsEndpointPort();
        result = result * 59 + ($awsEndpointPort == null ? 43 : ((Object)$awsEndpointPort).hashCode());
        Boolean $skipCertificateValidation = this.getSkipCertificateValidation();
        result = result * 59 + ($skipCertificateValidation == null ? 43 : ((Object)$skipCertificateValidation).hashCode());
        Integer $awsStsPort = this.getAwsStsPort();
        result = result * 59 + ($awsStsPort == null ? 43 : ((Object)$awsStsPort).hashCode());
        MessageFormat $messageFormat = this.getMessageFormat();
        result = result * 59 + ($messageFormat == null ? 43 : ((Object)((Object)$messageFormat)).hashCode());
        String $nativeExecutable = this.getNativeExecutable();
        result = result * 59 + ($nativeExecutable == null ? 43 : $nativeExecutable.hashCode());
        String $awsStsEndpoint = this.getAwsStsEndpoint();
        result = result * 59 + ($awsStsEndpoint == null ? 43 : $awsStsEndpoint.hashCode());
        return result;
    }

    public static enum MessageFormat {
        ONLY_RAW_PAYLOAD,
        FULL_MESSAGE_IN_JSON,
        FULL_MESSAGE_IN_FB,
        FULL_MESSAGE_IN_JSON_EXPAND_VALUE;

    }
}

