/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.flume.node;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.pulsar.io.flume.node.AbstractConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileConfigurationProvider
extends AbstractConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileConfigurationProvider.class);
    private static final String DEFAULT_PROPERTIES_IMPLEMENTATION = "java.util.Properties";
    private final File file;

    public PropertiesFileConfigurationProvider(String agentName, File file) {
        super(agentName);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlumeConfiguration getFlumeConfiguration() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.file));
            String resolverClassName = System.getProperty("propertiesImplementation", DEFAULT_PROPERTIES_IMPLEMENTATION);
            Class<Properties> propsclass = Class.forName(resolverClassName).asSubclass(Properties.class);
            Properties properties = propsclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            properties.load(reader);
            FlumeConfiguration flumeConfiguration = new FlumeConfiguration(this.toMap(properties));
            return flumeConfiguration;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load file:" + String.valueOf(this.file) + " (I/O failure) - Exception follows.", (Throwable)ex);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.error("Configuration resolver class not found", e);
        }
        catch (InstantiationException e) {
            LOGGER.error("Instantiation exception", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal access exception", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Invocation target exception", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("No such method exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Unable to close file reader for file: " + String.valueOf(this.file), (Throwable)ex);
                }
            }
        }
        return new FlumeConfiguration(new HashMap());
    }
}

