/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.azuredataexplorer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class ADXSinkConfig
implements Serializable {
    @FieldDoc(required=true, defaultValue="", help="The ADX cluster URL")
    private String clusterUrl;
    @FieldDoc(required=true, defaultValue="", help="The database name to which data need to be ingested")
    private String database;
    @FieldDoc(required=true, defaultValue="", help="Table name to which pulsar data need to be ingested.")
    private String table;
    @FieldDoc(defaultValue="", help="The AAD app Id for authentication", sensitive=true)
    private String appId;
    @FieldDoc(defaultValue="", help="The AAD app secret for authentication", sensitive=true)
    private String appKey;
    @FieldDoc(defaultValue="", help="The tenant Id for authentication")
    private String tenantId;
    @FieldDoc(defaultValue="", help="The Managed Identity credential for authentication. Set this with clientId in case of User assigned MI. and 'system' in case of System assigned managed identity")
    private String managedIdentityId;
    @FieldDoc(defaultValue="", help="The mapping reference for ingestion")
    private String mappingRefName;
    @FieldDoc(defaultValue="", help="The type of mapping reference provided")
    private String mappingRefType;
    @FieldDoc(defaultValue="false", help="Denotes if flush should happen immediately without aggregation. Not recommended to enable flushImmediately for production workloads")
    private boolean flushImmediately = false;
    @FieldDoc(defaultValue="100", help="For batching, this defines the number of records to hold for batching, to sink data to adx")
    private int batchSize = 100;
    @FieldDoc(defaultValue="10000", help="For batching, this defines the time to hold records before sink to adx")
    private long batchTimeMs = 10000L;
    @FieldDoc(defaultValue="1", help="Max retry attempts, In case of transient ingestion errors")
    private int maxRetryAttempts = 1;
    @FieldDoc(defaultValue="10", help="Period of time in milliseconds to backoff before retry for transient errors")
    private long retryBackOffTime = 10L;

    public static ADXSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (ADXSinkConfig)mapper.readValue(new File(yamlFile), ADXSinkConfig.class);
    }

    protected static ADXSinkConfig load(Map<String, Object> config, SinkContext sinkContext) {
        return (ADXSinkConfig)IOConfigUtils.loadWithSecrets(config, ADXSinkConfig.class, (SinkContext)sinkContext);
    }

    public void validate() throws Exception {
        Objects.requireNonNull(this.clusterUrl, "clusterUrl property not set.");
        Objects.requireNonNull(this.database, "database property not set.");
        Objects.requireNonNull(this.table, "table property not set.");
        if (this.managedIdentityId == null && (this.appId == null || this.appKey == null || this.tenantId == null)) {
            throw new Exception("Auth credentials not valid");
        }
    }

    @Generated
    public ADXSinkConfig() {
    }

    @Generated
    public String getClusterUrl() {
        return this.clusterUrl;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getAppKey() {
        return this.appKey;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getManagedIdentityId() {
        return this.managedIdentityId;
    }

    @Generated
    public String getMappingRefName() {
        return this.mappingRefName;
    }

    @Generated
    public String getMappingRefType() {
        return this.mappingRefType;
    }

    @Generated
    public boolean isFlushImmediately() {
        return this.flushImmediately;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    @Generated
    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    @Generated
    public long getRetryBackOffTime() {
        return this.retryBackOffTime;
    }

    @Generated
    public ADXSinkConfig setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
        return this;
    }

    @Generated
    public ADXSinkConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    @Generated
    public ADXSinkConfig setTable(String table) {
        this.table = table;
        return this;
    }

    @Generated
    public ADXSinkConfig setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    @Generated
    public ADXSinkConfig setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @Generated
    public ADXSinkConfig setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Generated
    public ADXSinkConfig setManagedIdentityId(String managedIdentityId) {
        this.managedIdentityId = managedIdentityId;
        return this;
    }

    @Generated
    public ADXSinkConfig setMappingRefName(String mappingRefName) {
        this.mappingRefName = mappingRefName;
        return this;
    }

    @Generated
    public ADXSinkConfig setMappingRefType(String mappingRefType) {
        this.mappingRefType = mappingRefType;
        return this;
    }

    @Generated
    public ADXSinkConfig setFlushImmediately(boolean flushImmediately) {
        this.flushImmediately = flushImmediately;
        return this;
    }

    @Generated
    public ADXSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Generated
    public ADXSinkConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    @Generated
    public ADXSinkConfig setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
        return this;
    }

    @Generated
    public ADXSinkConfig setRetryBackOffTime(long retryBackOffTime) {
        this.retryBackOffTime = retryBackOffTime;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ADXSinkConfig)) {
            return false;
        }
        ADXSinkConfig other = (ADXSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFlushImmediately() != other.isFlushImmediately()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        if (this.getMaxRetryAttempts() != other.getMaxRetryAttempts()) {
            return false;
        }
        if (this.getRetryBackOffTime() != other.getRetryBackOffTime()) {
            return false;
        }
        String this$clusterUrl = this.getClusterUrl();
        String other$clusterUrl = other.getClusterUrl();
        if (this$clusterUrl == null ? other$clusterUrl != null : !this$clusterUrl.equals(other$clusterUrl)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$managedIdentityId = this.getManagedIdentityId();
        String other$managedIdentityId = other.getManagedIdentityId();
        if (this$managedIdentityId == null ? other$managedIdentityId != null : !this$managedIdentityId.equals(other$managedIdentityId)) {
            return false;
        }
        String this$mappingRefName = this.getMappingRefName();
        String other$mappingRefName = other.getMappingRefName();
        if (this$mappingRefName == null ? other$mappingRefName != null : !this$mappingRefName.equals(other$mappingRefName)) {
            return false;
        }
        String this$mappingRefType = this.getMappingRefType();
        String other$mappingRefType = other.getMappingRefType();
        return !(this$mappingRefType == null ? other$mappingRefType != null : !this$mappingRefType.equals(other$mappingRefType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ADXSinkConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlushImmediately() ? 79 : 97);
        result = result * 59 + this.getBatchSize();
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        result = result * 59 + this.getMaxRetryAttempts();
        long $retryBackOffTime = this.getRetryBackOffTime();
        result = result * 59 + (int)($retryBackOffTime >>> 32 ^ $retryBackOffTime);
        String $clusterUrl = this.getClusterUrl();
        result = result * 59 + ($clusterUrl == null ? 43 : $clusterUrl.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $managedIdentityId = this.getManagedIdentityId();
        result = result * 59 + ($managedIdentityId == null ? 43 : $managedIdentityId.hashCode());
        String $mappingRefName = this.getMappingRefName();
        result = result * 59 + ($mappingRefName == null ? 43 : $mappingRefName.hashCode());
        String $mappingRefType = this.getMappingRefType();
        result = result * 59 + ($mappingRefType == null ? 43 : $mappingRefType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ADXSinkConfig(clusterUrl=" + this.getClusterUrl() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", appId=" + this.getAppId() + ", appKey=" + this.getAppKey() + ", tenantId=" + this.getTenantId() + ", managedIdentityId=" + this.getManagedIdentityId() + ", mappingRefName=" + this.getMappingRefName() + ", mappingRefType=" + this.getMappingRefType() + ", flushImmediately=" + this.isFlushImmediately() + ", batchSize=" + this.getBatchSize() + ", batchTimeMs=" + this.getBatchTimeMs() + ", maxRetryAttempts=" + this.getMaxRetryAttempts() + ", retryBackOffTime=" + this.getRetryBackOffTime() + ")";
    }
}

