/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.io.aws.AwsCredentialProviderPlugin;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;

public class STSAssumeRoleProviderPlugin
implements AwsCredentialProviderPlugin {
    public static final String ASSUME_ROLE_ARN = "roleArn";
    public static final String ASSUME_ROLE_SESSION_NAME = "roleSessionName";
    private String roleArn;
    private String roleSessionName;

    @Override
    public void init(String param) {
        Map credentialMap = (Map)new Gson().fromJson(param, new TypeToken<Map<String, String>>(){}.getType());
        this.roleArn = (String)credentialMap.get(ASSUME_ROLE_ARN);
        this.roleSessionName = (String)credentialMap.get(ASSUME_ROLE_SESSION_NAME);
    }

    @Override
    public AWSCredentialsProvider getCredentialProvider() {
        return new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleArn, this.roleSessionName).build();
    }

    @Override
    public AwsCredentialsProvider getV2CredentialsProvider() {
        StsClient client = StsClient.create();
        return (AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(client)).refreshRequest(req -> req.roleArn(this.roleArn).roleSessionName(this.roleSessionName).build()).build();
    }

    @Override
    public void close() throws IOException {
    }
}

