/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.alluxio.sink;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.io.alluxio.AlluxioAbstractConfig;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class AlluxioSinkConfig
extends AlluxioAbstractConfig
implements Serializable {
    private static final long serialVersionUID = -8917657634001769807L;
    @FieldDoc(required=false, defaultValue="", help="The prefix of the files to create in the Alluxio directory (e.g. a value of 'TopicA' results in files named topicA-, topicA-, etc being produced)")
    private String filePrefix;
    @FieldDoc(required=false, defaultValue="", help="The extension to add to the files written to Alluxio (e.g. '.txt')")
    private String fileExtension;
    @FieldDoc(required=false, defaultValue="", help="The character used to separate records in a text file. If no value is provided then the content from all of the records is concatenated together in one continuous byte array")
    private char lineSeparator;
    @FieldDoc(required=false, defaultValue="10000L", help="The number records of Alluxio file rotation")
    private long rotationRecords = 10000L;
    @FieldDoc(required=false, defaultValue="-1L", help="The interval to rotate a Alluxio file (in milliseconds)")
    private long rotationInterval = -1L;
    @FieldDoc(required=false, defaultValue="MUST_CACHE", help="Default write type when creating Alluxio files. Valid options are `MUST_CACHE` (write only goes to Alluxio and must be stored in Alluxio), `CACHE_THROUGH` (try to cache, write to UnderFS synchronously), `THROUGH` (no cache, write to UnderFS synchronously)")
    private String writeType = "MUST_CACHE";
    @FieldDoc(required=false, defaultValue="false", help="Sets whether the Sink has to take into account the Schema or if it should simply copy the raw message to Alluxio")
    private boolean schemaEnable = false;

    public static AlluxioSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (AlluxioSinkConfig)mapper.readValue(new File(yamlFile), AlluxioSinkConfig.class);
    }

    public static AlluxioSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (AlluxioSinkConfig)mapper.readValue(mapper.writeValueAsString(map), AlluxioSinkConfig.class);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.rotationRecords > 0L ? 1 : 0) != 0, (Object)"rotationRecords must be a positive long.");
        Preconditions.checkArgument((this.rotationInterval == -1L || this.rotationInterval > 0L ? 1 : 0) != 0, (Object)"rotationInterval must be either -1 or a positive long.");
    }

    @Generated
    public AlluxioSinkConfig() {
    }

    @Generated
    public AlluxioSinkConfig setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setLineSeparator(char lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setRotationRecords(long rotationRecords) {
        this.rotationRecords = rotationRecords;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setRotationInterval(long rotationInterval) {
        this.rotationInterval = rotationInterval;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setWriteType(String writeType) {
        this.writeType = writeType;
        return this;
    }

    @Generated
    public AlluxioSinkConfig setSchemaEnable(boolean schemaEnable) {
        this.schemaEnable = schemaEnable;
        return this;
    }

    @Generated
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Generated
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Generated
    public char getLineSeparator() {
        return this.lineSeparator;
    }

    @Generated
    public long getRotationRecords() {
        return this.rotationRecords;
    }

    @Generated
    public long getRotationInterval() {
        return this.rotationInterval;
    }

    @Generated
    public String getWriteType() {
        return this.writeType;
    }

    @Generated
    public boolean isSchemaEnable() {
        return this.schemaEnable;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlluxioSinkConfig)) {
            return false;
        }
        AlluxioSinkConfig other = (AlluxioSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineSeparator() != other.getLineSeparator()) {
            return false;
        }
        if (this.getRotationRecords() != other.getRotationRecords()) {
            return false;
        }
        if (this.getRotationInterval() != other.getRotationInterval()) {
            return false;
        }
        if (this.isSchemaEnable() != other.isSchemaEnable()) {
            return false;
        }
        String this$filePrefix = this.getFilePrefix();
        String other$filePrefix = other.getFilePrefix();
        if (this$filePrefix == null ? other$filePrefix != null : !this$filePrefix.equals(other$filePrefix)) {
            return false;
        }
        String this$fileExtension = this.getFileExtension();
        String other$fileExtension = other.getFileExtension();
        if (this$fileExtension == null ? other$fileExtension != null : !this$fileExtension.equals(other$fileExtension)) {
            return false;
        }
        String this$writeType = this.getWriteType();
        String other$writeType = other.getWriteType();
        return !(this$writeType == null ? other$writeType != null : !this$writeType.equals(other$writeType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlluxioSinkConfig;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineSeparator();
        long $rotationRecords = this.getRotationRecords();
        result = result * 59 + (int)($rotationRecords >>> 32 ^ $rotationRecords);
        long $rotationInterval = this.getRotationInterval();
        result = result * 59 + (int)($rotationInterval >>> 32 ^ $rotationInterval);
        result = result * 59 + (this.isSchemaEnable() ? 79 : 97);
        String $filePrefix = this.getFilePrefix();
        result = result * 59 + ($filePrefix == null ? 43 : $filePrefix.hashCode());
        String $fileExtension = this.getFileExtension();
        result = result * 59 + ($fileExtension == null ? 43 : $fileExtension.hashCode());
        String $writeType = this.getWriteType();
        result = result * 59 + ($writeType == null ? 43 : $writeType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AlluxioSinkConfig(filePrefix=" + this.getFilePrefix() + ", fileExtension=" + this.getFileExtension() + ", lineSeparator=" + this.getLineSeparator() + ", rotationRecords=" + this.getRotationRecords() + ", rotationInterval=" + this.getRotationInterval() + ", writeType=" + this.getWriteType() + ", schemaEnable=" + this.isSchemaEnable() + ")";
    }
}

