/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Serializable;
import java.util.Objects;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Range
implements Comparable<Range>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int start;
    private final int end;

    public Range(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Range end must >= range start.");
        }
        this.start = start;
        this.end = end;
    }

    public static Range of(int start, int end) {
        return new Range(start, end);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Range intersect(Range range) {
        int start = Math.max(range.getStart(), this.getStart());
        int end = Math.min(range.getEnd(), this.getEnd());
        if (end >= start) {
            return Range.of(start, end);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.start == range.start && this.end == range.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    @Override
    public int compareTo(Range o) {
        int result = Integer.compare(this.start, o.start);
        if (result == 0) {
            result = Integer.compare(this.end, o.end);
        }
        return result;
    }
}

