/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.op;

import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.IncrementOption;

class IncrementOpImpl<K, V>
implements IncrementOp<K, V> {
    private final Recycler.Handle<IncrementOpImpl<K, V>> handle;
    private K key;
    private long amount;
    private IncrementOption<K> option;

    @Override
    public OpType type() {
        return OpType.INCREMENT;
    }

    IncrementOpImpl<K, V> key(K key) {
        ReferenceCountUtil.release(this.key);
        this.key = ReferenceCountUtil.retain(key);
        return this;
    }

    IncrementOpImpl<K, V> amount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public void close() {
        ReferenceCountUtil.release(this.key);
        this.key = null;
        this.amount = 0L;
        if (null != this.option) {
            this.option.close();
            this.option = null;
        }
        this.handle.recycle(this);
    }

    public Recycler.Handle<IncrementOpImpl<K, V>> handle() {
        return this.handle;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public long amount() {
        return this.amount;
    }

    @Override
    public IncrementOption<K> option() {
        return this.option;
    }

    IncrementOpImpl<K, V> option(IncrementOption<K> option) {
        this.option = option;
        return this;
    }

    IncrementOpImpl(Recycler.Handle<IncrementOpImpl<K, V>> handle) {
        this.handle = handle;
    }

    public String toString() {
        return "IncrementOpImpl(key=" + this.key() + ", amount=" + this.amount() + ", option=" + this.option() + ")";
    }
}

