/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import org.apache.pulsar.common.util.collections.SegmentedLongArray;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class TripleLongPriorityQueue
implements AutoCloseable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_SHRINK_FACTOR = 0.5f;
    private static final int ITEMS_COUNT = 3;
    private static final float RESERVATION_FACTOR = 0.9f;
    private final SegmentedLongArray array;
    private long tuplesCount;
    private final float shrinkFactor;
    private long shrinkThreshold;

    public TripleLongPriorityQueue() {
        this(16);
    }

    public TripleLongPriorityQueue(long initialCapacity, float shrinkFactor) {
        Preconditions.checkArgument(initialCapacity > 0L);
        Preconditions.checkArgument(shrinkFactor > 0.0f);
        this.array = new SegmentedLongArray(initialCapacity * 3L);
        this.tuplesCount = 0L;
        this.shrinkThreshold = (long)((float)initialCapacity * shrinkFactor);
        this.shrinkFactor = shrinkFactor;
    }

    public TripleLongPriorityQueue(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    @Override
    public void close() {
        this.array.close();
    }

    public void add(long n1, long n2, long n3) {
        long arrayIdx = this.tuplesCount * 3L;
        if (arrayIdx + 2L >= this.array.getCapacity()) {
            this.array.increaseCapacity();
        }
        this.put(this.tuplesCount, n1, n2, n3);
        this.siftUp(this.tuplesCount);
        ++this.tuplesCount;
    }

    public long peekN1() {
        Preconditions.checkArgument(this.tuplesCount != 0L);
        return this.array.readLong(0L);
    }

    public long peekN2() {
        Preconditions.checkArgument(this.tuplesCount != 0L);
        return this.array.readLong(1L);
    }

    public long peekN3() {
        Preconditions.checkArgument(this.tuplesCount != 0L);
        return this.array.readLong(2L);
    }

    public void pop() {
        Preconditions.checkArgument(this.tuplesCount != 0L);
        this.swap(0L, this.tuplesCount - 1L);
        --this.tuplesCount;
        this.siftDown(0L);
        this.shrinkCapacity();
    }

    public boolean isEmpty() {
        return this.tuplesCount == 0L;
    }

    public long size() {
        return this.tuplesCount;
    }

    public long bytesCapacity() {
        return this.array.bytesCapacity();
    }

    public void clear() {
        this.tuplesCount = 0L;
        this.shrinkCapacity();
    }

    private void shrinkCapacity() {
        if (this.tuplesCount <= this.shrinkThreshold && this.array.getCapacity() > this.array.getInitialCapacity()) {
            long sizeToShrink = (long)((float)this.array.getCapacity() * this.shrinkFactor * 0.9f);
            if (sizeToShrink == 0L) {
                return;
            }
            long newCapacity = this.array.getCapacity() - sizeToShrink <= this.array.getInitialCapacity() ? this.array.getInitialCapacity() : this.array.getCapacity() - sizeToShrink;
            this.array.shrink(newCapacity);
            this.shrinkThreshold = (long)((double)this.array.getCapacity() / 3.0 * (double)this.shrinkFactor);
        }
    }

    private void siftUp(long tupleIdx) {
        long parentIdx;
        while (tupleIdx > 0L && this.compare(tupleIdx, parentIdx = (tupleIdx - 1L) / 2L) < 0) {
            this.swap(tupleIdx, parentIdx);
            tupleIdx = parentIdx;
        }
    }

    private void siftDown(long tupleIdx) {
        long half = this.tuplesCount / 2L;
        while (tupleIdx < half) {
            long left = 2L * tupleIdx + 1L;
            long right = 2L * tupleIdx + 2L;
            long swapIdx = tupleIdx;
            if (this.compare(tupleIdx, left) > 0) {
                swapIdx = left;
            }
            if (right < this.tuplesCount && this.compare(swapIdx, right) > 0) {
                swapIdx = right;
            }
            if (swapIdx == tupleIdx) {
                return;
            }
            this.swap(tupleIdx, swapIdx);
            tupleIdx = swapIdx;
        }
    }

    private void put(long tupleIdx, long n1, long n2, long n3) {
        long idx = tupleIdx * 3L;
        this.array.writeLong(idx, n1);
        this.array.writeLong(idx + 1L, n2);
        this.array.writeLong(idx + 2L, n3);
    }

    private int compare(long tupleIdx1, long tupleIdx2) {
        long idx1 = tupleIdx1 * 3L;
        long idx2 = tupleIdx2 * 3L;
        int c1 = Long.compare(this.array.readLong(idx1), this.array.readLong(idx2));
        if (c1 != 0) {
            return c1;
        }
        int c2 = Long.compare(this.array.readLong(idx1 + 1L), this.array.readLong(idx2 + 1L));
        if (c2 != 0) {
            return c2;
        }
        return Long.compare(this.array.readLong(idx1 + 2L), this.array.readLong(idx2 + 2L));
    }

    private void swap(long tupleIdx1, long tupleIdx2) {
        long idx1 = tupleIdx1 * 3L;
        long idx2 = tupleIdx2 * 3L;
        long tmp1 = this.array.readLong(idx1);
        long tmp2 = this.array.readLong(idx1 + 1L);
        long tmp3 = this.array.readLong(idx1 + 2L);
        this.array.writeLong(idx1, this.array.readLong(idx2));
        this.array.writeLong(idx1 + 1L, this.array.readLong(idx2 + 1L));
        this.array.writeLong(idx1 + 2L, this.array.readLong(idx2 + 2L));
        this.array.writeLong(idx2, tmp1);
        this.array.writeLong(idx2 + 1L, tmp2);
        this.array.writeLong(idx2 + 2L, tmp3);
    }
}

