/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.functions.runtime.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public class DefaultPulsarSslFactory
implements PulsarSslFactory {
    private PulsarSslConfiguration config;
    private final AtomicReference<SSLContext> internalSslContext = new AtomicReference();
    private final AtomicReference<SslContext> internalNettySslContext = new AtomicReference();
    protected FileModifiedTimeUpdater tlsKeyStore;
    protected FileModifiedTimeUpdater tlsTrustStore;
    protected FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected FileModifiedTimeUpdater tlsCertificateFilePath;
    protected FileModifiedTimeUpdater tlsKeyFilePath;
    protected AuthenticationDataProvider authData;
    protected boolean isTlsTrustStoreStreamProvided;
    protected final String[] defaultSslEnabledProtocols = new String[]{"TLSv1.3", "TLSv1.2"};
    protected String tlsKeystoreType;
    protected String tlsKeystorePath;
    protected String tlsKeystorePassword;

    @Override
    public void initialize(PulsarSslConfiguration config) {
        this.config = config;
        AuthenticationDataProvider authData = this.config.getAuthData();
        if (this.config.isTlsEnabledWithKeystore()) {
            KeyStoreParams authParams;
            if (authData != null && authData.hasDataForTls() && (authParams = authData.getTlsKeyStoreParams()) != null) {
                this.tlsKeystoreType = authParams.getKeyStoreType();
                this.tlsKeystorePath = authParams.getKeyStorePath();
                this.tlsKeystorePassword = authParams.getKeyStorePassword();
            }
            if (this.tlsKeystoreType == null) {
                this.tlsKeystoreType = this.config.getTlsKeyStoreType();
            }
            if (this.tlsKeystorePath == null) {
                this.tlsKeystorePath = this.config.getTlsKeyStorePath();
            }
            if (this.tlsKeystorePassword == null) {
                this.tlsKeystorePassword = this.config.getTlsKeyStorePassword();
            }
            this.tlsKeyStore = new FileModifiedTimeUpdater(this.tlsKeystorePath);
            this.tlsTrustStore = new FileModifiedTimeUpdater(this.config.getTlsTrustStorePath());
        } else if (authData != null && authData.hasDataForTls()) {
            if (authData.getTlsTrustStoreStream() != null) {
                this.isTlsTrustStoreStreamProvided = true;
            } else {
                this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(this.config.getTlsTrustCertsFilePath());
            }
            this.authData = authData;
        } else {
            this.tlsCertificateFilePath = new FileModifiedTimeUpdater(this.config.getTlsCertificateFilePath());
            this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(this.config.getTlsTrustCertsFilePath());
            this.tlsKeyFilePath = new FileModifiedTimeUpdater(this.config.getTlsKeyFilePath());
        }
    }

    @Override
    public SSLEngine createClientSslEngine(ByteBufAllocator buf, String peerHost, int peerPort) {
        return this.createSSLEngine(buf, peerHost, peerPort, NetworkMode.CLIENT);
    }

    @Override
    public SSLEngine createServerSslEngine(ByteBufAllocator buf) {
        return this.createSSLEngine(buf, "", 0, NetworkMode.SERVER);
    }

    @Override
    public boolean needsUpdate() {
        if (this.config.isTlsEnabledWithKeystore()) {
            return this.tlsKeyStore != null && this.tlsKeyStore.checkAndRefresh() || this.tlsTrustStore != null && this.tlsTrustStore.checkAndRefresh();
        }
        if (this.authData != null && this.authData.hasDataForTls()) {
            return true;
        }
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyFilePath.checkAndRefresh();
    }

    @Override
    public void createInternalSslContext() throws Exception {
        if (this.config.isTlsEnabledWithKeystore()) {
            this.internalSslContext.set(this.buildKeystoreSslContext(this.config.isServerMode()));
        } else if (this.config.isHttps()) {
            this.internalSslContext.set(this.buildSslContext());
        } else {
            this.internalNettySslContext.set(this.buildNettySslContext());
        }
    }

    @Override
    public SSLContext getInternalSslContext() {
        if (this.internalSslContext.get() == null) {
            throw new RuntimeException("Internal SSL context is not initialized. Please call createInternalSslContext() first.");
        }
        return this.internalSslContext.get();
    }

    @Override
    public SslContext getInternalNettySslContext() {
        if (this.internalNettySslContext.get() == null) {
            throw new RuntimeException("Internal SSL context is not initialized. Please call createInternalSslContext() first.");
        }
        return this.internalNettySslContext.get();
    }

    private SSLContext buildKeystoreSslContext(boolean isServerMode) throws GeneralSecurityException, IOException {
        KeyStoreSSLContext keyStoreSSLContext = isServerMode ? KeyStoreSSLContext.createServerKeyStoreSslContext(this.config.getTlsProvider(), this.tlsKeystoreType, this.tlsKeyStore.getFileName(), this.tlsKeystorePassword, this.config.isAllowInsecureConnection(), this.config.getTlsTrustStoreType(), this.tlsTrustStore.getFileName(), this.config.getTlsTrustStorePassword(), this.config.isRequireTrustedClientCertOnConnect(), this.config.getTlsCiphers(), this.config.getTlsProtocols()) : KeyStoreSSLContext.createClientKeyStoreSslContext(this.config.getTlsProvider(), this.tlsKeystoreType, this.tlsKeyStore.getFileName(), this.tlsKeystorePassword, this.config.isAllowInsecureConnection(), this.config.getTlsTrustStoreType(), this.tlsTrustStore.getFileName(), this.config.getTlsTrustStorePassword(), this.config.getTlsCiphers(), this.config.getTlsProtocols());
        return keyStoreSSLContext.createSSLContext();
    }

    private SSLContext buildSslContext() throws GeneralSecurityException {
        if (this.authData != null && this.authData.hasDataForTls()) {
            if (this.isTlsTrustStoreStreamProvided) {
                return SecurityUtility.createSslContext(this.config.isAllowInsecureConnection(), SecurityUtility.loadCertificatesFromPemStream(this.authData.getTlsTrustStoreStream()), this.authData.getTlsCertificates(), this.authData.getTlsPrivateKey(), this.config.getTlsProvider());
            }
            if (this.authData.getTlsCertificates() != null) {
                return SecurityUtility.createSslContext(this.config.isAllowInsecureConnection(), SecurityUtility.loadCertificatesFromPemFile(this.tlsTrustCertsFilePath.getFileName()), this.authData.getTlsCertificates(), this.authData.getTlsPrivateKey(), this.config.getTlsProvider());
            }
            return SecurityUtility.createSslContext(this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.authData.getTlsCertificateFilePath(), this.authData.getTlsPrivateKeyFilePath(), this.config.getTlsProvider());
        }
        return SecurityUtility.createSslContext(this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.config.getTlsProvider());
    }

    private SslContext buildNettySslContext() throws GeneralSecurityException, IOException {
        SslProvider sslProvider = null;
        if (StringUtils.isNotBlank(this.config.getTlsProvider())) {
            sslProvider = SslProvider.valueOf(this.config.getTlsProvider());
        }
        if (this.authData != null && this.authData.hasDataForTls()) {
            if (this.isTlsTrustStoreStreamProvided) {
                return SecurityUtility.createNettySslContextForClient(sslProvider, this.config.isAllowInsecureConnection(), this.authData.getTlsTrustStoreStream(), this.authData.getTlsCertificates(), this.authData.getTlsPrivateKey(), this.config.getTlsCiphers(), this.config.getTlsProtocols());
            }
            if (this.authData.getTlsCertificates() != null) {
                return SecurityUtility.createNettySslContextForClient(sslProvider, this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.authData.getTlsCertificates(), this.authData.getTlsPrivateKey(), this.config.getTlsCiphers(), this.config.getTlsProtocols());
            }
            return SecurityUtility.createNettySslContextForClient(sslProvider, this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.authData.getTlsCertificateFilePath(), this.authData.getTlsPrivateKeyFilePath(), this.config.getTlsCiphers(), this.config.getTlsProtocols());
        }
        if (this.config.isServerMode()) {
            return SecurityUtility.createNettySslContextForServer(sslProvider, this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.config.getTlsCiphers(), this.config.getTlsProtocols(), this.config.isRequireTrustedClientCertOnConnect());
        }
        return SecurityUtility.createNettySslContextForClient(sslProvider, this.config.isAllowInsecureConnection(), this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.config.getTlsCiphers(), this.config.getTlsProtocols());
    }

    private SSLEngine createSSLEngine(ByteBufAllocator buf, String peerHost, int peerPort, NetworkMode mode) {
        SSLParameters sslParams;
        SSLEngine sslEngine;
        SSLContext sslContext = this.internalSslContext.get();
        SslContext nettySslContext = this.internalNettySslContext.get();
        this.validateSslContext(sslContext, nettySslContext);
        if (mode == NetworkMode.CLIENT) {
            sslEngine = sslContext != null ? sslContext.createSSLEngine(peerHost, peerPort) : nettySslContext.newEngine(buf, peerHost, peerPort);
            sslEngine.setUseClientMode(true);
            sslParams = sslEngine.getSSLParameters();
        } else {
            sslEngine = sslContext != null ? sslContext.createSSLEngine() : nettySslContext.newEngine(buf);
            sslEngine.setUseClientMode(false);
            sslParams = sslEngine.getSSLParameters();
            if (this.config.isRequireTrustedClientCertOnConnect()) {
                sslParams.setNeedClientAuth(true);
            } else {
                sslParams.setWantClientAuth(true);
            }
        }
        if (this.config.getTlsProtocols() != null && !this.config.getTlsProtocols().isEmpty()) {
            sslParams.setProtocols(this.config.getTlsProtocols().toArray(new String[0]));
        } else {
            sslParams.setProtocols(this.defaultSslEnabledProtocols);
        }
        if (this.config.getTlsCiphers() != null && !this.config.getTlsCiphers().isEmpty()) {
            sslParams.setCipherSuites(this.config.getTlsCiphers().toArray(new String[0]));
        }
        sslEngine.setSSLParameters(sslParams);
        return sslEngine;
    }

    private void validateSslContext(SSLContext sslContext, SslContext nettySslContext) {
        if (sslContext == null && nettySslContext == null) {
            throw new RuntimeException("Internal SSL context is not initialized. Please call createInternalSslContext() first.");
        }
    }

    @Override
    public void close() throws Exception {
    }

    private static enum NetworkMode {
        CLIENT,
        SERVER;

    }
}

