/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Counter;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.Filter;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterChain;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterConfig;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletException;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletResponse;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletResponse;

public class RateLimitingFilter
implements Filter {
    private final RateLimiter limiter;
    public static final String RATE_LIMIT_REQUEST_COUNT_METRIC_NAME = "pulsar.web.filter.rate_limit.request.count";
    private final LongCounter rateLimitRequestCounter;
    public static final AttributeKey<String> RATE_LIMIT_RESULT = AttributeKey.stringKey((String)"pulsar.web.filter.rate_limit.result");
    @Deprecated
    private static final Counter httpRejectedRequests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_broker_http_rejected_requests")).help("Counter of HTTP requests rejected by rate limiting")).register();

    public RateLimitingFilter(double rateLimit, Meter meter) {
        this.limiter = RateLimiter.create(rateLimit);
        this.rateLimitRequestCounter = meter.counterBuilder(RATE_LIMIT_REQUEST_COUNT_METRIC_NAME).setDescription("Counter of HTTP requests processed by the rate limiting filter.").setUnit("{request}").build();
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.limiter.tryAcquire()) {
            this.rateLimitRequestCounter.add(1L, Result.ACCEPTED.attributes);
            chain.doFilter(request, response);
        } else {
            httpRejectedRequests.inc();
            this.rateLimitRequestCounter.add(1L, Result.REJECTED.attributes);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(429, "Too Many Requests");
        }
    }

    @Override
    public void destroy() {
    }

    public static enum Result {
        ACCEPTED,
        REJECTED;

        public final Attributes attributes = Attributes.of(RATE_LIMIT_RESULT, (Object)this.name().toLowerCase());
    }
}

