/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NukeExistingClusterCommand
extends BookieCommand<NukeExistingClusterFlags> {
    static final Logger LOG = LoggerFactory.getLogger(NukeExistingClusterCommand.class);
    private static final String NAME = "nukeexistingcluster";
    private static final String DESC = "Nuke bookkeeper cluster by deleting metadata.";

    public NukeExistingClusterCommand() {
        this(new NukeExistingClusterFlags());
    }

    private NukeExistingClusterCommand(NukeExistingClusterFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, NukeExistingClusterFlags cmdFlags) {
        if (cmdFlags.force == (cmdFlags.instandId != null)) {
            LOG.error("Either force option or instanceid should be specified (but no both)");
            return false;
        }
        try {
            return BookKeeperAdmin.nukeExistingCluster(conf, cmdFlags.zkLedgersRootPath, cmdFlags.instandId, cmdFlags.force);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    public static class NukeExistingClusterFlags
    extends CliFlags {
        @Parameter(names={"-f", "--force"}, description="If instance id is not specified, then whether to force nuke the metadata without validating instance id")
        private boolean force;
        @Parameter(names={"-p", "--zkledgersrootpath"}, description="zookeeper ledgers root path", required=true)
        private String zkLedgersRootPath;
        @Parameter(names={"-i", "--instanceid"}, description="instance id")
        private String instandId;

        public NukeExistingClusterFlags force(boolean force) {
            this.force = force;
            return this;
        }

        public NukeExistingClusterFlags zkLedgersRootPath(String zkLedgersRootPath) {
            this.zkLedgersRootPath = zkLedgersRootPath;
            return this;
        }

        public NukeExistingClusterFlags instandId(String instandId) {
            this.instandId = instandId;
            return this;
        }
    }
}

