/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.Watcher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.ACL;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerWatcher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.IWatchManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.PathParentIterator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatchStats;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatcherMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatchesPathReport;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatchesReport;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.watch.WatchesSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchManager
implements IWatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final Map<String, Set<Watcher>> watchTable = new HashMap<String, Set<Watcher>>();
    private final Map<Watcher, Map<String, WatchStats>> watch2Paths = new HashMap<Watcher, Map<String, WatchStats>>();
    private int recursiveWatchQty = 0;

    @Override
    public synchronized int size() {
        int result = 0;
        for (Set<Watcher> watches : this.watchTable.values()) {
            result += watches.size();
        }
        return result;
    }

    private boolean isDeadWatcher(Watcher watcher) {
        return watcher instanceof ServerCnxn && ((ServerCnxn)watcher).isStale();
    }

    @Override
    public boolean addWatch(String path, Watcher watcher) {
        return this.addWatch(path, watcher, WatcherMode.DEFAULT_WATCHER_MODE);
    }

    @Override
    public synchronized boolean addWatch(String path, Watcher watcher, WatcherMode watcherMode) {
        WatchStats stats;
        WatchStats newStats;
        if (this.isDeadWatcher(watcher)) {
            LOG.debug("Ignoring addWatch with closed cnxn");
            return false;
        }
        Set<Watcher> list = this.watchTable.get(path);
        if (list == null) {
            list = new HashSet<Watcher>(4);
            this.watchTable.put(path, list);
        }
        list.add(watcher);
        Map<String, WatchStats> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashMap<String, WatchStats>();
            this.watch2Paths.put(watcher, paths);
        }
        if ((newStats = (stats = paths.getOrDefault(path, WatchStats.NONE)).addMode(watcherMode)) != stats) {
            paths.put(path, newStats);
            if (watcherMode.isRecursive()) {
                ++this.recursiveWatchQty;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeWatcher(Watcher watcher) {
        Map<String, WatchStats> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p : paths.keySet()) {
            Set<Watcher> list = this.watchTable.get(p);
            if (list == null) continue;
            list.remove(watcher);
            if (!list.isEmpty()) continue;
            this.watchTable.remove(p);
        }
        for (WatchStats stats : paths.values()) {
            if (!stats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) continue;
            --this.recursiveWatchQty;
        }
    }

    @Override
    public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, long zxid, List<ACL> acl) {
        return this.triggerWatch(path, type, zxid, acl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatcherOrBitSet triggerWatch(String path, Watcher.Event.EventType type, long zxid, List<ACL> acl, WatcherOrBitSet supress) {
        WatchedEvent e = new WatchedEvent(type, Watcher.Event.KeeperState.SyncConnected, path, zxid);
        HashSet<Watcher> watchers = new HashSet<Watcher>();
        WatchManager watchManager = this;
        synchronized (watchManager) {
            PathParentIterator pathParentIterator = this.getPathParentIterator(path);
            for (String localPath : pathParentIterator.asIterable()) {
                Set<Watcher> thisWatchers = this.watchTable.get(localPath);
                if (thisWatchers == null || thisWatchers.isEmpty()) continue;
                Iterator<Watcher> iterator = thisWatchers.iterator();
                while (iterator.hasNext()) {
                    Watcher watcher = iterator.next();
                    Map<String, WatchStats> paths = this.watch2Paths.getOrDefault(watcher, Collections.emptyMap());
                    WatchStats stats = (WatchStats)paths.get(localPath);
                    if (stats == null) {
                        LOG.warn("inconsistent watch table for watcher {}, {} not in path list", (Object)watcher, (Object)localPath);
                        continue;
                    }
                    if (!pathParentIterator.atParentPath()) {
                        watchers.add(watcher);
                        WatchStats newStats = stats.removeMode(WatcherMode.STANDARD);
                        if (newStats == WatchStats.NONE) {
                            iterator.remove();
                            paths.remove(localPath);
                            continue;
                        }
                        if (newStats == stats) continue;
                        paths.put(localPath, newStats);
                        continue;
                    }
                    if (!stats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) continue;
                    watchers.add(watcher);
                }
                if (!thisWatchers.isEmpty()) continue;
                this.watchTable.remove(localPath);
            }
        }
        if (watchers.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path);
            }
            return null;
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            if (w instanceof ServerWatcher) {
                ((ServerWatcher)w).process(e, acl);
                continue;
            }
            w.process(e);
        }
        switch (type) {
            case NodeCreated: {
                ServerMetrics.getMetrics().NODE_CREATED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDeleted: {
                ServerMetrics.getMetrics().NODE_DELETED_WATCHER.add(watchers.size());
                break;
            }
            case NodeDataChanged: {
                ServerMetrics.getMetrics().NODE_CHANGED_WATCHER.add(watchers.size());
                break;
            }
            case NodeChildrenChanged: {
                ServerMetrics.getMetrics().NODE_CHILDREN_WATCHER.add(watchers.size());
                break;
            }
        }
        return new WatcherOrBitSet(watchers);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total = 0;
        for (Map<String, WatchStats> paths : this.watch2Paths.values()) {
            total += paths.size();
        }
        sb.append("Total watches:").append(total);
        return sb.toString();
    }

    @Override
    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, Set<Watcher>> e : this.watchTable.entrySet()) {
                pwriter.println(e.getKey());
                for (Watcher w : e.getValue()) {
                    pwriter.print("\t0x");
                    pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                    pwriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, Map<String, WatchStats>> e : this.watch2Paths.entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e.getKey()).getSessionId()));
                for (String path : e.getValue().keySet()) {
                    pwriter.print("\t");
                    pwriter.println(path);
                }
            }
        }
    }

    @Override
    public synchronized boolean containsWatcher(String path, Watcher watcher) {
        return this.containsWatcher(path, watcher, null);
    }

    @Override
    public synchronized boolean containsWatcher(String path, Watcher watcher, WatcherMode watcherMode) {
        Map<String, WatchStats> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            return false;
        }
        WatchStats stats = paths.get(path);
        return stats != null && (watcherMode == null || stats.hasMode(watcherMode));
    }

    private WatchStats unwatch(String path, Watcher watcher, Map<String, WatchStats> paths, Set<Watcher> watchers) {
        WatchStats stats = paths.remove(path);
        if (stats == null) {
            return WatchStats.NONE;
        }
        if (paths.isEmpty()) {
            this.watch2Paths.remove(watcher);
        }
        watchers.remove(watcher);
        if (watchers.isEmpty()) {
            this.watchTable.remove(path);
        }
        return stats;
    }

    @Override
    public synchronized boolean removeWatcher(String path, Watcher watcher, WatcherMode watcherMode) {
        WatchStats newStats;
        WatchStats oldStats;
        Map<String, WatchStats> paths = this.watch2Paths.get(watcher);
        Set<Watcher> watchers = this.watchTable.get(path);
        if (paths == null || watchers == null) {
            return false;
        }
        if (watcherMode != null) {
            oldStats = paths.getOrDefault(path, WatchStats.NONE);
            newStats = oldStats.removeMode(watcherMode);
            if (newStats != WatchStats.NONE) {
                if (newStats != oldStats) {
                    paths.put(path, newStats);
                }
            } else if (oldStats != WatchStats.NONE) {
                this.unwatch(path, watcher, paths, watchers);
            }
        } else {
            oldStats = this.unwatch(path, watcher, paths, watchers);
            newStats = WatchStats.NONE;
        }
        if (oldStats.hasMode(WatcherMode.PERSISTENT_RECURSIVE) && !newStats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)) {
            --this.recursiveWatchQty;
        }
        return oldStats != newStats;
    }

    @Override
    public synchronized boolean removeWatcher(String path, Watcher watcher) {
        return this.removeWatcher(path, watcher, null);
    }

    Map<Watcher, Map<String, WatchStats>> getWatch2Paths() {
        return this.watch2Paths;
    }

    @Override
    public synchronized WatchesReport getWatches() {
        HashMap<Long, Set<String>> id2paths = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, Map<String, WatchStats>> e : this.watch2Paths.entrySet()) {
            Long id = ((ServerCnxn)e.getKey()).getSessionId();
            HashSet<String> paths = new HashSet<String>(e.getValue().keySet());
            id2paths.put(id, paths);
        }
        return new WatchesReport(id2paths);
    }

    @Override
    public synchronized WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> path2ids = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, Set<Watcher>> e : this.watchTable.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>(e.getValue().size());
            path2ids.put(e.getKey(), ids);
            for (Watcher watcher : e.getValue()) {
                ids.add(((ServerCnxn)watcher).getSessionId());
            }
        }
        return new WatchesPathReport(path2ids);
    }

    @Override
    public synchronized WatchesSummary getWatchesSummary() {
        int totalWatches = 0;
        for (Map<String, WatchStats> paths : this.watch2Paths.values()) {
            totalWatches += paths.size();
        }
        return new WatchesSummary(this.watch2Paths.size(), this.watchTable.size(), totalWatches);
    }

    @Override
    public void shutdown() {
    }

    synchronized int getRecursiveWatchQty() {
        return this.recursiveWatchQty;
    }

    private PathParentIterator getPathParentIterator(String path) {
        if (this.getRecursiveWatchQty() == 0) {
            return PathParentIterator.forPathOnly(path);
        }
        return PathParentIterator.forAll(path);
    }
}

