/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageDataFormats;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgersIndexCheckOp {
    private static final Logger LOG = LoggerFactory.getLogger(LedgersIndexCheckOp.class);
    private final ServerConfiguration conf;
    private final boolean verbose;
    private static final String LedgersSubPath = "ledgers";

    public LedgersIndexCheckOp(ServerConfiguration conf, boolean verbose) {
        this.conf = conf;
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initiate() throws IOException {
        File[] indexDirs = this.conf.getIndexDirs();
        if (indexDirs == null) {
            indexDirs = this.conf.getLedgerDirs();
        }
        if (indexDirs.length != this.conf.getLedgerDirs().length) {
            throw new IOException("ledger and index dirs size not matched");
        }
        long startTime = System.nanoTime();
        for (int i = 0; i < this.conf.getLedgerDirs().length; ++i) {
            File indexDir = indexDirs[i];
            String iBasePath = BookieImpl.getCurrentDirectory(indexDir).toString();
            Path indexCurrentPath = FileSystems.getDefault().getPath(iBasePath, LedgersSubPath);
            LOG.info("Loading ledgers index from {}", (Object)indexCurrentPath);
            LOG.info("Starting index scan");
            try {
                KeyValueStorageRocksDB index = new KeyValueStorageRocksDB(iBasePath, LedgersSubPath, KeyValueStorageFactory.DbConfigType.Default, this.conf, true);
                int ctr = 0;
                try (KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>> iterator = index.iterator();){
                    while (iterator.hasNext()) {
                        ++ctr;
                        Map.Entry<byte[], byte[]> entry = iterator.next();
                        long ledgerId = ArrayUtil.getLong(entry.getKey(), 0);
                        DbLedgerStorageDataFormats.LedgerData ledgerData = DbLedgerStorageDataFormats.LedgerData.parseFrom(entry.getValue());
                        if (this.verbose) {
                            LOG.info("Scanned: {}, ledger: {}, exists: {}, isFenced: {}, masterKey: {}, explicitLAC: {}", new Object[]{ctr, ledgerId, ledgerData.hasExists() ? Boolean.valueOf(ledgerData.getExists()) : "-", ledgerData.hasFenced() ? Boolean.valueOf(ledgerData.getFenced()) : "-", ledgerData.hasMasterKey() ? Base64.getEncoder().encodeToString(ledgerData.getMasterKey().toByteArray()) : "-", ledgerData.hasExplicitLac() ? ledgerData.getExplicitLac() : "-"});
                            continue;
                        }
                        if (ctr % 100 != 0) continue;
                        LOG.info("Scanned {} ledgers", (Object)ctr);
                    }
                }
                LOG.info("Scanned {} ledgers", (Object)ctr);
                continue;
            }
            catch (Throwable t) {
                LOG.error("Index scan has failed with error", t);
                return false;
            }
        }
        LOG.info("Index scan has completed successfully. Total time: {}", (Object)DurationFormatUtils.formatDurationHMS(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)));
        return true;
    }
}

