/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.DataObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.json.annotations.JsonGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.OpenSSLEngineOptionsConverter;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SSLEngineOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tls.DefaultSslContextFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tls.SslContextFactory;

@DataObject
@JsonGen(publicConverter=false)
public class OpenSSLEngineOptions
extends SSLEngineOptions {
    public static final boolean DEFAULT_SESSION_CACHE_ENABLED = true;
    private boolean sessionCacheEnabled;

    public static boolean isAvailable() {
        return OpenSsl.isAvailable();
    }

    public static boolean isAlpnAvailable() {
        return OpenSsl.isAlpnSupported();
    }

    public OpenSSLEngineOptions() {
        this.sessionCacheEnabled = true;
    }

    public OpenSSLEngineOptions(JsonObject json) {
        super(json);
        OpenSSLEngineOptionsConverter.fromJson(json, this);
    }

    public OpenSSLEngineOptions(OpenSSLEngineOptions other) {
        super(other);
        this.sessionCacheEnabled = other.isSessionCacheEnabled();
    }

    public OpenSSLEngineOptions setSessionCacheEnabled(boolean sessionCacheEnabled) {
        this.sessionCacheEnabled = sessionCacheEnabled;
        return this;
    }

    public boolean isSessionCacheEnabled() {
        return this.sessionCacheEnabled;
    }

    @Override
    public OpenSSLEngineOptions setUseWorkerThread(boolean useWorkerThread) {
        return (OpenSSLEngineOptions)super.setUseWorkerThread(useWorkerThread);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OpenSSLEngineOptionsConverter.toJson(this, json);
        return json;
    }

    @Override
    public OpenSSLEngineOptions copy() {
        return new OpenSSLEngineOptions(this);
    }

    @Override
    public SslContextFactory sslContextFactory() {
        return new DefaultSslContextFactory(SslProvider.OPENSSL, this.sessionCacheEnabled);
    }
}

