/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.stats;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.CachingStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsData;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;

public class BroadCastStatsLogger {
    public static StatsLogger two(StatsLogger first, StatsLogger second) {
        return new CachingStatsLogger((StatsLogger)new Two(first, second));
    }

    public static StatsLogger masterslave(StatsLogger master, StatsLogger slave) {
        return new CachingStatsLogger((StatsLogger)new MasterSlave(master, slave));
    }

    static class MasterSlave
    extends Two {
        private MasterSlave(StatsLogger master, StatsLogger slave) {
            super(master, slave);
        }

        @Override
        public <T extends Number> void registerGauge(String statName, Gauge<T> gauge) {
            this.first.registerGauge(statName, gauge);
        }

        @Override
        public <T extends Number> void unregisterGauge(String statName, Gauge<T> gauge) {
            this.first.unregisterGauge(statName, gauge);
        }

        @Override
        public StatsLogger scope(String scope) {
            return new MasterSlave(this.first.scope(scope), this.second.scope(scope));
        }
    }

    static class Two
    implements StatsLogger {
        protected final StatsLogger first;
        protected final StatsLogger second;

        private Two(StatsLogger first, StatsLogger second) {
            Preconditions.checkNotNull(first);
            Preconditions.checkNotNull(second);
            this.first = first;
            this.second = second;
        }

        public OpStatsLogger getOpStatsLogger(String statName) {
            final OpStatsLogger firstLogger = this.first.getOpStatsLogger(statName);
            final OpStatsLogger secondLogger = this.second.getOpStatsLogger(statName);
            return new OpStatsLogger(){

                public void registerFailedEvent(long l, TimeUnit timeUnit) {
                    firstLogger.registerFailedEvent(l, timeUnit);
                    secondLogger.registerFailedEvent(l, timeUnit);
                }

                public void registerSuccessfulEvent(long l, TimeUnit timeUnit) {
                    firstLogger.registerSuccessfulEvent(l, timeUnit);
                    secondLogger.registerSuccessfulEvent(l, timeUnit);
                }

                public void registerSuccessfulValue(long l) {
                    firstLogger.registerSuccessfulValue(l);
                    secondLogger.registerSuccessfulValue(l);
                }

                public void registerFailedValue(long l) {
                    firstLogger.registerFailedValue(l);
                    secondLogger.registerFailedValue(l);
                }

                public OpStatsData toOpStatsData() {
                    return firstLogger.toOpStatsData();
                }

                public void clear() {
                    firstLogger.clear();
                    secondLogger.clear();
                }
            };
        }

        public Counter getCounter(String statName) {
            final Counter firstCounter = this.first.getCounter(statName);
            final Counter secondCounter = this.second.getCounter(statName);
            return new Counter(){

                public void clear() {
                    firstCounter.clear();
                    secondCounter.clear();
                }

                public void inc() {
                    firstCounter.inc();
                    secondCounter.inc();
                }

                public void dec() {
                    firstCounter.dec();
                    secondCounter.dec();
                }

                public void addCount(long l) {
                    firstCounter.addCount(l);
                    secondCounter.addCount(l);
                }

                public void addLatency(long eventLatency, TimeUnit unit) {
                    long valueMillis = unit.toMillis(eventLatency);
                    firstCounter.addCount(valueMillis);
                    secondCounter.addCount(valueMillis);
                }

                public Long get() {
                    return firstCounter.get();
                }
            };
        }

        public <T extends Number> void registerGauge(String statName, Gauge<T> gauge) {
            throw new RuntimeException("Cannot register a gauge on BroadCastStatsLogger.Two");
        }

        public <T extends Number> void unregisterGauge(String statName, Gauge<T> gauge) {
        }

        public StatsLogger scope(String scope) {
            return new Two(this.first.scope(scope), this.second.scope(scope));
        }

        public void removeScope(String scope, StatsLogger statsLogger) {
            if (!(statsLogger instanceof Two)) {
                return;
            }
            Two another = (Two)statsLogger;
            this.first.removeScope(scope, another.first);
            this.second.removeScope(scope, another.second);
        }

        public OpStatsLogger getThreadScopedOpStatsLogger(String name) {
            return this.getOpStatsLogger(name);
        }

        public Counter getThreadScopedCounter(String name) {
            return this.getCounter(name);
        }
    }
}

