/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGeneratorUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.AsyncContext;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.AsyncEvent;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.AsyncListener;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletException;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServlet;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsServlet
extends HttpServlet {
    public static final String DEFAULT_METRICS_PATH = "/metrics";
    public static final String PROMETHEUS_CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";
    private static final long serialVersionUID = 1L;
    static final int HTTP_STATUS_OK_200 = 200;
    static final int HTTP_STATUS_INTERNAL_SERVER_ERROR_500 = 500;
    protected final long metricsServletTimeoutMs;
    protected final String cluster;
    protected List<PrometheusRawMetricsProvider> metricsProviders;
    protected ExecutorService executor = null;
    protected final int executorMaxThreads;
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsServlet.class);

    public PrometheusMetricsServlet(long metricsServletTimeoutMs, String cluster) {
        this(metricsServletTimeoutMs, cluster, 1);
    }

    public PrometheusMetricsServlet(long metricsServletTimeoutMs, String cluster, int executorMaxThreads) {
        this.metricsServletTimeoutMs = metricsServletTimeoutMs;
        this.cluster = cluster;
        this.executorMaxThreads = executorMaxThreads;
    }

    @Override
    public void init() throws ServletException {
        if (this.executorMaxThreads > 0) {
            this.executor = Executors.newScheduledThreadPool(this.executorMaxThreads, new DefaultThreadFactory("prometheus-stats"));
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        final AsyncContext context = request.startAsync();
        if (this.metricsServletTimeoutMs > 0L) {
            context.setTimeout(this.metricsServletTimeoutMs * 2L);
        }
        long startNanos = System.nanoTime();
        final AtomicBoolean taskStarted = new AtomicBoolean(false);
        final Future<?> future = this.executor.submit(() -> {
            taskStarted.set(true);
            long elapsedNanos = System.nanoTime() - startNanos;
            if (this.metricsServletTimeoutMs > 0L && elapsedNanos > TimeUnit.MILLISECONDS.toNanos(this.metricsServletTimeoutMs)) {
                log.warn("Prometheus metrics request was too long in queue ({}ms). Skipping sending metrics.", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
                if (!response.isCommitted()) {
                    response.setStatus(500);
                }
                context.complete();
                return;
            }
            this.handleAsyncMetricsRequest(context);
        });
        context.addListener(new AsyncListener(){

            @Override
            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                if (!taskStarted.get()) {
                    future.cancel(false);
                }
            }

            @Override
            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                if (!taskStarted.get()) {
                    future.cancel(false);
                }
                log.warn("Prometheus metrics request timed out");
                HttpServletResponse res = (HttpServletResponse)context.getResponse();
                if (!res.isCommitted()) {
                    res.setStatus(500);
                }
                context.complete();
            }

            @Override
            public void onError(AsyncEvent asyncEvent) throws IOException {
                if (!taskStarted.get()) {
                    future.cancel(false);
                }
            }

            @Override
            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncMetricsRequest(AsyncContext context) {
        long start = System.currentTimeMillis();
        HttpServletResponse res = (HttpServletResponse)context.getResponse();
        try {
            this.generateMetricsSynchronously(res);
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            long time = end - start;
            if (e instanceof EOFException) {
                log.error("Failed to send metrics, likely the client or this server closed the connection due to a timeout ({} ms elapsed): {}", (Object)time, (Object)String.valueOf(e));
            } else {
                log.error("Failed to generate prometheus stats, {} ms elapsed", (Object)time, (Object)e);
            }
            if (!res.isCommitted()) {
                res.setStatus(500);
            }
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - start;
            try {
                context.complete();
            }
            catch (IllegalStateException e) {
                log.error("Failed to generate prometheus stats, this is likely due to metricsServletTimeoutMs: {} ms elapsed: {}", (Object)time, (Object)String.valueOf(e));
            }
        }
    }

    private void generateMetricsSynchronously(HttpServletResponse res) throws IOException {
        res.setStatus(200);
        res.setContentType(PROMETHEUS_CONTENT_TYPE_004);
        PrometheusMetricsGeneratorUtils.generate(this.cluster, res.getOutputStream(), this.metricsProviders);
    }

    @Override
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void addRawMetricsProvider(PrometheusRawMetricsProvider metricsProvider) {
        if (this.metricsProviders == null) {
            this.metricsProviders = new LinkedList<PrometheusRawMetricsProvider>();
        }
        this.metricsProviders.add(metricsProvider);
    }
}

