/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.io.IOException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb.LocationsIndexRebuildOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildDBLedgerLocationsIndexCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(RebuildDBLedgerLocationsIndexCommand.class);
    private static final String NAME = "rebuild-db-ledger-locations-index";
    private static final String DESC = "Rbuild DBLedgerStorage locations index by scanning the entry logs";

    public RebuildDBLedgerLocationsIndexCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        LOG.info("=== Rebuilding DBStorage locations index ===");
        ServerConfiguration serverConfiguration = new ServerConfiguration(conf);
        try {
            new LocationsIndexRebuildOp(serverConfiguration).initiate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOG.info("-- Done rebuilding DBStorage locations index --");
        return true;
    }
}

