/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieNode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.Node;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;

public class RackawareEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicyImpl
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    RackawareEnsemblePlacementPolicyImpl slave = null;

    public RackawareEnsemblePlacementPolicy() {
    }

    public RackawareEnsemblePlacementPolicy(boolean enforceDurability) {
        super(enforceDurability);
    }

    @Override
    protected RackawareEnsemblePlacementPolicy initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, int reorderThresholdPendingRequests, boolean isWeighted, int maxWeightMultiple, int minNumRacksPerWriteQuorum, boolean enforceMinNumRacksPerWriteQuorum, boolean ignoreLocalNodeInPlacementPolicy, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        if (stabilizePeriodSeconds > 0) {
            super.initialize(dnsResolver, timer, reorderReadsRandom, 0, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger, bookieAddressResolver);
            this.slave = new RackawareEnsemblePlacementPolicyImpl(this.enforceDurability);
            this.slave.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger, bookieAddressResolver);
        } else {
            super.initialize(dnsResolver, timer, reorderReadsRandom, stabilizePeriodSeconds, reorderThresholdPendingRequests, isWeighted, maxWeightMultiple, minNumRacksPerWriteQuorum, enforceMinNumRacksPerWriteQuorum, ignoreLocalNodeInPlacementPolicy, statsLogger, bookieAddressResolver);
            this.slave = null;
        }
        return this;
    }

    @Override
    public void uninitalize() {
        super.uninitalize();
        if (null != this.slave) {
            this.slave.uninitalize();
        }
    }

    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        Set deadBookies = super.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        if (null != this.slave) {
            deadBookies = this.slave.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        }
        return deadBookies;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return super.reorderReadLACSequence((List)ensemble, bookiesHealthInfo, writeSet);
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieId> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation(networkLoc, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation((Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation((Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.selectFromNetworkLocation(networkLoc, (Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.selectFromNetworkLocation(networkLoc, (Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> replaceToAdherePlacementPolicy(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieId> excludeBookies, List<BookieId> currentEnsemble) {
        EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = super.replaceToAdherePlacementPolicy(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, currentEnsemble);
        if (placementResult.getAdheringToPolicy() != EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL) {
            return placementResult;
        }
        if (this.slave == null) {
            return placementResult;
        }
        return this.slave.replaceToAdherePlacementPolicy(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, currentEnsemble);
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieId> leftBookies) {
        super.handleBookiesThatLeft((Set)leftBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatLeft((Set)leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieId> joinedBookies) {
        super.handleBookiesThatJoined((Set)joinedBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatJoined((Set)joinedBookies);
        }
    }
}

