/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.utils;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.functions.api.SerDe;

public class DefaultSerDe
implements SerDe<Object> {
    private static final Set<Class> supportedInputTypes = new HashSet<Class>(Arrays.asList(byte[].class, Integer.class, Double.class, Long.class, Boolean.class, String.class, Short.class, Byte.class, Float.class));
    private final Class type;

    public DefaultSerDe(Class type) {
        this.type = type;
    }

    @Override
    public Object deserialize(byte[] input) {
        String data = new String(input, StandardCharsets.UTF_8);
        if (this.type.equals(byte[].class)) {
            return input;
        }
        if (this.type.equals(Integer.class)) {
            return Integer.valueOf(data);
        }
        if (this.type.equals(Double.class)) {
            return Double.valueOf(data);
        }
        if (this.type.equals(Long.class)) {
            return Long.valueOf(data);
        }
        if (this.type.equals(Boolean.class)) {
            return Boolean.valueOf(data);
        }
        if (this.type.equals(String.class)) {
            return data;
        }
        if (this.type.equals(Short.class)) {
            return Short.valueOf(data);
        }
        if (this.type.equals(Byte.class)) {
            return Byte.decode(data);
        }
        if (this.type.equals(Float.class)) {
            return Float.valueOf(data);
        }
        throw new RuntimeException("Unknown type " + this.type);
    }

    @Override
    public byte[] serialize(Object input) {
        if (this.type.equals(byte[].class)) {
            return (byte[])input;
        }
        if (this.type.equals(Integer.class)) {
            return ((Integer)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Double.class)) {
            return ((Double)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Long.class)) {
            return ((Long)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Boolean.class)) {
            return ((Boolean)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(String.class)) {
            return ((String)input).getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Short.class)) {
            return ((Short)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Byte.class)) {
            return ((Byte)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (this.type.equals(Float.class)) {
            return ((Float)input).toString().getBytes(StandardCharsets.UTF_8);
        }
        throw new RuntimeException("Unknown type " + this.type);
    }

    public static boolean IsSupportedType(Class typ) {
        return supportedInputTypes.contains(typ);
    }
}

