/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.FieldParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffloadPoliciesImpl
implements Serializable,
OffloadPolicies {
    @Generated
    private static final Logger log;
    private static final long serialVersionUID = 0L;
    public static final List<Field> CONFIGURATION_FIELDS;
    public static final ImmutableList<String> INTERNAL_SUPPORTED_DRIVER;
    public static final ImmutableList<String> DRIVER_NAMES;
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 0x4000000;
    public static final int DEFAULT_GCS_MAX_BLOCK_SIZE_IN_BYTES = 0x8000000;
    public static final int DEFAULT_READ_BUFFER_SIZE_IN_BYTES = 0x100000;
    public static final int DEFAULT_OFFLOAD_MAX_THREADS = 2;
    public static final int DEFAULT_OFFLOAD_READ_THREADS = 2;
    public static final int DEFAULT_OFFLOAD_MAX_PREFETCH_ROUNDS = 1;
    public static final String DEFAULT_OFFLOADER_DIRECTORY = "./offloaders";
    public static final Long DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
    public static final Long DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS;
    public static final Long DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
    public static final String EXTRA_CONFIG_PREFIX = "managedLedgerOffloadExtraConfig";
    public static final String OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE = "managedLedgerOffloadAutoTriggerSizeThresholdBytes";
    public static final String DELETION_LAG_NAME_IN_CONF_FILE = "managedLedgerOffloadDeletionLagMs";
    public static final String DATA_READ_PRIORITY_NAME_IN_CONF_FILE = "managedLedgerDataReadPriority";
    public static final OffloadedReadPriority DEFAULT_OFFLOADED_READ_PRIORITY;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String offloadersDirectory = "./offloaders";
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadDriver = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadMaxThreads = 2;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadReadThreads = 2;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadPrefetchRounds = 1;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Long managedLedgerOffloadThresholdInSeconds = DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Long managedLedgerOffloadThresholdInBytes = DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Long managedLedgerOffloadDeletionLagInMillis = DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private OffloadedReadPriority managedLedgerOffloadedReadPriority = DEFAULT_OFFLOADED_READ_PRIORITY;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Map<String, String> managedLedgerExtraConfigurations = new HashMap<String, String>();
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRegion = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadBucket = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadServiceEndpoint = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer s3ManagedLedgerOffloadMaxBlockSizeInBytes = 0x4000000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer s3ManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadCredentialId = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadCredentialSecret = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRole = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String s3ManagedLedgerOffloadRoleSessionName = "pulsar-s3-offload";
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadRegion = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadBucket = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer gcsManagedLedgerOffloadMaxBlockSizeInBytes = 0x8000000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer gcsManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String gcsManagedLedgerOffloadServiceAccountKeyFile = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String fileSystemProfilePath = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String fileSystemURI = null;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadBucket;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadRegion;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private String managedLedgerOffloadServiceEndpoint;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadMaxBlockSizeInBytes;
    @Configuration
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    private Integer managedLedgerOffloadReadBufferSizeInBytes;

    public static OffloadPoliciesImpl create(String driver, String region, String bucket, String endpoint, String role, String roleSessionName, String credentialId, String credentialSecret, Integer maxBlockSizeInBytes, Integer readBufferSizeInBytes, Long offloadThresholdInBytes, Long offloadThresholdInSeconds, Long offloadDeletionLagInMillis, OffloadedReadPriority readPriority) {
        OffloadPoliciesImplBuilder builder = OffloadPoliciesImpl.builder().managedLedgerOffloadDriver(driver).managedLedgerOffloadThresholdInBytes(offloadThresholdInBytes).managedLedgerOffloadThresholdInSeconds(offloadThresholdInSeconds).managedLedgerOffloadDeletionLagInMillis(offloadDeletionLagInMillis).managedLedgerOffloadBucket(bucket).managedLedgerOffloadRegion(region).managedLedgerOffloadServiceEndpoint(endpoint).managedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes).managedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes).managedLedgerOffloadedReadPriority(readPriority);
        if (driver.equalsIgnoreCase((String)DRIVER_NAMES.get(0)) || driver.equalsIgnoreCase((String)DRIVER_NAMES.get(1))) {
            if (role != null) {
                builder.s3ManagedLedgerOffloadRole(role);
            }
            if (roleSessionName != null) {
                builder.s3ManagedLedgerOffloadRoleSessionName(roleSessionName);
            }
            if (credentialId != null) {
                builder.s3ManagedLedgerOffloadCredentialId(credentialId);
            }
            if (credentialSecret != null) {
                builder.s3ManagedLedgerOffloadCredentialSecret(credentialSecret);
            }
            builder.s3ManagedLedgerOffloadRegion(region).s3ManagedLedgerOffloadBucket(bucket).s3ManagedLedgerOffloadServiceEndpoint(endpoint).s3ManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes).s3ManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        } else if (driver.equalsIgnoreCase((String)DRIVER_NAMES.get(2))) {
            builder.gcsManagedLedgerOffloadRegion(region).gcsManagedLedgerOffloadBucket(bucket).gcsManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes).gcsManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        }
        return builder.build();
    }

    public static OffloadPoliciesImpl create(Properties properties) {
        OffloadPoliciesImpl data = new OffloadPoliciesImpl();
        for (Field f : CONFIGURATION_FIELDS) {
            if (!properties.containsKey(f.getName())) continue;
            try {
                f.setAccessible(true);
                f.set(data, FieldParser.value((String)properties.get(f.getName()), f));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
            }
        }
        Map<String, String> extraConfigurations = properties.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(EXTRA_CONFIG_PREFIX)).collect(Collectors.toMap(entry -> entry.getKey().toString().replaceFirst(EXTRA_CONFIG_PREFIX, ""), entry -> entry.getValue().toString()));
        data.getManagedLedgerExtraConfigurations().putAll(extraConfigurations);
        data.compatibleWithBrokerConfigFile(properties);
        return data;
    }

    public static OffloadPoliciesImplBuilder builder() {
        return new OffloadPoliciesImplBuilder();
    }

    public void compatibleWithBrokerConfigFile(Properties properties) {
        if (!properties.containsKey("managedLedgerOffloadThresholdInBytes") && properties.containsKey(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)) {
            this.setManagedLedgerOffloadThresholdInBytes(Long.parseLong(properties.getProperty(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)));
        }
        if (!properties.containsKey("managedLedgerOffloadDeletionLagInMillis") && properties.containsKey(DELETION_LAG_NAME_IN_CONF_FILE)) {
            this.setManagedLedgerOffloadDeletionLagInMillis(Long.parseLong(properties.getProperty(DELETION_LAG_NAME_IN_CONF_FILE)));
        }
        if (!properties.containsKey("managedLedgerOffloadedReadPriority") && properties.containsKey(DATA_READ_PRIORITY_NAME_IN_CONF_FILE)) {
            this.setManagedLedgerOffloadedReadPriority(OffloadedReadPriority.fromString((String)properties.getProperty(DATA_READ_PRIORITY_NAME_IN_CONF_FILE)));
        }
    }

    public boolean driverSupported() {
        return DRIVER_NAMES.stream().anyMatch(d -> d.equalsIgnoreCase(this.managedLedgerOffloadDriver));
    }

    public static String getSupportedDriverNames() {
        return StringUtils.join(DRIVER_NAMES, (String)",");
    }

    public boolean isS3Driver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(0)) || this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(1));
    }

    public boolean isGcsDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(2));
    }

    public boolean isFileSystemDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase((String)DRIVER_NAMES.get(3));
    }

    public boolean bucketValid() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.managedLedgerOffloadBucket)) {
            return true;
        }
        if (this.isS3Driver()) {
            return StringUtils.isNotEmpty((CharSequence)this.s3ManagedLedgerOffloadBucket);
        }
        if (this.isGcsDriver()) {
            return StringUtils.isNotEmpty((CharSequence)this.gcsManagedLedgerOffloadBucket);
        }
        return this.isFileSystemDriver();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Field f : CONFIGURATION_FIELDS) {
            try {
                f.setAccessible(true);
                if ("managedLedgerExtraConfigurations".equals(f.getName())) {
                    Map extraConfig = (Map)f.get(this);
                    extraConfig.forEach((key, value) -> OffloadPoliciesImpl.setProperty(properties, EXTRA_CONFIG_PREFIX + key, value));
                    continue;
                }
                OffloadPoliciesImpl.setProperty(properties, f.getName(), f.get(this));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("An error occurred while processing the field: " + f.getName(), e);
            }
        }
        return properties;
    }

    private static void setProperty(Properties properties, String key, Object value) {
        if (value != null) {
            properties.setProperty(key, "" + value);
        }
    }

    public static OffloadPoliciesImpl oldPoliciesCompatible(OffloadPoliciesImpl nsLevelPolicies, Policies policies) {
        if (policies == null || policies.offload_threshold == -1L && policies.offload_threshold_in_seconds == -1L && policies.offload_deletion_lag_ms == null) {
            return nsLevelPolicies;
        }
        if (nsLevelPolicies == null) {
            nsLevelPolicies = new OffloadPoliciesImpl();
        }
        if (nsLevelPolicies.getManagedLedgerOffloadThresholdInBytes() == null && policies.offload_threshold != -1L) {
            nsLevelPolicies.setManagedLedgerOffloadThresholdInBytes(policies.offload_threshold);
        }
        if (nsLevelPolicies.getManagedLedgerOffloadThresholdInSeconds() == null && policies.offload_threshold_in_seconds != -1L) {
            nsLevelPolicies.setManagedLedgerOffloadThresholdInSeconds(policies.offload_threshold_in_seconds);
        }
        if (nsLevelPolicies.getManagedLedgerOffloadDeletionLagInMillis() == null && policies.offload_deletion_lag_ms != null) {
            nsLevelPolicies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
        }
        return nsLevelPolicies;
    }

    public static OffloadPoliciesImpl mergeConfiguration(OffloadPoliciesImpl topicLevelPolicies, OffloadPoliciesImpl nsLevelPolicies, Properties brokerProperties) {
        try {
            boolean allConfigValuesAreNull = true;
            OffloadPoliciesImpl offloadPolicies = new OffloadPoliciesImpl();
            for (Field field : CONFIGURATION_FIELDS) {
                Object object = topicLevelPolicies != null && field.get(topicLevelPolicies) != null ? field.get(topicLevelPolicies) : (nsLevelPolicies != null && field.get(nsLevelPolicies) != null ? field.get(nsLevelPolicies) : OffloadPoliciesImpl.getCompatibleValue(brokerProperties, field));
                if (object == null) continue;
                field.set(offloadPolicies, object);
                if (!allConfigValuesAreNull) continue;
                allConfigValuesAreNull = false;
            }
            if (allConfigValuesAreNull) {
                return null;
            }
            return offloadPolicies;
        }
        catch (Exception e) {
            log.error("Failed to merge configuration.", (Throwable)e);
            return null;
        }
    }

    private static Object getCompatibleValue(Properties properties, Field field) {
        Object object = field.getName().equals("managedLedgerOffloadThresholdInBytes") ? properties.getProperty("managedLedgerOffloadThresholdInBytes", properties.getProperty(OFFLOAD_THRESHOLD_NAME_IN_CONF_FILE)) : (field.getName().equals("managedLedgerOffloadDeletionLagInMillis") ? properties.getProperty("managedLedgerOffloadDeletionLagInMillis", properties.getProperty(DELETION_LAG_NAME_IN_CONF_FILE)) : (field.getName().equals("managedLedgerOffloadedReadPriority") ? properties.getProperty("managedLedgerOffloadedReadPriority", properties.getProperty(DATA_READ_PRIORITY_NAME_IN_CONF_FILE)) : properties.get(field.getName())));
        return FieldParser.value((String)object, field);
    }

    @Generated
    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    @Generated
    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    @Generated
    public Integer getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    @Generated
    public Integer getManagedLedgerOffloadReadThreads() {
        return this.managedLedgerOffloadReadThreads;
    }

    @Generated
    public Integer getManagedLedgerOffloadPrefetchRounds() {
        return this.managedLedgerOffloadPrefetchRounds;
    }

    @Generated
    public Long getManagedLedgerOffloadThresholdInSeconds() {
        return this.managedLedgerOffloadThresholdInSeconds;
    }

    @Generated
    public Long getManagedLedgerOffloadThresholdInBytes() {
        return this.managedLedgerOffloadThresholdInBytes;
    }

    @Generated
    public Long getManagedLedgerOffloadDeletionLagInMillis() {
        return this.managedLedgerOffloadDeletionLagInMillis;
    }

    @Generated
    public OffloadedReadPriority getManagedLedgerOffloadedReadPriority() {
        return this.managedLedgerOffloadedReadPriority;
    }

    @Generated
    public Map<String, String> getManagedLedgerExtraConfigurations() {
        return this.managedLedgerExtraConfigurations;
    }

    @Generated
    public String getS3ManagedLedgerOffloadRegion() {
        return this.s3ManagedLedgerOffloadRegion;
    }

    @Generated
    public String getS3ManagedLedgerOffloadBucket() {
        return this.s3ManagedLedgerOffloadBucket;
    }

    @Generated
    public String getS3ManagedLedgerOffloadServiceEndpoint() {
        return this.s3ManagedLedgerOffloadServiceEndpoint;
    }

    @Generated
    public Integer getS3ManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @Generated
    public Integer getS3ManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @Generated
    public String getS3ManagedLedgerOffloadCredentialId() {
        return this.s3ManagedLedgerOffloadCredentialId;
    }

    @Generated
    public String getS3ManagedLedgerOffloadCredentialSecret() {
        return this.s3ManagedLedgerOffloadCredentialSecret;
    }

    @Generated
    public String getS3ManagedLedgerOffloadRole() {
        return this.s3ManagedLedgerOffloadRole;
    }

    @Generated
    public String getS3ManagedLedgerOffloadRoleSessionName() {
        return this.s3ManagedLedgerOffloadRoleSessionName;
    }

    @Generated
    public String getGcsManagedLedgerOffloadRegion() {
        return this.gcsManagedLedgerOffloadRegion;
    }

    @Generated
    public String getGcsManagedLedgerOffloadBucket() {
        return this.gcsManagedLedgerOffloadBucket;
    }

    @Generated
    public Integer getGcsManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @Generated
    public Integer getGcsManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @Generated
    public String getGcsManagedLedgerOffloadServiceAccountKeyFile() {
        return this.gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    @Generated
    public String getFileSystemProfilePath() {
        return this.fileSystemProfilePath;
    }

    @Generated
    public String getFileSystemURI() {
        return this.fileSystemURI;
    }

    @Generated
    public String getManagedLedgerOffloadBucket() {
        return this.managedLedgerOffloadBucket;
    }

    @Generated
    public String getManagedLedgerOffloadRegion() {
        return this.managedLedgerOffloadRegion;
    }

    @Generated
    public String getManagedLedgerOffloadServiceEndpoint() {
        return this.managedLedgerOffloadServiceEndpoint;
    }

    @Generated
    public Integer getManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.managedLedgerOffloadMaxBlockSizeInBytes;
    }

    @Generated
    public Integer getManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.managedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setOffloadersDirectory(String offloadersDirectory) {
        this.offloadersDirectory = offloadersDirectory;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadMaxThreads(Integer managedLedgerOffloadMaxThreads) {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadReadThreads(Integer managedLedgerOffloadReadThreads) {
        this.managedLedgerOffloadReadThreads = managedLedgerOffloadReadThreads;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadPrefetchRounds(Integer managedLedgerOffloadPrefetchRounds) {
        this.managedLedgerOffloadPrefetchRounds = managedLedgerOffloadPrefetchRounds;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadThresholdInSeconds(Long managedLedgerOffloadThresholdInSeconds) {
        this.managedLedgerOffloadThresholdInSeconds = managedLedgerOffloadThresholdInSeconds;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadThresholdInBytes(Long managedLedgerOffloadThresholdInBytes) {
        this.managedLedgerOffloadThresholdInBytes = managedLedgerOffloadThresholdInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadDeletionLagInMillis(Long managedLedgerOffloadDeletionLagInMillis) {
        this.managedLedgerOffloadDeletionLagInMillis = managedLedgerOffloadDeletionLagInMillis;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadedReadPriority(OffloadedReadPriority managedLedgerOffloadedReadPriority) {
        this.managedLedgerOffloadedReadPriority = managedLedgerOffloadedReadPriority;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerExtraConfigurations(Map<String, String> managedLedgerExtraConfigurations) {
        this.managedLedgerExtraConfigurations = managedLedgerExtraConfigurations;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadRegion(String s3ManagedLedgerOffloadRegion) {
        this.s3ManagedLedgerOffloadRegion = s3ManagedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadBucket(String s3ManagedLedgerOffloadBucket) {
        this.s3ManagedLedgerOffloadBucket = s3ManagedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadServiceEndpoint(String s3ManagedLedgerOffloadServiceEndpoint) {
        this.s3ManagedLedgerOffloadServiceEndpoint = s3ManagedLedgerOffloadServiceEndpoint;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadMaxBlockSizeInBytes(Integer s3ManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.s3ManagedLedgerOffloadMaxBlockSizeInBytes = s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadReadBufferSizeInBytes(Integer s3ManagedLedgerOffloadReadBufferSizeInBytes) {
        this.s3ManagedLedgerOffloadReadBufferSizeInBytes = s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadCredentialId(String s3ManagedLedgerOffloadCredentialId) {
        this.s3ManagedLedgerOffloadCredentialId = s3ManagedLedgerOffloadCredentialId;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadCredentialSecret(String s3ManagedLedgerOffloadCredentialSecret) {
        this.s3ManagedLedgerOffloadCredentialSecret = s3ManagedLedgerOffloadCredentialSecret;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadRole(String s3ManagedLedgerOffloadRole) {
        this.s3ManagedLedgerOffloadRole = s3ManagedLedgerOffloadRole;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setS3ManagedLedgerOffloadRoleSessionName(String s3ManagedLedgerOffloadRoleSessionName) {
        this.s3ManagedLedgerOffloadRoleSessionName = s3ManagedLedgerOffloadRoleSessionName;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setGcsManagedLedgerOffloadRegion(String gcsManagedLedgerOffloadRegion) {
        this.gcsManagedLedgerOffloadRegion = gcsManagedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setGcsManagedLedgerOffloadBucket(String gcsManagedLedgerOffloadBucket) {
        this.gcsManagedLedgerOffloadBucket = gcsManagedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setGcsManagedLedgerOffloadMaxBlockSizeInBytes(Integer gcsManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.gcsManagedLedgerOffloadMaxBlockSizeInBytes = gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setGcsManagedLedgerOffloadReadBufferSizeInBytes(Integer gcsManagedLedgerOffloadReadBufferSizeInBytes) {
        this.gcsManagedLedgerOffloadReadBufferSizeInBytes = gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setGcsManagedLedgerOffloadServiceAccountKeyFile(String gcsManagedLedgerOffloadServiceAccountKeyFile) {
        this.gcsManagedLedgerOffloadServiceAccountKeyFile = gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setFileSystemProfilePath(String fileSystemProfilePath) {
        this.fileSystemProfilePath = fileSystemProfilePath;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setFileSystemURI(String fileSystemURI) {
        this.fileSystemURI = fileSystemURI;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadBucket(String managedLedgerOffloadBucket) {
        this.managedLedgerOffloadBucket = managedLedgerOffloadBucket;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadRegion(String managedLedgerOffloadRegion) {
        this.managedLedgerOffloadRegion = managedLedgerOffloadRegion;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadServiceEndpoint(String managedLedgerOffloadServiceEndpoint) {
        this.managedLedgerOffloadServiceEndpoint = managedLedgerOffloadServiceEndpoint;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadMaxBlockSizeInBytes(Integer managedLedgerOffloadMaxBlockSizeInBytes) {
        this.managedLedgerOffloadMaxBlockSizeInBytes = managedLedgerOffloadMaxBlockSizeInBytes;
    }

    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @Generated
    public void setManagedLedgerOffloadReadBufferSizeInBytes(Integer managedLedgerOffloadReadBufferSizeInBytes) {
        this.managedLedgerOffloadReadBufferSizeInBytes = managedLedgerOffloadReadBufferSizeInBytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OffloadPoliciesImpl)) {
            return false;
        }
        OffloadPoliciesImpl other = (OffloadPoliciesImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$managedLedgerOffloadMaxThreads = this.getManagedLedgerOffloadMaxThreads();
        Integer other$managedLedgerOffloadMaxThreads = other.getManagedLedgerOffloadMaxThreads();
        if (this$managedLedgerOffloadMaxThreads == null ? other$managedLedgerOffloadMaxThreads != null : !((Object)this$managedLedgerOffloadMaxThreads).equals(other$managedLedgerOffloadMaxThreads)) {
            return false;
        }
        Integer this$managedLedgerOffloadReadThreads = this.getManagedLedgerOffloadReadThreads();
        Integer other$managedLedgerOffloadReadThreads = other.getManagedLedgerOffloadReadThreads();
        if (this$managedLedgerOffloadReadThreads == null ? other$managedLedgerOffloadReadThreads != null : !((Object)this$managedLedgerOffloadReadThreads).equals(other$managedLedgerOffloadReadThreads)) {
            return false;
        }
        Integer this$managedLedgerOffloadPrefetchRounds = this.getManagedLedgerOffloadPrefetchRounds();
        Integer other$managedLedgerOffloadPrefetchRounds = other.getManagedLedgerOffloadPrefetchRounds();
        if (this$managedLedgerOffloadPrefetchRounds == null ? other$managedLedgerOffloadPrefetchRounds != null : !((Object)this$managedLedgerOffloadPrefetchRounds).equals(other$managedLedgerOffloadPrefetchRounds)) {
            return false;
        }
        Long this$managedLedgerOffloadThresholdInSeconds = this.getManagedLedgerOffloadThresholdInSeconds();
        Long other$managedLedgerOffloadThresholdInSeconds = other.getManagedLedgerOffloadThresholdInSeconds();
        if (this$managedLedgerOffloadThresholdInSeconds == null ? other$managedLedgerOffloadThresholdInSeconds != null : !((Object)this$managedLedgerOffloadThresholdInSeconds).equals(other$managedLedgerOffloadThresholdInSeconds)) {
            return false;
        }
        Long this$managedLedgerOffloadThresholdInBytes = this.getManagedLedgerOffloadThresholdInBytes();
        Long other$managedLedgerOffloadThresholdInBytes = other.getManagedLedgerOffloadThresholdInBytes();
        if (this$managedLedgerOffloadThresholdInBytes == null ? other$managedLedgerOffloadThresholdInBytes != null : !((Object)this$managedLedgerOffloadThresholdInBytes).equals(other$managedLedgerOffloadThresholdInBytes)) {
            return false;
        }
        Long this$managedLedgerOffloadDeletionLagInMillis = this.getManagedLedgerOffloadDeletionLagInMillis();
        Long other$managedLedgerOffloadDeletionLagInMillis = other.getManagedLedgerOffloadDeletionLagInMillis();
        if (this$managedLedgerOffloadDeletionLagInMillis == null ? other$managedLedgerOffloadDeletionLagInMillis != null : !((Object)this$managedLedgerOffloadDeletionLagInMillis).equals(other$managedLedgerOffloadDeletionLagInMillis)) {
            return false;
        }
        Integer this$s3ManagedLedgerOffloadMaxBlockSizeInBytes = this.getS3ManagedLedgerOffloadMaxBlockSizeInBytes();
        Integer other$s3ManagedLedgerOffloadMaxBlockSizeInBytes = other.getS3ManagedLedgerOffloadMaxBlockSizeInBytes();
        if (this$s3ManagedLedgerOffloadMaxBlockSizeInBytes == null ? other$s3ManagedLedgerOffloadMaxBlockSizeInBytes != null : !((Object)this$s3ManagedLedgerOffloadMaxBlockSizeInBytes).equals(other$s3ManagedLedgerOffloadMaxBlockSizeInBytes)) {
            return false;
        }
        Integer this$s3ManagedLedgerOffloadReadBufferSizeInBytes = this.getS3ManagedLedgerOffloadReadBufferSizeInBytes();
        Integer other$s3ManagedLedgerOffloadReadBufferSizeInBytes = other.getS3ManagedLedgerOffloadReadBufferSizeInBytes();
        if (this$s3ManagedLedgerOffloadReadBufferSizeInBytes == null ? other$s3ManagedLedgerOffloadReadBufferSizeInBytes != null : !((Object)this$s3ManagedLedgerOffloadReadBufferSizeInBytes).equals(other$s3ManagedLedgerOffloadReadBufferSizeInBytes)) {
            return false;
        }
        Integer this$gcsManagedLedgerOffloadMaxBlockSizeInBytes = this.getGcsManagedLedgerOffloadMaxBlockSizeInBytes();
        Integer other$gcsManagedLedgerOffloadMaxBlockSizeInBytes = other.getGcsManagedLedgerOffloadMaxBlockSizeInBytes();
        if (this$gcsManagedLedgerOffloadMaxBlockSizeInBytes == null ? other$gcsManagedLedgerOffloadMaxBlockSizeInBytes != null : !((Object)this$gcsManagedLedgerOffloadMaxBlockSizeInBytes).equals(other$gcsManagedLedgerOffloadMaxBlockSizeInBytes)) {
            return false;
        }
        Integer this$gcsManagedLedgerOffloadReadBufferSizeInBytes = this.getGcsManagedLedgerOffloadReadBufferSizeInBytes();
        Integer other$gcsManagedLedgerOffloadReadBufferSizeInBytes = other.getGcsManagedLedgerOffloadReadBufferSizeInBytes();
        if (this$gcsManagedLedgerOffloadReadBufferSizeInBytes == null ? other$gcsManagedLedgerOffloadReadBufferSizeInBytes != null : !((Object)this$gcsManagedLedgerOffloadReadBufferSizeInBytes).equals(other$gcsManagedLedgerOffloadReadBufferSizeInBytes)) {
            return false;
        }
        Integer this$managedLedgerOffloadMaxBlockSizeInBytes = this.getManagedLedgerOffloadMaxBlockSizeInBytes();
        Integer other$managedLedgerOffloadMaxBlockSizeInBytes = other.getManagedLedgerOffloadMaxBlockSizeInBytes();
        if (this$managedLedgerOffloadMaxBlockSizeInBytes == null ? other$managedLedgerOffloadMaxBlockSizeInBytes != null : !((Object)this$managedLedgerOffloadMaxBlockSizeInBytes).equals(other$managedLedgerOffloadMaxBlockSizeInBytes)) {
            return false;
        }
        Integer this$managedLedgerOffloadReadBufferSizeInBytes = this.getManagedLedgerOffloadReadBufferSizeInBytes();
        Integer other$managedLedgerOffloadReadBufferSizeInBytes = other.getManagedLedgerOffloadReadBufferSizeInBytes();
        if (this$managedLedgerOffloadReadBufferSizeInBytes == null ? other$managedLedgerOffloadReadBufferSizeInBytes != null : !((Object)this$managedLedgerOffloadReadBufferSizeInBytes).equals(other$managedLedgerOffloadReadBufferSizeInBytes)) {
            return false;
        }
        String this$offloadersDirectory = this.getOffloadersDirectory();
        String other$offloadersDirectory = other.getOffloadersDirectory();
        if (this$offloadersDirectory == null ? other$offloadersDirectory != null : !this$offloadersDirectory.equals(other$offloadersDirectory)) {
            return false;
        }
        String this$managedLedgerOffloadDriver = this.getManagedLedgerOffloadDriver();
        String other$managedLedgerOffloadDriver = other.getManagedLedgerOffloadDriver();
        if (this$managedLedgerOffloadDriver == null ? other$managedLedgerOffloadDriver != null : !this$managedLedgerOffloadDriver.equals(other$managedLedgerOffloadDriver)) {
            return false;
        }
        OffloadedReadPriority this$managedLedgerOffloadedReadPriority = this.getManagedLedgerOffloadedReadPriority();
        OffloadedReadPriority other$managedLedgerOffloadedReadPriority = other.getManagedLedgerOffloadedReadPriority();
        if (this$managedLedgerOffloadedReadPriority == null ? other$managedLedgerOffloadedReadPriority != null : !this$managedLedgerOffloadedReadPriority.equals(other$managedLedgerOffloadedReadPriority)) {
            return false;
        }
        Map<String, String> this$managedLedgerExtraConfigurations = this.getManagedLedgerExtraConfigurations();
        Map<String, String> other$managedLedgerExtraConfigurations = other.getManagedLedgerExtraConfigurations();
        if (this$managedLedgerExtraConfigurations == null ? other$managedLedgerExtraConfigurations != null : !((Object)this$managedLedgerExtraConfigurations).equals(other$managedLedgerExtraConfigurations)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadRegion = this.getS3ManagedLedgerOffloadRegion();
        String other$s3ManagedLedgerOffloadRegion = other.getS3ManagedLedgerOffloadRegion();
        if (this$s3ManagedLedgerOffloadRegion == null ? other$s3ManagedLedgerOffloadRegion != null : !this$s3ManagedLedgerOffloadRegion.equals(other$s3ManagedLedgerOffloadRegion)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadBucket = this.getS3ManagedLedgerOffloadBucket();
        String other$s3ManagedLedgerOffloadBucket = other.getS3ManagedLedgerOffloadBucket();
        if (this$s3ManagedLedgerOffloadBucket == null ? other$s3ManagedLedgerOffloadBucket != null : !this$s3ManagedLedgerOffloadBucket.equals(other$s3ManagedLedgerOffloadBucket)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadServiceEndpoint = this.getS3ManagedLedgerOffloadServiceEndpoint();
        String other$s3ManagedLedgerOffloadServiceEndpoint = other.getS3ManagedLedgerOffloadServiceEndpoint();
        if (this$s3ManagedLedgerOffloadServiceEndpoint == null ? other$s3ManagedLedgerOffloadServiceEndpoint != null : !this$s3ManagedLedgerOffloadServiceEndpoint.equals(other$s3ManagedLedgerOffloadServiceEndpoint)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadCredentialId = this.getS3ManagedLedgerOffloadCredentialId();
        String other$s3ManagedLedgerOffloadCredentialId = other.getS3ManagedLedgerOffloadCredentialId();
        if (this$s3ManagedLedgerOffloadCredentialId == null ? other$s3ManagedLedgerOffloadCredentialId != null : !this$s3ManagedLedgerOffloadCredentialId.equals(other$s3ManagedLedgerOffloadCredentialId)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadCredentialSecret = this.getS3ManagedLedgerOffloadCredentialSecret();
        String other$s3ManagedLedgerOffloadCredentialSecret = other.getS3ManagedLedgerOffloadCredentialSecret();
        if (this$s3ManagedLedgerOffloadCredentialSecret == null ? other$s3ManagedLedgerOffloadCredentialSecret != null : !this$s3ManagedLedgerOffloadCredentialSecret.equals(other$s3ManagedLedgerOffloadCredentialSecret)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadRole = this.getS3ManagedLedgerOffloadRole();
        String other$s3ManagedLedgerOffloadRole = other.getS3ManagedLedgerOffloadRole();
        if (this$s3ManagedLedgerOffloadRole == null ? other$s3ManagedLedgerOffloadRole != null : !this$s3ManagedLedgerOffloadRole.equals(other$s3ManagedLedgerOffloadRole)) {
            return false;
        }
        String this$s3ManagedLedgerOffloadRoleSessionName = this.getS3ManagedLedgerOffloadRoleSessionName();
        String other$s3ManagedLedgerOffloadRoleSessionName = other.getS3ManagedLedgerOffloadRoleSessionName();
        if (this$s3ManagedLedgerOffloadRoleSessionName == null ? other$s3ManagedLedgerOffloadRoleSessionName != null : !this$s3ManagedLedgerOffloadRoleSessionName.equals(other$s3ManagedLedgerOffloadRoleSessionName)) {
            return false;
        }
        String this$gcsManagedLedgerOffloadRegion = this.getGcsManagedLedgerOffloadRegion();
        String other$gcsManagedLedgerOffloadRegion = other.getGcsManagedLedgerOffloadRegion();
        if (this$gcsManagedLedgerOffloadRegion == null ? other$gcsManagedLedgerOffloadRegion != null : !this$gcsManagedLedgerOffloadRegion.equals(other$gcsManagedLedgerOffloadRegion)) {
            return false;
        }
        String this$gcsManagedLedgerOffloadBucket = this.getGcsManagedLedgerOffloadBucket();
        String other$gcsManagedLedgerOffloadBucket = other.getGcsManagedLedgerOffloadBucket();
        if (this$gcsManagedLedgerOffloadBucket == null ? other$gcsManagedLedgerOffloadBucket != null : !this$gcsManagedLedgerOffloadBucket.equals(other$gcsManagedLedgerOffloadBucket)) {
            return false;
        }
        String this$gcsManagedLedgerOffloadServiceAccountKeyFile = this.getGcsManagedLedgerOffloadServiceAccountKeyFile();
        String other$gcsManagedLedgerOffloadServiceAccountKeyFile = other.getGcsManagedLedgerOffloadServiceAccountKeyFile();
        if (this$gcsManagedLedgerOffloadServiceAccountKeyFile == null ? other$gcsManagedLedgerOffloadServiceAccountKeyFile != null : !this$gcsManagedLedgerOffloadServiceAccountKeyFile.equals(other$gcsManagedLedgerOffloadServiceAccountKeyFile)) {
            return false;
        }
        String this$fileSystemProfilePath = this.getFileSystemProfilePath();
        String other$fileSystemProfilePath = other.getFileSystemProfilePath();
        if (this$fileSystemProfilePath == null ? other$fileSystemProfilePath != null : !this$fileSystemProfilePath.equals(other$fileSystemProfilePath)) {
            return false;
        }
        String this$fileSystemURI = this.getFileSystemURI();
        String other$fileSystemURI = other.getFileSystemURI();
        if (this$fileSystemURI == null ? other$fileSystemURI != null : !this$fileSystemURI.equals(other$fileSystemURI)) {
            return false;
        }
        String this$managedLedgerOffloadBucket = this.getManagedLedgerOffloadBucket();
        String other$managedLedgerOffloadBucket = other.getManagedLedgerOffloadBucket();
        if (this$managedLedgerOffloadBucket == null ? other$managedLedgerOffloadBucket != null : !this$managedLedgerOffloadBucket.equals(other$managedLedgerOffloadBucket)) {
            return false;
        }
        String this$managedLedgerOffloadRegion = this.getManagedLedgerOffloadRegion();
        String other$managedLedgerOffloadRegion = other.getManagedLedgerOffloadRegion();
        if (this$managedLedgerOffloadRegion == null ? other$managedLedgerOffloadRegion != null : !this$managedLedgerOffloadRegion.equals(other$managedLedgerOffloadRegion)) {
            return false;
        }
        String this$managedLedgerOffloadServiceEndpoint = this.getManagedLedgerOffloadServiceEndpoint();
        String other$managedLedgerOffloadServiceEndpoint = other.getManagedLedgerOffloadServiceEndpoint();
        return !(this$managedLedgerOffloadServiceEndpoint == null ? other$managedLedgerOffloadServiceEndpoint != null : !this$managedLedgerOffloadServiceEndpoint.equals(other$managedLedgerOffloadServiceEndpoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OffloadPoliciesImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $managedLedgerOffloadMaxThreads = this.getManagedLedgerOffloadMaxThreads();
        result = result * 59 + ($managedLedgerOffloadMaxThreads == null ? 43 : ((Object)$managedLedgerOffloadMaxThreads).hashCode());
        Integer $managedLedgerOffloadReadThreads = this.getManagedLedgerOffloadReadThreads();
        result = result * 59 + ($managedLedgerOffloadReadThreads == null ? 43 : ((Object)$managedLedgerOffloadReadThreads).hashCode());
        Integer $managedLedgerOffloadPrefetchRounds = this.getManagedLedgerOffloadPrefetchRounds();
        result = result * 59 + ($managedLedgerOffloadPrefetchRounds == null ? 43 : ((Object)$managedLedgerOffloadPrefetchRounds).hashCode());
        Long $managedLedgerOffloadThresholdInSeconds = this.getManagedLedgerOffloadThresholdInSeconds();
        result = result * 59 + ($managedLedgerOffloadThresholdInSeconds == null ? 43 : ((Object)$managedLedgerOffloadThresholdInSeconds).hashCode());
        Long $managedLedgerOffloadThresholdInBytes = this.getManagedLedgerOffloadThresholdInBytes();
        result = result * 59 + ($managedLedgerOffloadThresholdInBytes == null ? 43 : ((Object)$managedLedgerOffloadThresholdInBytes).hashCode());
        Long $managedLedgerOffloadDeletionLagInMillis = this.getManagedLedgerOffloadDeletionLagInMillis();
        result = result * 59 + ($managedLedgerOffloadDeletionLagInMillis == null ? 43 : ((Object)$managedLedgerOffloadDeletionLagInMillis).hashCode());
        Integer $s3ManagedLedgerOffloadMaxBlockSizeInBytes = this.getS3ManagedLedgerOffloadMaxBlockSizeInBytes();
        result = result * 59 + ($s3ManagedLedgerOffloadMaxBlockSizeInBytes == null ? 43 : ((Object)$s3ManagedLedgerOffloadMaxBlockSizeInBytes).hashCode());
        Integer $s3ManagedLedgerOffloadReadBufferSizeInBytes = this.getS3ManagedLedgerOffloadReadBufferSizeInBytes();
        result = result * 59 + ($s3ManagedLedgerOffloadReadBufferSizeInBytes == null ? 43 : ((Object)$s3ManagedLedgerOffloadReadBufferSizeInBytes).hashCode());
        Integer $gcsManagedLedgerOffloadMaxBlockSizeInBytes = this.getGcsManagedLedgerOffloadMaxBlockSizeInBytes();
        result = result * 59 + ($gcsManagedLedgerOffloadMaxBlockSizeInBytes == null ? 43 : ((Object)$gcsManagedLedgerOffloadMaxBlockSizeInBytes).hashCode());
        Integer $gcsManagedLedgerOffloadReadBufferSizeInBytes = this.getGcsManagedLedgerOffloadReadBufferSizeInBytes();
        result = result * 59 + ($gcsManagedLedgerOffloadReadBufferSizeInBytes == null ? 43 : ((Object)$gcsManagedLedgerOffloadReadBufferSizeInBytes).hashCode());
        Integer $managedLedgerOffloadMaxBlockSizeInBytes = this.getManagedLedgerOffloadMaxBlockSizeInBytes();
        result = result * 59 + ($managedLedgerOffloadMaxBlockSizeInBytes == null ? 43 : ((Object)$managedLedgerOffloadMaxBlockSizeInBytes).hashCode());
        Integer $managedLedgerOffloadReadBufferSizeInBytes = this.getManagedLedgerOffloadReadBufferSizeInBytes();
        result = result * 59 + ($managedLedgerOffloadReadBufferSizeInBytes == null ? 43 : ((Object)$managedLedgerOffloadReadBufferSizeInBytes).hashCode());
        String $offloadersDirectory = this.getOffloadersDirectory();
        result = result * 59 + ($offloadersDirectory == null ? 43 : $offloadersDirectory.hashCode());
        String $managedLedgerOffloadDriver = this.getManagedLedgerOffloadDriver();
        result = result * 59 + ($managedLedgerOffloadDriver == null ? 43 : $managedLedgerOffloadDriver.hashCode());
        OffloadedReadPriority $managedLedgerOffloadedReadPriority = this.getManagedLedgerOffloadedReadPriority();
        result = result * 59 + ($managedLedgerOffloadedReadPriority == null ? 43 : $managedLedgerOffloadedReadPriority.hashCode());
        Map<String, String> $managedLedgerExtraConfigurations = this.getManagedLedgerExtraConfigurations();
        result = result * 59 + ($managedLedgerExtraConfigurations == null ? 43 : ((Object)$managedLedgerExtraConfigurations).hashCode());
        String $s3ManagedLedgerOffloadRegion = this.getS3ManagedLedgerOffloadRegion();
        result = result * 59 + ($s3ManagedLedgerOffloadRegion == null ? 43 : $s3ManagedLedgerOffloadRegion.hashCode());
        String $s3ManagedLedgerOffloadBucket = this.getS3ManagedLedgerOffloadBucket();
        result = result * 59 + ($s3ManagedLedgerOffloadBucket == null ? 43 : $s3ManagedLedgerOffloadBucket.hashCode());
        String $s3ManagedLedgerOffloadServiceEndpoint = this.getS3ManagedLedgerOffloadServiceEndpoint();
        result = result * 59 + ($s3ManagedLedgerOffloadServiceEndpoint == null ? 43 : $s3ManagedLedgerOffloadServiceEndpoint.hashCode());
        String $s3ManagedLedgerOffloadCredentialId = this.getS3ManagedLedgerOffloadCredentialId();
        result = result * 59 + ($s3ManagedLedgerOffloadCredentialId == null ? 43 : $s3ManagedLedgerOffloadCredentialId.hashCode());
        String $s3ManagedLedgerOffloadCredentialSecret = this.getS3ManagedLedgerOffloadCredentialSecret();
        result = result * 59 + ($s3ManagedLedgerOffloadCredentialSecret == null ? 43 : $s3ManagedLedgerOffloadCredentialSecret.hashCode());
        String $s3ManagedLedgerOffloadRole = this.getS3ManagedLedgerOffloadRole();
        result = result * 59 + ($s3ManagedLedgerOffloadRole == null ? 43 : $s3ManagedLedgerOffloadRole.hashCode());
        String $s3ManagedLedgerOffloadRoleSessionName = this.getS3ManagedLedgerOffloadRoleSessionName();
        result = result * 59 + ($s3ManagedLedgerOffloadRoleSessionName == null ? 43 : $s3ManagedLedgerOffloadRoleSessionName.hashCode());
        String $gcsManagedLedgerOffloadRegion = this.getGcsManagedLedgerOffloadRegion();
        result = result * 59 + ($gcsManagedLedgerOffloadRegion == null ? 43 : $gcsManagedLedgerOffloadRegion.hashCode());
        String $gcsManagedLedgerOffloadBucket = this.getGcsManagedLedgerOffloadBucket();
        result = result * 59 + ($gcsManagedLedgerOffloadBucket == null ? 43 : $gcsManagedLedgerOffloadBucket.hashCode());
        String $gcsManagedLedgerOffloadServiceAccountKeyFile = this.getGcsManagedLedgerOffloadServiceAccountKeyFile();
        result = result * 59 + ($gcsManagedLedgerOffloadServiceAccountKeyFile == null ? 43 : $gcsManagedLedgerOffloadServiceAccountKeyFile.hashCode());
        String $fileSystemProfilePath = this.getFileSystemProfilePath();
        result = result * 59 + ($fileSystemProfilePath == null ? 43 : $fileSystemProfilePath.hashCode());
        String $fileSystemURI = this.getFileSystemURI();
        result = result * 59 + ($fileSystemURI == null ? 43 : $fileSystemURI.hashCode());
        String $managedLedgerOffloadBucket = this.getManagedLedgerOffloadBucket();
        result = result * 59 + ($managedLedgerOffloadBucket == null ? 43 : $managedLedgerOffloadBucket.hashCode());
        String $managedLedgerOffloadRegion = this.getManagedLedgerOffloadRegion();
        result = result * 59 + ($managedLedgerOffloadRegion == null ? 43 : $managedLedgerOffloadRegion.hashCode());
        String $managedLedgerOffloadServiceEndpoint = this.getManagedLedgerOffloadServiceEndpoint();
        result = result * 59 + ($managedLedgerOffloadServiceEndpoint == null ? 43 : $managedLedgerOffloadServiceEndpoint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OffloadPoliciesImpl(offloadersDirectory=" + this.getOffloadersDirectory() + ", managedLedgerOffloadDriver=" + this.getManagedLedgerOffloadDriver() + ", managedLedgerOffloadMaxThreads=" + this.getManagedLedgerOffloadMaxThreads() + ", managedLedgerOffloadReadThreads=" + this.getManagedLedgerOffloadReadThreads() + ", managedLedgerOffloadPrefetchRounds=" + this.getManagedLedgerOffloadPrefetchRounds() + ", managedLedgerOffloadThresholdInSeconds=" + this.getManagedLedgerOffloadThresholdInSeconds() + ", managedLedgerOffloadThresholdInBytes=" + this.getManagedLedgerOffloadThresholdInBytes() + ", managedLedgerOffloadDeletionLagInMillis=" + this.getManagedLedgerOffloadDeletionLagInMillis() + ", managedLedgerOffloadedReadPriority=" + this.getManagedLedgerOffloadedReadPriority() + ", managedLedgerExtraConfigurations=" + this.getManagedLedgerExtraConfigurations() + ", s3ManagedLedgerOffloadRegion=" + this.getS3ManagedLedgerOffloadRegion() + ", s3ManagedLedgerOffloadBucket=" + this.getS3ManagedLedgerOffloadBucket() + ", s3ManagedLedgerOffloadServiceEndpoint=" + this.getS3ManagedLedgerOffloadServiceEndpoint() + ", s3ManagedLedgerOffloadMaxBlockSizeInBytes=" + this.getS3ManagedLedgerOffloadMaxBlockSizeInBytes() + ", s3ManagedLedgerOffloadReadBufferSizeInBytes=" + this.getS3ManagedLedgerOffloadReadBufferSizeInBytes() + ", s3ManagedLedgerOffloadCredentialId=" + this.getS3ManagedLedgerOffloadCredentialId() + ", s3ManagedLedgerOffloadCredentialSecret=" + this.getS3ManagedLedgerOffloadCredentialSecret() + ", s3ManagedLedgerOffloadRole=" + this.getS3ManagedLedgerOffloadRole() + ", s3ManagedLedgerOffloadRoleSessionName=" + this.getS3ManagedLedgerOffloadRoleSessionName() + ", gcsManagedLedgerOffloadRegion=" + this.getGcsManagedLedgerOffloadRegion() + ", gcsManagedLedgerOffloadBucket=" + this.getGcsManagedLedgerOffloadBucket() + ", gcsManagedLedgerOffloadMaxBlockSizeInBytes=" + this.getGcsManagedLedgerOffloadMaxBlockSizeInBytes() + ", gcsManagedLedgerOffloadReadBufferSizeInBytes=" + this.getGcsManagedLedgerOffloadReadBufferSizeInBytes() + ", gcsManagedLedgerOffloadServiceAccountKeyFile=" + this.getGcsManagedLedgerOffloadServiceAccountKeyFile() + ", fileSystemProfilePath=" + this.getFileSystemProfilePath() + ", fileSystemURI=" + this.getFileSystemURI() + ", managedLedgerOffloadBucket=" + this.getManagedLedgerOffloadBucket() + ", managedLedgerOffloadRegion=" + this.getManagedLedgerOffloadRegion() + ", managedLedgerOffloadServiceEndpoint=" + this.getManagedLedgerOffloadServiceEndpoint() + ", managedLedgerOffloadMaxBlockSizeInBytes=" + this.getManagedLedgerOffloadMaxBlockSizeInBytes() + ", managedLedgerOffloadReadBufferSizeInBytes=" + this.getManagedLedgerOffloadReadBufferSizeInBytes() + ")";
    }

    @Generated
    public OffloadPoliciesImpl() {
    }

    static {
        Field[] fields;
        log = LoggerFactory.getLogger(OffloadPoliciesImpl.class);
        ArrayList<Field> temp = new ArrayList<Field>();
        Class<OffloadPoliciesImpl> clazz = OffloadPoliciesImpl.class;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Configuration.class)) continue;
            temp.add(field);
        }
        CONFIGURATION_FIELDS = Collections.unmodifiableList(temp);
        INTERNAL_SUPPORTED_DRIVER = ImmutableList.of((Object)"S3", (Object)"aws-s3", (Object)"google-cloud-storage", (Object)"filesystem", (Object)"azureblob", (Object)"aliyun-oss");
        String extraDrivers = System.getProperty("pulsar.extra.offload.drivers", "");
        DRIVER_NAMES = extraDrivers.trim().isEmpty() ? INTERNAL_SUPPORTED_DRIVER : ImmutableList.builder().addAll(INTERNAL_SUPPORTED_DRIVER).addAll((Iterable)Arrays.stream(StringUtils.split((String)extraDrivers, (char)',')).map(String::trim).collect(Collectors.toSet())).build();
        DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES = null;
        DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS = null;
        DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS = null;
        DEFAULT_OFFLOADED_READ_PRIORITY = null;
    }

    public static class OffloadPoliciesImplBuilder
    implements OffloadPolicies.Builder {
        private OffloadPoliciesImpl impl = new OffloadPoliciesImpl();

        public OffloadPoliciesImplBuilder offloadersDirectory(String offloadersDirectory) {
            this.impl.offloadersDirectory = offloadersDirectory;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
            this.impl.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadMaxThreads(Integer managedLedgerOffloadMaxThreads) {
            this.impl.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadReadThreads(Integer managedLedgerOffloadReadThreads) {
            this.impl.managedLedgerOffloadReadThreads = managedLedgerOffloadReadThreads;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadPrefetchRounds(Integer managedLedgerOffloadPrefetchRounds) {
            this.impl.managedLedgerOffloadPrefetchRounds = managedLedgerOffloadPrefetchRounds;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadThresholdInBytes(Long managedLedgerOffloadThresholdInBytes) {
            this.impl.managedLedgerOffloadThresholdInBytes = managedLedgerOffloadThresholdInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadThresholdInSeconds(Long managedLedgerOffloadThresholdInSeconds) {
            this.impl.managedLedgerOffloadThresholdInSeconds = managedLedgerOffloadThresholdInSeconds;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadDeletionLagInMillis(Long managedLedgerOffloadDeletionLagInMillis) {
            this.impl.managedLedgerOffloadDeletionLagInMillis = managedLedgerOffloadDeletionLagInMillis;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadedReadPriority(OffloadedReadPriority managedLedgerOffloadedReadPriority) {
            this.impl.managedLedgerOffloadedReadPriority = managedLedgerOffloadedReadPriority;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadRegion(String s3ManagedLedgerOffloadRegion) {
            this.impl.s3ManagedLedgerOffloadRegion = s3ManagedLedgerOffloadRegion;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadBucket(String s3ManagedLedgerOffloadBucket) {
            this.impl.s3ManagedLedgerOffloadBucket = s3ManagedLedgerOffloadBucket;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadServiceEndpoint(String s3ManagedLedgerOffloadServiceEndpoint) {
            this.impl.s3ManagedLedgerOffloadServiceEndpoint = s3ManagedLedgerOffloadServiceEndpoint;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadMaxBlockSizeInBytes(Integer s3ManagedLedgerOffloadMaxBlockSizeInBytes) {
            this.impl.s3ManagedLedgerOffloadMaxBlockSizeInBytes = s3ManagedLedgerOffloadMaxBlockSizeInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadReadBufferSizeInBytes(Integer s3ManagedLedgerOffloadReadBufferSizeInBytes) {
            this.impl.s3ManagedLedgerOffloadReadBufferSizeInBytes = s3ManagedLedgerOffloadReadBufferSizeInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadCredentialId(String s3ManagedLedgerOffloadCredentialId) {
            this.impl.s3ManagedLedgerOffloadCredentialId = s3ManagedLedgerOffloadCredentialId;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadCredentialSecret(String s3ManagedLedgerOffloadCredentialSecret) {
            this.impl.s3ManagedLedgerOffloadCredentialSecret = s3ManagedLedgerOffloadCredentialSecret;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadRole(String s3ManagedLedgerOffloadRole) {
            this.impl.s3ManagedLedgerOffloadRole = s3ManagedLedgerOffloadRole;
            return this;
        }

        public OffloadPolicies.Builder setS3ManagedLedgerOffloadRoleSessionName(String s3ManagedLedgerOffloadRoleSessionName) {
            this.impl.s3ManagedLedgerOffloadRoleSessionName = s3ManagedLedgerOffloadRoleSessionName;
            return this;
        }

        public OffloadPoliciesImplBuilder s3ManagedLedgerOffloadRoleSessionName(String s3ManagedLedgerOffloadRoleSessionName) {
            this.impl.s3ManagedLedgerOffloadRoleSessionName = s3ManagedLedgerOffloadRoleSessionName;
            return this;
        }

        public OffloadPoliciesImplBuilder gcsManagedLedgerOffloadRegion(String gcsManagedLedgerOffloadRegion) {
            this.impl.gcsManagedLedgerOffloadRegion = gcsManagedLedgerOffloadRegion;
            return this;
        }

        public OffloadPoliciesImplBuilder gcsManagedLedgerOffloadBucket(String gcsManagedLedgerOffloadBucket) {
            this.impl.gcsManagedLedgerOffloadBucket = gcsManagedLedgerOffloadBucket;
            return this;
        }

        public OffloadPoliciesImplBuilder gcsManagedLedgerOffloadMaxBlockSizeInBytes(Integer gcsManagedLedgerOffloadMaxBlockSizeInBytes) {
            this.impl.gcsManagedLedgerOffloadMaxBlockSizeInBytes = gcsManagedLedgerOffloadMaxBlockSizeInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder gcsManagedLedgerOffloadReadBufferSizeInBytes(Integer gcsManagedLedgerOffloadReadBufferSizeInBytes) {
            this.impl.gcsManagedLedgerOffloadReadBufferSizeInBytes = gcsManagedLedgerOffloadReadBufferSizeInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder gcsManagedLedgerOffloadServiceAccountKeyFile(String gcsManagedLedgerOffloadServiceAccountKeyFile) {
            this.impl.gcsManagedLedgerOffloadServiceAccountKeyFile = gcsManagedLedgerOffloadServiceAccountKeyFile;
            return this;
        }

        public OffloadPoliciesImplBuilder fileSystemProfilePath(String fileSystemProfilePath) {
            this.impl.fileSystemProfilePath = fileSystemProfilePath;
            return this;
        }

        public OffloadPoliciesImplBuilder fileSystemURI(String fileSystemURI) {
            this.impl.fileSystemURI = fileSystemURI;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadBucket(String managedLedgerOffloadBucket) {
            this.impl.managedLedgerOffloadBucket = managedLedgerOffloadBucket;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadRegion(String managedLedgerOffloadRegion) {
            this.impl.managedLedgerOffloadRegion = managedLedgerOffloadRegion;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadServiceEndpoint(String managedLedgerOffloadServiceEndpoint) {
            this.impl.managedLedgerOffloadServiceEndpoint = managedLedgerOffloadServiceEndpoint;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadMaxBlockSizeInBytes(Integer managedLedgerOffloadMaxBlockSizeInBytes) {
            this.impl.managedLedgerOffloadMaxBlockSizeInBytes = managedLedgerOffloadMaxBlockSizeInBytes;
            return this;
        }

        public OffloadPoliciesImplBuilder managedLedgerOffloadReadBufferSizeInBytes(Integer managedLedgerOffloadReadBufferSizeInBytes) {
            this.impl.managedLedgerOffloadReadBufferSizeInBytes = managedLedgerOffloadReadBufferSizeInBytes;
            return this;
        }

        public OffloadPoliciesImpl build() {
            return this.impl;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Configuration {
    }
}

