/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.pulsar.shade.org.apache.avro.AvroRuntimeException;
import org.apache.pulsar.shade.org.apache.avro.FormattedSchemaParser;
import org.apache.pulsar.shade.org.apache.avro.JsonSchemaParser;
import org.apache.pulsar.shade.org.apache.avro.ParseContext;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaParseException;
import org.apache.pulsar.shade.org.apache.avro.util.UtfTextUtils;

public class SchemaParser {
    private final ParseContext parseContext = new ParseContext();
    private final Collection<FormattedSchemaParser> formattedSchemaParsers = new ArrayList<FormattedSchemaParser>();

    public SchemaParser() {
        for (FormattedSchemaParser formattedSchemaParser : ServiceLoader.load(FormattedSchemaParser.class)) {
            this.formattedSchemaParsers.add(formattedSchemaParser);
        }
        this.formattedSchemaParsers.add(new JsonSchemaParser());
    }

    public ParseResult parse(File file) throws IOException, SchemaParseException {
        return this.parse(file, null);
    }

    public ParseResult parse(File file, Charset charset) throws IOException, SchemaParseException {
        return this.parse(file.toPath(), charset);
    }

    public ParseResult parse(Path file) throws IOException, SchemaParseException {
        return this.parse(file, null);
    }

    public ParseResult parse(Path file, Charset charset) throws IOException, SchemaParseException {
        URI inputDir = file.getParent().toUri();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            String formattedSchema = UtfTextUtils.readAllBytes(stream, charset);
            ParseResult parseResult = this.parse(inputDir, formattedSchema);
            return parseResult;
        }
    }

    public ParseResult parse(URI location, Charset charset) throws IOException, SchemaParseException {
        try (InputStream stream = location.toURL().openStream();){
            String formattedSchema = UtfTextUtils.readAllBytes(stream, charset);
            ParseResult parseResult = this.parse(location, formattedSchema);
            return parseResult;
        }
    }

    public ParseResult parse(InputStream in) throws IOException, SchemaParseException {
        return this.parse(in, null);
    }

    public ParseResult parse(InputStream in, Charset charset) throws IOException, SchemaParseException {
        return this.parse(UtfTextUtils.readAllBytes(in, charset));
    }

    public ParseResult parse(Reader in) throws IOException, SchemaParseException {
        return this.parse(UtfTextUtils.readAllChars(in));
    }

    public ParseResult parse(CharSequence text) throws SchemaParseException {
        try {
            return this.parse(null, text);
        }
        catch (IOException e) {
            throw new AvroRuntimeException("Could not read schema", e);
        }
    }

    private ParseResult parse(URI baseUri, CharSequence formattedSchema) throws IOException, SchemaParseException {
        ArrayList<SchemaParseException> parseExceptions = new ArrayList<SchemaParseException>();
        for (FormattedSchemaParser formattedSchemaParser : this.formattedSchemaParsers) {
            try {
                Schema schema = formattedSchemaParser.parse(this.parseContext, baseUri, formattedSchema);
                if (!this.parseContext.hasNewSchemas() && schema == null) continue;
                return this.parseContext.commit(schema);
            }
            catch (SchemaParseException e) {
                this.parseContext.rollback();
                parseExceptions.add(e);
            }
        }
        if (parseExceptions.size() == 1) {
            throw (SchemaParseException)parseExceptions.get(0);
        }
        SchemaParseException parseException = new SchemaParseException("Could not parse the schema (the suppressed exceptions tell why).");
        parseExceptions.forEach(parseException::addSuppressed);
        throw parseException;
    }

    public List<Schema> getParsedNamedSchemas() {
        return this.parseContext.resolveAllSchemas();
    }

    @Deprecated
    public Schema resolve(ParseResult result) {
        return result.mainSchema();
    }

    public static interface ParseResult {
        public Schema mainSchema();

        public List<Schema> parsedNamedSchemas();
    }
}

