/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryDecoder;
import org.apache.pulsar.shade.org.apache.avro.io.DecoderFactory;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectDatumReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroReader<T>
implements SchemaReader<T> {
    private ReflectDatumReader<T> reader;
    private static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();
    private final Schema schema;
    private static final Logger log = LoggerFactory.getLogger(AvroReader.class);

    public AvroReader(Schema schema) {
        this.reader = new ReflectDatumReader(schema);
        this.schema = schema;
    }

    public AvroReader(Schema schema, ClassLoader classLoader, boolean jsr310ConversionEnabled) {
        this.schema = schema;
        if (classLoader != null) {
            ReflectData reflectData = new ReflectData(classLoader);
            AvroSchema.addLogicalTypeConversions(reflectData, jsr310ConversionEnabled);
            this.reader = new ReflectDatumReader(schema, schema, reflectData);
        } else {
            this.reader = new ReflectDatumReader(schema);
        }
    }

    public AvroReader(Schema writerSchema, Schema readerSchema, ClassLoader classLoader, boolean jsr310ConversionEnabled) {
        this.schema = readerSchema;
        if (classLoader != null) {
            ReflectData reflectData = new ReflectData(classLoader);
            AvroSchema.addLogicalTypeConversions(reflectData, jsr310ConversionEnabled);
            this.reader = new ReflectDatumReader(writerSchema, readerSchema, reflectData);
        } else {
            this.reader = new ReflectDatumReader(writerSchema, readerSchema);
        }
    }

    public T read(byte[] bytes, int offset, int length) {
        try {
            BinaryDecoder decoderFromCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, offset, length, decoderFromCache);
            if (decoderFromCache == null) {
                decoders.set(decoder);
            }
            return this.reader.read(null, DecoderFactory.get().binaryDecoder(bytes, offset, length, decoder));
        }
        catch (IOException e) {
            throw new SchemaSerializationException((Throwable)e);
        }
    }

    public T read(InputStream inputStream) {
        try {
            BinaryDecoder decoderFromCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, decoderFromCache);
            if (decoderFromCache == null) {
                decoders.set(decoder);
            }
            T t = this.reader.read(null, DecoderFactory.get().binaryDecoder(inputStream, decoder));
            return t;
        }
        catch (Exception e) {
            throw new SchemaSerializationException((Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("AvroReader close inputStream close error", (Throwable)e);
            }
        }
    }

    public Optional<Object> getNativeSchema() {
        return Optional.of(this.schema);
    }
}

