/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.roaringbitmap;

import org.apache.pulsar.shade.org.roaringbitmap.ArrayContainer;
import org.apache.pulsar.shade.org.roaringbitmap.BitmapContainer;
import org.apache.pulsar.shade.org.roaringbitmap.CharIterator;
import org.apache.pulsar.shade.org.roaringbitmap.Container;
import org.apache.pulsar.shade.org.roaringbitmap.IntIterator;
import org.apache.pulsar.shade.org.roaringbitmap.ReverseArrayContainerCharIterator;
import org.apache.pulsar.shade.org.roaringbitmap.ReverseBitmapContainerCharIterator;
import org.apache.pulsar.shade.org.roaringbitmap.ReverseRunContainerCharIterator;
import org.apache.pulsar.shade.org.roaringbitmap.RoaringBitmap;
import org.apache.pulsar.shade.org.roaringbitmap.RunContainer;

public class ReverseIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private CharIterator iter;
    private ReverseArrayContainerCharIterator arrIter = new ReverseArrayContainerCharIterator();
    private ReverseBitmapContainerCharIterator bitmapIter = new ReverseBitmapContainerCharIterator();
    private ReverseRunContainerCharIterator runIter = new ReverseRunContainerCharIterator();
    private short pos;
    private RoaringBitmap roaringBitmap = null;

    public ReverseIntIteratorFlyweight() {
    }

    public ReverseIntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            ReverseIntIteratorFlyweight x = (ReverseIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            this.pos = (short)(this.pos - 1);
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos >= 0) {
            Container container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container).bitmap);
                this.iter = this.bitmapIter;
            } else if (container instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container);
                this.iter = this.runIter;
            }
            this.hs = this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos) << 16;
        }
    }

    public void wrap(RoaringBitmap r) {
        this.roaringBitmap = r;
        this.hs = 0;
        this.pos = (short)(this.roaringBitmap.highLowContainer.size() - 1);
        this.nextContainer();
    }
}

