/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;

public interface ReactiveMessageSenderSpec {
    public String getTopicName();

    public String getProducerName();

    public Duration getSendTimeout();

    public Integer getMaxPendingMessages();

    public Integer getMaxPendingMessagesAcrossPartitions();

    public MessageRoutingMode getMessageRoutingMode();

    public HashingScheme getHashingScheme();

    public ProducerCryptoFailureAction getCryptoFailureAction();

    public MessageRouter getMessageRouter();

    public Duration getBatchingMaxPublishDelay();

    public Integer getRoundRobinRouterBatchingPartitionSwitchFrequency();

    public Integer getBatchingMaxMessages();

    public Integer getBatchingMaxBytes();

    public Boolean getBatchingEnabled();

    public BatcherBuilder getBatcherBuilder();

    public Boolean getChunkingEnabled();

    public CryptoKeyReader getCryptoKeyReader();

    public Set<String> getEncryptionKeys();

    public CompressionType getCompressionType();

    public Long getInitialSequenceId();

    public Boolean getAutoUpdatePartitions();

    public Duration getAutoUpdatePartitionsInterval();

    public Boolean getMultiSchema();

    public ProducerAccessMode getAccessMode();

    public Boolean getLazyStartPartitionedProducers();

    public Map<String, String> getProperties();
}

