/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.util.List;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.reactive.client.api.EndOfStreamAction;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReader;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.StartAtSpec;

public interface ReactiveMessageReaderBuilder<T> {
    public ReactiveMessageReaderBuilder<T> startAtSpec(StartAtSpec var1);

    public ReactiveMessageReaderBuilder<T> endOfStreamAction(EndOfStreamAction var1);

    default public ReactiveMessageReaderBuilder<T> applySpec(ReactiveMessageReaderSpec readerSpec) {
        this.getMutableSpec().applySpec(readerSpec);
        return this;
    }

    default public ReactiveMessageReaderSpec toImmutableSpec() {
        return new ImmutableReactiveMessageReaderSpec(this.getMutableSpec());
    }

    public MutableReactiveMessageReaderSpec getMutableSpec();

    public ReactiveMessageReaderBuilder<T> clone();

    public ReactiveMessageReader<T> build();

    default public ReactiveMessageReaderBuilder<T> topic(String topicName) {
        this.getMutableSpec().getTopicNames().add(topicName);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> topic(String ... topicNames) {
        for (String topicName : topicNames) {
            this.getMutableSpec().getTopicNames().add(topicName);
        }
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> topics(List<String> topicNames) {
        this.getMutableSpec().setTopicNames(topicNames);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> readerName(String readerName) {
        this.getMutableSpec().setReaderName(readerName);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> subscriptionName(String subscriptionName) {
        this.getMutableSpec().setSubscriptionName(subscriptionName);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> generatedSubscriptionNamePrefix(String generatedSubscriptionNamePrefix) {
        this.getMutableSpec().setGeneratedSubscriptionNamePrefix(generatedSubscriptionNamePrefix);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> receiverQueueSize(Integer receiverQueueSize) {
        this.getMutableSpec().setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> readCompacted(Boolean readCompacted) {
        this.getMutableSpec().setReadCompacted(readCompacted);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> keyHashRanges(List<Range> keyHashRanges) {
        this.getMutableSpec().setKeyHashRanges(keyHashRanges);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.getMutableSpec().setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    default public ReactiveMessageReaderBuilder<T> cryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.getMutableSpec().setCryptoFailureAction(cryptoFailureAction);
        return this;
    }
}

