/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumer;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerSpec;
import reactor.core.scheduler.Scheduler;

public interface ReactiveMessageConsumerBuilder<T> {
    default public ReactiveMessageConsumerBuilder<T> applySpec(ReactiveMessageConsumerSpec consumerSpec) {
        this.getMutableSpec().applySpec(consumerSpec);
        return this;
    }

    default public ReactiveMessageConsumerSpec toImmutableSpec() {
        return new ImmutableReactiveMessageConsumerSpec(this.getMutableSpec());
    }

    public MutableReactiveMessageConsumerSpec getMutableSpec();

    public ReactiveMessageConsumerBuilder<T> clone();

    default public ReactiveMessageConsumerBuilder<T> topic(String topicName) {
        this.getMutableSpec().getTopicNames().add(topicName);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> topic(String ... topicNames) {
        for (String topicName : topicNames) {
            this.getMutableSpec().getTopicNames().add(topicName);
        }
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> topics(List<String> topicNames) {
        this.getMutableSpec().setTopicNames(topicNames);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> topicsPattern(Pattern topicsPattern) {
        this.getMutableSpec().setTopicsPattern(topicsPattern);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> topicsPatternSubscriptionMode(RegexSubscriptionMode topicsPatternSubscriptionMode) {
        this.getMutableSpec().setTopicsPatternSubscriptionMode(topicsPatternSubscriptionMode);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> topicsPatternAutoDiscoveryPeriod(Duration topicsPatternAutoDiscoveryPeriod) {
        this.getMutableSpec().setTopicsPatternAutoDiscoveryPeriod(topicsPatternAutoDiscoveryPeriod);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionName(String subscriptionName) {
        this.getMutableSpec().setSubscriptionName(subscriptionName);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionMode(SubscriptionMode subscriptionMode) {
        this.getMutableSpec().setSubscriptionMode(subscriptionMode);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionType(SubscriptionType subscriptionType) {
        this.getMutableSpec().setSubscriptionType(subscriptionType);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.getMutableSpec().setSubscriptionInitialPosition(subscriptionInitialPosition);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> keySharedPolicy(KeySharedPolicy keySharedPolicy) {
        this.getMutableSpec().setKeySharedPolicy(keySharedPolicy);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> replicateSubscriptionState(boolean replicateSubscriptionState) {
        this.getMutableSpec().setReplicateSubscriptionState(replicateSubscriptionState);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionProperties(Map<String, String> subscriptionProperties) {
        this.getMutableSpec().setSubscriptionProperties(subscriptionProperties);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> subscriptionProperty(String key, String value) {
        if (this.getMutableSpec().getSubscriptionProperties() == null) {
            this.getMutableSpec().setSubscriptionProperties(new LinkedHashMap<String, String>());
        }
        this.getMutableSpec().getSubscriptionProperties().put(key, value);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> consumerName(String consumerName) {
        this.getMutableSpec().setConsumerName(consumerName);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> properties(Map<String, String> properties) {
        this.getMutableSpec().setProperties(properties);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> property(String key, String value) {
        if (this.getMutableSpec().getProperties() == null) {
            this.getMutableSpec().setProperties(new LinkedHashMap<String, String>());
        }
        this.getMutableSpec().getProperties().put(key, value);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> priorityLevel(Integer priorityLevel) {
        this.getMutableSpec().setPriorityLevel(priorityLevel);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> readCompacted(boolean readCompacted) {
        this.getMutableSpec().setReadCompacted(readCompacted);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> batchIndexAckEnabled(boolean batchIndexAckEnabled) {
        this.getMutableSpec().setBatchIndexAckEnabled(batchIndexAckEnabled);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> ackTimeout(Duration ackTimeout) {
        this.getMutableSpec().setAckTimeout(ackTimeout);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> ackTimeoutTickTime(Duration ackTimeoutTickTime) {
        this.getMutableSpec().setAckTimeoutTickTime(ackTimeoutTickTime);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> acknowledgementsGroupTime(Duration acknowledgementsGroupTime) {
        this.getMutableSpec().setAcknowledgementsGroupTime(acknowledgementsGroupTime);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> acknowledgeAsynchronously(boolean acknowledgeAsynchronously) {
        this.getMutableSpec().setAcknowledgeAsynchronously(acknowledgeAsynchronously);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> acknowledgeScheduler(Scheduler acknowledgeScheduler) {
        this.getMutableSpec().setAcknowledgeScheduler(acknowledgeScheduler);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> negativeAckRedeliveryDelay(Duration negativeAckRedeliveryDelay) {
        this.getMutableSpec().setNegativeAckRedeliveryDelay(negativeAckRedeliveryDelay);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> negativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.getMutableSpec().setNegativeAckRedeliveryBackoff(negativeAckRedeliveryBackoff);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> ackTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.getMutableSpec().setAckTimeoutRedeliveryBackoff(ackTimeoutRedeliveryBackoff);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> deadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.getMutableSpec().setDeadLetterPolicy(deadLetterPolicy);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> retryLetterTopicEnable(boolean retryLetterTopicEnable) {
        this.getMutableSpec().setRetryLetterTopicEnable(retryLetterTopicEnable);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> receiverQueueSize(Integer receiverQueueSize) {
        this.getMutableSpec().setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> maxTotalReceiverQueueSizeAcrossPartitions(Integer maxTotalReceiverQueueSizeAcrossPartitions) {
        this.getMutableSpec().setMaxTotalReceiverQueueSizeAcrossPartitions(maxTotalReceiverQueueSizeAcrossPartitions);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> autoUpdatePartitions(boolean autoUpdatePartitions) {
        this.getMutableSpec().setAutoUpdatePartitions(autoUpdatePartitions);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> autoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.getMutableSpec().setAutoUpdatePartitionsInterval(autoUpdatePartitionsInterval);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.getMutableSpec().setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> cryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.getMutableSpec().setCryptoFailureAction(cryptoFailureAction);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> maxPendingChunkedMessage(Integer maxPendingChunkedMessage) {
        this.getMutableSpec().setMaxPendingChunkedMessage(maxPendingChunkedMessage);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> autoAckOldestChunkedMessageOnQueueFull(boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.getMutableSpec().setAutoAckOldestChunkedMessageOnQueueFull(autoAckOldestChunkedMessageOnQueueFull);
        return this;
    }

    default public ReactiveMessageConsumerBuilder<T> expireTimeOfIncompleteChunkedMessage(Duration expireTimeOfIncompleteChunkedMessage) {
        this.getMutableSpec().setExpireTimeOfIncompleteChunkedMessage(expireTimeOfIncompleteChunkedMessage);
        return this;
    }

    public ReactiveMessageConsumer<T> build();
}

