/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSender;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderCache;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderSpec;

public interface ReactiveMessageSenderBuilder<T> {
    public ReactiveMessageSenderBuilder<T> cache(ReactiveMessageSenderCache var1);

    public ReactiveMessageSenderBuilder<T> maxInflight(int var1);

    public ReactiveMessageSenderBuilder<T> maxConcurrentSenderSubscriptions(int var1);

    public ReactiveMessageSenderBuilder<T> stopOnError(boolean var1);

    public ReactiveMessageSenderBuilder<T> clone();

    default public ReactiveMessageSenderBuilder<T> applySpec(ReactiveMessageSenderSpec senderSpec) {
        this.getMutableSpec().applySpec(senderSpec);
        return this;
    }

    default public ReactiveMessageSenderSpec toImmutableSpec() {
        return new ImmutableReactiveMessageSenderSpec(this.getMutableSpec());
    }

    public MutableReactiveMessageSenderSpec getMutableSpec();

    default public ReactiveMessageSenderBuilder<T> topic(String topicName) {
        this.getMutableSpec().setTopicName(topicName);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> producerName(String producerName) {
        this.getMutableSpec().setProducerName(producerName);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> sendTimeout(Duration sendTimeout) {
        this.getMutableSpec().setSendTimeout(sendTimeout);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> maxPendingMessages(int maxPendingMessages) {
        this.getMutableSpec().setMaxPendingMessages(maxPendingMessages);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> maxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.getMutableSpec().setMaxPendingMessagesAcrossPartitions(maxPendingMessagesAcrossPartitions);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> messageRoutingMode(MessageRoutingMode messageRoutingMode) {
        this.getMutableSpec().setMessageRoutingMode(messageRoutingMode);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> hashingScheme(HashingScheme hashingScheme) {
        this.getMutableSpec().setHashingScheme(hashingScheme);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> cryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
        this.getMutableSpec().setCryptoFailureAction(cryptoFailureAction);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> messageRouter(MessageRouter messageRouter) {
        this.getMutableSpec().setMessageRouter(messageRouter);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> batchingMaxPublishDelay(Duration batchingMaxPublishDelay) {
        this.getMutableSpec().setBatchingMaxPublishDelay(batchingMaxPublishDelay);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> roundRobinRouterBatchingPartitionSwitchFrequency(int roundRobinRouterBatchingPartitionSwitchFrequency) {
        this.getMutableSpec().setRoundRobinRouterBatchingPartitionSwitchFrequency(roundRobinRouterBatchingPartitionSwitchFrequency);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> batchingMaxMessages(int batchingMaxMessages) {
        this.getMutableSpec().setBatchingMaxMessages(batchingMaxMessages);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> batchingMaxBytes(int batchingMaxBytes) {
        this.getMutableSpec().setBatchingMaxBytes(batchingMaxBytes);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> batchingEnabled(boolean batchingEnabled) {
        this.getMutableSpec().setBatchingEnabled(batchingEnabled);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> batcherBuilder(BatcherBuilder batcherBuilder) {
        this.getMutableSpec().setBatcherBuilder(batcherBuilder);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> chunkingEnabled(boolean chunkingEnabled) {
        this.getMutableSpec().setChunkingEnabled(chunkingEnabled);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.getMutableSpec().setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> encryptionKeys(Set<String> encryptionKeys) {
        this.getMutableSpec().setEncryptionKeys(encryptionKeys);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> compressionType(CompressionType compressionType) {
        this.getMutableSpec().setCompressionType(compressionType);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> initialSequenceId(long initialSequenceId) {
        this.getMutableSpec().setInitialSequenceId(initialSequenceId);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> autoUpdatePartitions(boolean autoUpdatePartitions) {
        this.getMutableSpec().setAutoUpdatePartitions(autoUpdatePartitions);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> autoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.getMutableSpec().setAutoUpdatePartitionsInterval(autoUpdatePartitionsInterval);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> multiSchema(boolean multiSchema) {
        this.getMutableSpec().setMultiSchema(multiSchema);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> accessMode(ProducerAccessMode accessMode) {
        this.getMutableSpec().setAccessMode(accessMode);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> lazyStartPartitionedProducers(boolean lazyStartPartitionedProducers) {
        this.getMutableSpec().setLazyStartPartitionedProducers(lazyStartPartitionedProducers);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> property(String key, String value) {
        if (this.getMutableSpec().getProperties() == null) {
            this.getMutableSpec().setProperties(new LinkedHashMap<String, String>());
        }
        this.getMutableSpec().getProperties().put(key, value);
        return this;
    }

    default public ReactiveMessageSenderBuilder<T> properties(Map<String, String> properties) {
        this.getMutableSpec().setProperties(properties);
        return this;
    }

    public ReactiveMessageSender<T> build();
}

