/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.reactive.client.internal.api.ApiImplementationFactory;

public interface MessageResult<T> {
    public static <T> MessageResult<T> acknowledge(MessageId messageId, T value) {
        return ApiImplementationFactory.acknowledge(messageId, value);
    }

    public static <T> MessageResult<T> negativeAcknowledge(MessageId messageId, T value) {
        return ApiImplementationFactory.negativeAcknowledge(messageId, value);
    }

    public static MessageResult<Void> acknowledge(MessageId messageId) {
        return ApiImplementationFactory.acknowledge(messageId);
    }

    public static MessageResult<Void> negativeAcknowledge(MessageId messageId) {
        return ApiImplementationFactory.negativeAcknowledge(messageId);
    }

    public static <V> MessageResult<Void> acknowledge(Message<V> message) {
        return MessageResult.acknowledge(message.getMessageId());
    }

    public static <V> MessageResult<Void> negativeAcknowledge(Message<V> message) {
        return MessageResult.negativeAcknowledge(message.getMessageId());
    }

    public static <V> MessageResult<Message<V>> acknowledgeAndReturn(Message<V> message) {
        return MessageResult.acknowledge(message.getMessageId(), message);
    }

    public boolean isAcknowledgeMessage();

    public MessageId getMessageId();

    public T getValue();
}

