/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.ClusterMessageId;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class ReplicatedSubscriptionsUpdate {
    private String subscriptionName;
    private int _subscriptionNameBufferIdx = -1;
    private int _subscriptionNameBufferLen = -1;
    private static final int _SUBSCRIPTION_NAME_FIELD_NUMBER = 1;
    private static final int _SUBSCRIPTION_NAME_TAG = 10;
    private static final int _SUBSCRIPTION_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _SUBSCRIPTION_NAME_MASK = 1;
    private List<ClusterMessageId> clusters = null;
    private int _clustersCount = 0;
    private static final int _CLUSTERS_FIELD_NUMBER = 2;
    private static final int _CLUSTERS_TAG = 18;
    private static final int _CLUSTERS_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasSubscriptionName() {
        return (this._bitField0 & 1) != 0;
    }

    public String getSubscriptionName() {
        if (!this.hasSubscriptionName()) {
            throw new IllegalStateException("Field 'subscription_name' is not set");
        }
        if (this.subscriptionName == null) {
            this.subscriptionName = LightProtoCodec.readString(this._parsedBuffer, this._subscriptionNameBufferIdx, this._subscriptionNameBufferLen);
        }
        return this.subscriptionName;
    }

    public ReplicatedSubscriptionsUpdate setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        this._bitField0 |= 1;
        this._subscriptionNameBufferIdx = -1;
        this._subscriptionNameBufferLen = LightProtoCodec.computeStringUTF8Size(subscriptionName);
        this._cachedSize = -1;
        return this;
    }

    public ReplicatedSubscriptionsUpdate clearSubscriptionName() {
        this._bitField0 &= 0xFFFFFFFE;
        this.subscriptionName = null;
        this._subscriptionNameBufferIdx = -1;
        this._subscriptionNameBufferLen = -1;
        return this;
    }

    public int getClustersCount() {
        return this._clustersCount;
    }

    public ClusterMessageId getClusterAt(int idx) {
        if (idx < 0 || idx >= this._clustersCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._clustersCount + ") for field 'clusters'");
        }
        return this.clusters.get(idx);
    }

    public List<ClusterMessageId> getClustersList() {
        if (this._clustersCount == 0) {
            return Collections.emptyList();
        }
        return this.clusters.subList(0, this._clustersCount);
    }

    public ClusterMessageId addCluster() {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ClusterMessageId>();
        }
        if (this.clusters.size() == this._clustersCount) {
            this.clusters.add(new ClusterMessageId());
        }
        this._cachedSize = -1;
        return this.clusters.get(this._clustersCount++);
    }

    public ReplicatedSubscriptionsUpdate addAllClusters(Iterable<ClusterMessageId> clusters) {
        for (ClusterMessageId _o : clusters) {
            this.addCluster().copyFrom(_o);
        }
        return this;
    }

    public ReplicatedSubscriptionsUpdate clearClusters() {
        for (int i = 0; i < this._clustersCount; ++i) {
            this.clusters.get(i).clear();
        }
        this._clustersCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._subscriptionNameBufferLen);
        if (this._subscriptionNameBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.subscriptionName, this._subscriptionNameBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._subscriptionNameBufferIdx, _b, this._subscriptionNameBufferLen);
        }
        for (int i = 0; i < this._clustersCount; ++i) {
            ClusterMessageId _item = this.clusters.get(i);
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _SUBSCRIPTION_NAME_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._subscriptionNameBufferLen);
        _size += this._subscriptionNameBufferLen;
        for (int i = 0; i < this._clustersCount; ++i) {
            ClusterMessageId _item = this.clusters.get(i);
            _size += _CLUSTERS_TAG_SIZE;
            int MsgsizeClusters = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeClusters) + MsgsizeClusters;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block4: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._subscriptionNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._subscriptionNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._subscriptionNameBufferLen);
                    continue block4;
                }
                case 18: {
                    int _clustersSize = LightProtoCodec.readVarInt(_buffer);
                    this.addCluster().parseFrom(_buffer, _clustersSize);
                    continue block4;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public ReplicatedSubscriptionsUpdate clear() {
        this.subscriptionName = null;
        this._subscriptionNameBufferIdx = -1;
        this._subscriptionNameBufferLen = -1;
        for (int i = 0; i < this._clustersCount; ++i) {
            this.clusters.get(i).clear();
        }
        this._clustersCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public ReplicatedSubscriptionsUpdate copyFrom(ReplicatedSubscriptionsUpdate _other) {
        this._cachedSize = -1;
        if (_other.hasSubscriptionName()) {
            this.setSubscriptionName(_other.getSubscriptionName());
        }
        for (int i = 0; i < _other.getClustersCount(); ++i) {
            this.addCluster().copyFrom(_other.getClusterAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

