/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bookkeeper.mledger.proto.PendingBookieOpsStats;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.naming.TopicName;

public class BookieClientStatsGenerator {
    private final PulsarService pulsar;
    private Map<String, Map<String, PendingBookieOpsStats>> nsBookieClientStatsMap;

    public BookieClientStatsGenerator(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.nsBookieClientStatsMap = new TreeMap<String, Map<String, PendingBookieOpsStats>>();
    }

    public static Map<String, Map<String, PendingBookieOpsStats>> generate(PulsarService pulsar) throws Exception {
        return new BookieClientStatsGenerator(pulsar).generate();
    }

    private Map<String, Map<String, PendingBookieOpsStats>> generate() throws Exception {
        if (this.pulsar.getBrokerService() != null && this.pulsar.getBrokerService().getTopics() != null) {
            this.pulsar.getBrokerService().forEachTopic(topic -> {
                if (topic instanceof PersistentTopic) {
                    PersistentTopic persistentTopic = (PersistentTopic)topic;
                    TopicName topicName = TopicName.get((String)persistentTopic.getName());
                    this.put(topicName, persistentTopic.getManagedLedger().getStats().getPendingBookieOpsStats());
                }
            });
        }
        return this.nsBookieClientStatsMap;
    }

    private void put(TopicName topicName, PendingBookieOpsStats bookieOpsStats) {
        String namespace = topicName.getNamespace();
        if (!this.nsBookieClientStatsMap.containsKey(namespace)) {
            HashMap<String, PendingBookieOpsStats> destBookieClientStatsMap = new HashMap<String, PendingBookieOpsStats>();
            destBookieClientStatsMap.put(topicName.toString(), bookieOpsStats);
            this.nsBookieClientStatsMap.put(namespace, destBookieClientStatsMap);
        } else {
            this.nsBookieClientStatsMap.get(namespace).put(topicName.toString(), bookieOpsStats);
        }
    }
}

