/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.compaction.CompactionRecord;
import org.apache.pulsar.compaction.CompactorMXBean;

public class CompactorMXBeanImpl
implements CompactorMXBean {
    private final ConcurrentHashMap<String, CompactionRecord> compactionRecordOps = new ConcurrentHashMap();

    public void addCompactionRemovedEvent(String topic) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionRemovedEvent();
    }

    public void addCompactionStartOp(String topic) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionStartOp();
    }

    public void addCompactionEndOp(String topic, boolean succeed) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionEndOp(succeed);
    }

    @Override
    public void removeTopic(String topic) {
        this.compactionRecordOps.remove(topic);
    }

    @Override
    public Optional<CompactionRecord> getCompactionRecordForTopic(String topic) {
        return Optional.ofNullable(this.compactionRecordOps.get(topic));
    }

    public Set<String> getTopics() {
        return this.compactionRecordOps.keySet();
    }

    public void reset() {
        this.compactionRecordOps.values().forEach(CompactionRecord::reset);
    }

    public void addCompactionReadOp(String topic, long readableBytes) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionReadOp(readableBytes);
    }

    public void addCompactionWriteOp(String topic, long writeableBytes) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionWriteOp(writeableBytes);
    }

    public void addCompactionLatencyOp(String topic, long latency, TimeUnit unit) {
        this.compactionRecordOps.computeIfAbsent(topic, k -> new CompactionRecord()).addCompactionLatencyOp(latency, unit);
    }
}

