/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.compaction.CompactionServiceFactory;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.PulsarTopicCompactionService;
import org.apache.pulsar.compaction.TopicCompactionService;
import org.apache.pulsar.compaction.TwoPhaseCompactor;

public class PulsarCompactionServiceFactory
implements CompactionServiceFactory {
    private PulsarService pulsarService;
    private volatile Compactor compactor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Compactor getCompactor() throws PulsarServerException {
        if (this.compactor == null) {
            PulsarCompactionServiceFactory pulsarCompactionServiceFactory = this;
            synchronized (pulsarCompactionServiceFactory) {
                if (this.compactor == null) {
                    this.compactor = this.newCompactor();
                }
            }
        }
        return this.compactor;
    }

    @Nullable
    public Compactor getNullableCompactor() {
        return this.compactor;
    }

    protected Compactor newCompactor() throws PulsarServerException {
        return new TwoPhaseCompactor(this.pulsarService.getConfiguration(), this.pulsarService.getClient(), this.pulsarService.getBookKeeperClient(), this.pulsarService.getCompactorExecutor());
    }

    @Override
    public CompletableFuture<Void> initialize(@Nonnull PulsarService pulsarService) {
        Objects.requireNonNull(pulsarService);
        this.pulsarService = pulsarService;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<TopicCompactionService> newTopicCompactionService(@Nonnull String topic) {
        Objects.requireNonNull(topic);
        PulsarTopicCompactionService pulsarTopicCompactionService = new PulsarTopicCompactionService(topic, this.pulsarService.getBookKeeperClient(), () -> {
            try {
                return this.getCompactor();
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        });
        return CompletableFuture.completedFuture(pulsarTopicCompactionService);
    }

    @Override
    public void close() throws Exception {
    }

    @Generated
    protected PulsarService getPulsarService() {
        return this.pulsarService;
    }
}

