/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.OneStageAuthenticationState;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.util.FutureUtil;

public interface AuthenticationProvider
extends Closeable {
    public void initialize(ServiceConfiguration var1) throws IOException;

    public String getAuthMethodName();

    default public CompletableFuture<String> authenticateAsync(AuthenticationDataSource authData) {
        try {
            return CompletableFuture.completedFuture(this.authenticate(authData));
        }
        catch (AuthenticationException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    @Deprecated
    default public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        throw new AuthenticationException("Not supported");
    }

    default public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        return new OneStageAuthenticationState(authData, remoteAddress, sslSession, this);
    }

    @Deprecated(since="3.0.0")
    default public AuthenticationState newHttpAuthState(HttpServletRequest request) throws AuthenticationException {
        return new OneStageAuthenticationState(request, this);
    }

    default public CompletableFuture<Boolean> authenticateHttpRequestAsync(HttpServletRequest request, HttpServletResponse response) {
        try {
            return CompletableFuture.completedFuture(this.authenticateHttpRequest(request, response));
        }
        catch (Exception e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    default public void incrementFailureMetric(Enum<?> errorCode) {
        AuthenticationMetrics.authenticateFailure(this.getClass().getSimpleName(), this.getAuthMethodName(), errorCode);
    }

    @Deprecated
    default public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AuthenticationState authenticationState = this.newHttpAuthState(request);
            String role = this.authenticateAsync(authenticationState.getAuthDataSource()).get();
            request.setAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName, (Object)role);
            request.setAttribute(AuthenticationFilter.AuthenticatedDataAttributeName, (Object)authenticationState.getAuthDataSource());
            return true;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            throw new AuthenticationException("Failed to authentication http request");
        }
    }
}

