/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.domain;

import java.util.Date;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.jclouds.b2.domain.Action;
import org.jclouds.b2.domain.AutoValue_B2Object;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class B2Object {
    public abstract String fileId();

    public abstract String fileName();

    @Nullable
    public abstract String contentSha1();

    @Nullable
    public abstract Map<String, String> fileInfo();

    @Nullable
    public abstract Payload payload();

    @Nullable
    public abstract Date uploadTimestamp();

    @Nullable
    public abstract Action action();

    @Nullable
    public abstract String accountId();

    @Nullable
    public abstract String bucketId();

    @Nullable
    public abstract Long contentLength();

    @Nullable
    public abstract String contentType();

    @Nullable
    public abstract String contentRange();

    @SerializedNames(value={"fileId", "fileName", "accountId", "bucketId", "contentLength", "contentSha1", "contentType", "fileInfo", "action", "uploadTimestamp", "contentRange", "payload"})
    public static B2Object create(String fileId, String fileName, @Nullable String accountId, @Nullable String bucketId, @Nullable Long contentLength, @Nullable String contentSha1, @Nullable String contentType, @Nullable Map<String, String> fileInfo, @Nullable Action action, @Nullable Long uploadTimestamp, @Nullable String contentRange, @Nullable Payload payload) {
        if (fileInfo != null) {
            fileInfo = ImmutableMap.copyOf(fileInfo);
        }
        Date date = uploadTimestamp == null ? null : new Date(uploadTimestamp);
        return new AutoValue_B2Object(fileId, fileName, contentSha1, fileInfo, payload, date, action, accountId, bucketId, contentLength, contentType, contentRange);
    }
}

