/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jclouds;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.jclouds.ContextBuilder;
import org.jclouds.http.apachehc.config.ApacheHCHttpCommandExecutorServiceModule;
import org.jclouds.http.okhttp.config.OkHttpCommandExecutorServiceModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShadedJCloudsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShadedJCloudsUtils.class);
    private static final boolean ENABLE_APACHE_HC_MODULE = Boolean.parseBoolean(System.getProperty("pulsar.jclouds.use_apache_hc", "false"));
    private static final boolean ENABLE_OKHTTP_MODULE = Boolean.parseBoolean(System.getProperty("pulsar.jclouds.use_okhttp", "false"));

    public static void addStandardModules(ContextBuilder builder) {
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
        modules.add(new SLF4JLoggingModule());
        if (ENABLE_OKHTTP_MODULE) {
            modules.add(new OkHttpCommandExecutorServiceModule());
        } else if (ENABLE_APACHE_HC_MODULE) {
            modules.add(new ApacheHCHttpCommandExecutorServiceModule());
        }
        builder.modules(modules);
    }

    @Generated
    private ShadedJCloudsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        log.info("Considering -Dpulsar.jclouds.use_apache_hc=" + ENABLE_APACHE_HC_MODULE);
        log.info("Considering -Dpulsar.jclouds.use_okhttp=" + ENABLE_OKHTTP_MODULE);
    }
}

